/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.expositionformats;

import io.prometheus.metrics.config.EscapingScheme;
import io.prometheus.metrics.expositionformats.ExpositionFormatWriter;
import io.prometheus.metrics.expositionformats.NameType;
import io.prometheus.metrics.expositionformats.TextFormatUtil;
import io.prometheus.metrics.model.snapshots.ClassicHistogramBuckets;
import io.prometheus.metrics.model.snapshots.CounterSnapshot;
import io.prometheus.metrics.model.snapshots.DataPointSnapshot;
import io.prometheus.metrics.model.snapshots.DistributionDataPointSnapshot;
import io.prometheus.metrics.model.snapshots.Exemplar;
import io.prometheus.metrics.model.snapshots.Exemplars;
import io.prometheus.metrics.model.snapshots.GaugeSnapshot;
import io.prometheus.metrics.model.snapshots.HistogramSnapshot;
import io.prometheus.metrics.model.snapshots.InfoSnapshot;
import io.prometheus.metrics.model.snapshots.Labels;
import io.prometheus.metrics.model.snapshots.MetricMetadata;
import io.prometheus.metrics.model.snapshots.MetricSnapshot;
import io.prometheus.metrics.model.snapshots.MetricSnapshots;
import io.prometheus.metrics.model.snapshots.PrometheusNaming;
import io.prometheus.metrics.model.snapshots.Quantile;
import io.prometheus.metrics.model.snapshots.SnapshotEscaper;
import io.prometheus.metrics.model.snapshots.StateSetSnapshot;
import io.prometheus.metrics.model.snapshots.SummarySnapshot;
import io.prometheus.metrics.model.snapshots.UnknownSnapshot;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Nullable;

public class OpenMetricsTextFormatWriter
implements ExpositionFormatWriter {
    public static final String CONTENT_TYPE = "application/openmetrics-text; version=1.0.0; charset=utf-8";
    private final boolean createdTimestampsEnabled;
    private final boolean exemplarsOnAllMetricTypesEnabled;

    public OpenMetricsTextFormatWriter(boolean createdTimestampsEnabled, boolean exemplarsOnAllMetricTypesEnabled) {
        this.createdTimestampsEnabled = createdTimestampsEnabled;
        this.exemplarsOnAllMetricTypesEnabled = exemplarsOnAllMetricTypesEnabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static OpenMetricsTextFormatWriter create() {
        return OpenMetricsTextFormatWriter.builder().build();
    }

    @Override
    public boolean accepts(@Nullable String acceptHeader) {
        if (acceptHeader == null) {
            return false;
        }
        return acceptHeader.contains("application/openmetrics-text");
    }

    @Override
    public String getContentType() {
        return CONTENT_TYPE;
    }

    @Override
    public void write(OutputStream out, MetricSnapshots metricSnapshots, EscapingScheme scheme) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
        for (MetricSnapshot s : metricSnapshots) {
            MetricSnapshot snapshot = SnapshotEscaper.escapeMetricSnapshot((MetricSnapshot)s, (EscapingScheme)scheme);
            if (snapshot.getDataPoints().isEmpty()) continue;
            if (snapshot instanceof CounterSnapshot) {
                this.writeCounter(writer, (CounterSnapshot)snapshot, scheme);
                continue;
            }
            if (snapshot instanceof GaugeSnapshot) {
                this.writeGauge(writer, (GaugeSnapshot)snapshot, scheme);
                continue;
            }
            if (snapshot instanceof HistogramSnapshot) {
                this.writeHistogram(writer, (HistogramSnapshot)snapshot, scheme);
                continue;
            }
            if (snapshot instanceof SummarySnapshot) {
                this.writeSummary(writer, (SummarySnapshot)snapshot, scheme);
                continue;
            }
            if (snapshot instanceof InfoSnapshot) {
                this.writeInfo(writer, (InfoSnapshot)snapshot, scheme);
                continue;
            }
            if (snapshot instanceof StateSetSnapshot) {
                this.writeStateSet(writer, (StateSetSnapshot)snapshot, scheme);
                continue;
            }
            if (!(snapshot instanceof UnknownSnapshot)) continue;
            this.writeUnknown(writer, (UnknownSnapshot)snapshot, scheme);
        }
        writer.write("# EOF\n");
        ((Writer)writer).flush();
    }

    private void writeCounter(Writer writer, CounterSnapshot snapshot, EscapingScheme scheme) throws IOException {
        MetricMetadata metadata = snapshot.getMetadata();
        this.writeMetadata(writer, "counter", metadata, scheme);
        for (CounterSnapshot.CounterDataPointSnapshot data : snapshot.getDataPoints()) {
            this.writeNameAndLabels(writer, SnapshotEscaper.getMetadataName((MetricMetadata)metadata, (EscapingScheme)scheme), "_total", data.getLabels(), scheme);
            TextFormatUtil.writeDouble(writer, data.getValue());
            this.writeScrapeTimestampAndExemplar(writer, (DataPointSnapshot)data, data.getExemplar(), scheme);
            this.writeCreated(writer, metadata, (DataPointSnapshot)data, scheme);
        }
    }

    private void writeGauge(Writer writer, GaugeSnapshot snapshot, EscapingScheme scheme) throws IOException {
        MetricMetadata metadata = snapshot.getMetadata();
        this.writeMetadata(writer, "gauge", metadata, scheme);
        for (GaugeSnapshot.GaugeDataPointSnapshot data : snapshot.getDataPoints()) {
            this.writeNameAndLabels(writer, SnapshotEscaper.getMetadataName((MetricMetadata)metadata, (EscapingScheme)scheme), null, data.getLabels(), scheme);
            TextFormatUtil.writeDouble(writer, data.getValue());
            if (this.exemplarsOnAllMetricTypesEnabled) {
                this.writeScrapeTimestampAndExemplar(writer, (DataPointSnapshot)data, data.getExemplar(), scheme);
                continue;
            }
            this.writeScrapeTimestampAndExemplar(writer, (DataPointSnapshot)data, null, scheme);
        }
    }

    private void writeHistogram(Writer writer, HistogramSnapshot snapshot, EscapingScheme scheme) throws IOException {
        MetricMetadata metadata = snapshot.getMetadata();
        if (snapshot.isGaugeHistogram()) {
            this.writeMetadata(writer, "gaugehistogram", metadata, scheme);
            this.writeClassicHistogramBuckets(writer, metadata, "_gcount", "_gsum", snapshot.getDataPoints(), scheme);
        } else {
            this.writeMetadata(writer, "histogram", metadata, scheme);
            this.writeClassicHistogramBuckets(writer, metadata, "_count", "_sum", snapshot.getDataPoints(), scheme);
        }
    }

    private void writeClassicHistogramBuckets(Writer writer, MetricMetadata metadata, String countSuffix, String sumSuffix, List<HistogramSnapshot.HistogramDataPointSnapshot> dataList, EscapingScheme scheme) throws IOException {
        for (HistogramSnapshot.HistogramDataPointSnapshot data : dataList) {
            ClassicHistogramBuckets buckets = this.getClassicBuckets(data);
            Exemplars exemplars = data.getExemplars();
            long cumulativeCount = 0L;
            for (int i = 0; i < buckets.size(); ++i) {
                this.writeNameAndLabels(writer, SnapshotEscaper.getMetadataName((MetricMetadata)metadata, (EscapingScheme)scheme), "_bucket", data.getLabels(), scheme, "le", buckets.getUpperBound(i));
                TextFormatUtil.writeLong(writer, cumulativeCount += buckets.getCount(i));
                Exemplar exemplar = i == 0 ? exemplars.get(Double.NEGATIVE_INFINITY, buckets.getUpperBound(i)) : exemplars.get(buckets.getUpperBound(i - 1), buckets.getUpperBound(i));
                this.writeScrapeTimestampAndExemplar(writer, (DataPointSnapshot)data, exemplar, scheme);
            }
            if (data.hasCount() && data.hasSum()) {
                this.writeCountAndSum(writer, metadata, (DistributionDataPointSnapshot)data, countSuffix, sumSuffix, exemplars, scheme);
            }
            this.writeCreated(writer, metadata, (DataPointSnapshot)data, scheme);
        }
    }

    private ClassicHistogramBuckets getClassicBuckets(HistogramSnapshot.HistogramDataPointSnapshot data) {
        if (data.getClassicBuckets().isEmpty()) {
            return ClassicHistogramBuckets.of((double[])new double[]{Double.POSITIVE_INFINITY}, (long[])new long[]{data.getCount()});
        }
        return data.getClassicBuckets();
    }

    private void writeSummary(Writer writer, SummarySnapshot snapshot, EscapingScheme scheme) throws IOException {
        boolean metadataWritten = false;
        MetricMetadata metadata = snapshot.getMetadata();
        for (SummarySnapshot.SummaryDataPointSnapshot data : snapshot.getDataPoints()) {
            if (data.getQuantiles().size() == 0 && !data.hasCount() && !data.hasSum()) continue;
            if (!metadataWritten) {
                this.writeMetadata(writer, "summary", metadata, scheme);
                metadataWritten = true;
            }
            Exemplars exemplars = data.getExemplars();
            int exemplarIndex = 1;
            for (Quantile quantile : data.getQuantiles()) {
                this.writeNameAndLabels(writer, SnapshotEscaper.getMetadataName((MetricMetadata)metadata, (EscapingScheme)scheme), null, data.getLabels(), scheme, "quantile", quantile.getQuantile());
                TextFormatUtil.writeDouble(writer, quantile.getValue());
                if (exemplars.size() > 0 && this.exemplarsOnAllMetricTypesEnabled) {
                    exemplarIndex = (exemplarIndex + 1) % exemplars.size();
                    this.writeScrapeTimestampAndExemplar(writer, (DataPointSnapshot)data, exemplars.get(exemplarIndex), scheme);
                    continue;
                }
                this.writeScrapeTimestampAndExemplar(writer, (DataPointSnapshot)data, null, scheme);
            }
            this.writeCountAndSum(writer, metadata, (DistributionDataPointSnapshot)data, "_count", "_sum", exemplars, scheme);
            this.writeCreated(writer, metadata, (DataPointSnapshot)data, scheme);
        }
    }

    private void writeInfo(Writer writer, InfoSnapshot snapshot, EscapingScheme scheme) throws IOException {
        MetricMetadata metadata = snapshot.getMetadata();
        this.writeMetadata(writer, "info", metadata, scheme);
        for (InfoSnapshot.InfoDataPointSnapshot data : snapshot.getDataPoints()) {
            this.writeNameAndLabels(writer, SnapshotEscaper.getMetadataName((MetricMetadata)metadata, (EscapingScheme)scheme), "_info", data.getLabels(), scheme);
            writer.write("1");
            this.writeScrapeTimestampAndExemplar(writer, (DataPointSnapshot)data, null, scheme);
        }
    }

    private void writeStateSet(Writer writer, StateSetSnapshot snapshot, EscapingScheme scheme) throws IOException {
        MetricMetadata metadata = snapshot.getMetadata();
        this.writeMetadata(writer, "stateset", metadata, scheme);
        for (StateSetSnapshot.StateSetDataPointSnapshot data : snapshot.getDataPoints()) {
            for (int i = 0; i < data.size(); ++i) {
                writer.write(SnapshotEscaper.getMetadataName((MetricMetadata)metadata, (EscapingScheme)scheme));
                writer.write(123);
                Labels labels = data.getLabels();
                for (int j = 0; j < labels.size(); ++j) {
                    if (j > 0) {
                        writer.write(",");
                    }
                    writer.write(SnapshotEscaper.getSnapshotLabelName((Labels)labels, (int)j, (EscapingScheme)scheme));
                    writer.write("=\"");
                    TextFormatUtil.writeEscapedString(writer, labels.getValue(j));
                    writer.write("\"");
                }
                if (!labels.isEmpty()) {
                    writer.write(",");
                }
                writer.write(SnapshotEscaper.getMetadataName((MetricMetadata)metadata, (EscapingScheme)scheme));
                writer.write("=\"");
                TextFormatUtil.writeEscapedString(writer, data.getName(i));
                writer.write("\"} ");
                if (data.isTrue(i)) {
                    writer.write("1");
                } else {
                    writer.write("0");
                }
                this.writeScrapeTimestampAndExemplar(writer, (DataPointSnapshot)data, null, scheme);
            }
        }
    }

    private void writeUnknown(Writer writer, UnknownSnapshot snapshot, EscapingScheme scheme) throws IOException {
        MetricMetadata metadata = snapshot.getMetadata();
        this.writeMetadata(writer, "unknown", metadata, scheme);
        for (UnknownSnapshot.UnknownDataPointSnapshot data : snapshot.getDataPoints()) {
            this.writeNameAndLabels(writer, SnapshotEscaper.getMetadataName((MetricMetadata)metadata, (EscapingScheme)scheme), null, data.getLabels(), scheme);
            TextFormatUtil.writeDouble(writer, data.getValue());
            if (this.exemplarsOnAllMetricTypesEnabled) {
                this.writeScrapeTimestampAndExemplar(writer, (DataPointSnapshot)data, data.getExemplar(), scheme);
                continue;
            }
            this.writeScrapeTimestampAndExemplar(writer, (DataPointSnapshot)data, null, scheme);
        }
    }

    private void writeCountAndSum(Writer writer, MetricMetadata metadata, DistributionDataPointSnapshot data, String countSuffix, String sumSuffix, Exemplars exemplars, EscapingScheme scheme) throws IOException {
        if (data.hasCount()) {
            this.writeNameAndLabels(writer, SnapshotEscaper.getMetadataName((MetricMetadata)metadata, (EscapingScheme)scheme), countSuffix, data.getLabels(), scheme);
            TextFormatUtil.writeLong(writer, data.getCount());
            if (this.exemplarsOnAllMetricTypesEnabled) {
                this.writeScrapeTimestampAndExemplar(writer, (DataPointSnapshot)data, exemplars.getLatest(), scheme);
            } else {
                this.writeScrapeTimestampAndExemplar(writer, (DataPointSnapshot)data, null, scheme);
            }
        }
        if (data.hasSum()) {
            this.writeNameAndLabels(writer, SnapshotEscaper.getMetadataName((MetricMetadata)metadata, (EscapingScheme)scheme), sumSuffix, data.getLabels(), scheme);
            TextFormatUtil.writeDouble(writer, data.getSum());
            this.writeScrapeTimestampAndExemplar(writer, (DataPointSnapshot)data, null, scheme);
        }
    }

    private void writeCreated(Writer writer, MetricMetadata metadata, DataPointSnapshot data, EscapingScheme scheme) throws IOException {
        if (this.createdTimestampsEnabled && data.hasCreatedTimestamp()) {
            this.writeNameAndLabels(writer, SnapshotEscaper.getMetadataName((MetricMetadata)metadata, (EscapingScheme)scheme), "_created", data.getLabels(), scheme);
            TextFormatUtil.writeOpenMetricsTimestamp(writer, data.getCreatedTimestampMillis());
            if (data.hasScrapeTimestamp()) {
                writer.write(32);
                TextFormatUtil.writeOpenMetricsTimestamp(writer, data.getScrapeTimestampMillis());
            }
            writer.write(10);
        }
    }

    private void writeNameAndLabels(Writer writer, String name, @Nullable String suffix, Labels labels, EscapingScheme escapingScheme) throws IOException {
        this.writeNameAndLabels(writer, name, suffix, labels, escapingScheme, null, 0.0);
    }

    private void writeNameAndLabels(Writer writer, String name, @Nullable String suffix, Labels labels, EscapingScheme escapingScheme, @Nullable String additionalLabelName, double additionalLabelValue) throws IOException {
        boolean metricInsideBraces = false;
        if (!PrometheusNaming.isValidLegacyMetricName((String)name)) {
            metricInsideBraces = true;
            writer.write(123);
        }
        TextFormatUtil.writeName(writer, name + (suffix != null ? suffix : ""), NameType.Metric);
        if (!labels.isEmpty() || additionalLabelName != null) {
            TextFormatUtil.writeLabels(writer, labels, additionalLabelName, additionalLabelValue, metricInsideBraces, escapingScheme);
        } else if (metricInsideBraces) {
            writer.write(125);
        }
        writer.write(32);
    }

    private void writeScrapeTimestampAndExemplar(Writer writer, DataPointSnapshot data, @Nullable Exemplar exemplar, EscapingScheme scheme) throws IOException {
        if (data.hasScrapeTimestamp()) {
            writer.write(32);
            TextFormatUtil.writeOpenMetricsTimestamp(writer, data.getScrapeTimestampMillis());
        }
        if (exemplar != null) {
            writer.write(" # ");
            TextFormatUtil.writeLabels(writer, exemplar.getLabels(), null, 0.0, false, scheme);
            writer.write(32);
            TextFormatUtil.writeDouble(writer, exemplar.getValue());
            if (exemplar.hasTimestamp()) {
                writer.write(32);
                TextFormatUtil.writeOpenMetricsTimestamp(writer, exemplar.getTimestampMillis());
            }
        }
        writer.write(10);
    }

    private void writeMetadata(Writer writer, String typeName, MetricMetadata metadata, EscapingScheme scheme) throws IOException {
        writer.write("# TYPE ");
        TextFormatUtil.writeName(writer, SnapshotEscaper.getMetadataName((MetricMetadata)metadata, (EscapingScheme)scheme), NameType.Metric);
        writer.write(32);
        writer.write(typeName);
        writer.write(10);
        if (metadata.getUnit() != null) {
            writer.write("# UNIT ");
            TextFormatUtil.writeName(writer, SnapshotEscaper.getMetadataName((MetricMetadata)metadata, (EscapingScheme)scheme), NameType.Metric);
            writer.write(32);
            TextFormatUtil.writeEscapedString(writer, metadata.getUnit().toString());
            writer.write(10);
        }
        if (metadata.getHelp() != null && !metadata.getHelp().isEmpty()) {
            writer.write("# HELP ");
            TextFormatUtil.writeName(writer, SnapshotEscaper.getMetadataName((MetricMetadata)metadata, (EscapingScheme)scheme), NameType.Metric);
            writer.write(32);
            TextFormatUtil.writeEscapedString(writer, metadata.getHelp());
            writer.write(10);
        }
    }

    public static class Builder {
        boolean createdTimestampsEnabled;
        boolean exemplarsOnAllMetricTypesEnabled;

        private Builder() {
        }

        public Builder setCreatedTimestampsEnabled(boolean createdTimestampsEnabled) {
            this.createdTimestampsEnabled = createdTimestampsEnabled;
            return this;
        }

        public Builder setExemplarsOnAllMetricTypesEnabled(boolean exemplarsOnAllMetricTypesEnabled) {
            this.exemplarsOnAllMetricTypesEnabled = exemplarsOnAllMetricTypesEnabled;
            return this;
        }

        public OpenMetricsTextFormatWriter build() {
            return new OpenMetricsTextFormatWriter(this.createdTimestampsEnabled, this.exemplarsOnAllMetricTypesEnabled);
        }
    }
}

