/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.spi.impl.discovery;

import com.hazelcast.client.util.AddressHelper;
import com.hazelcast.cluster.Address;
import com.hazelcast.internal.json.Json;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.json.JsonValue;
import com.hazelcast.internal.util.AddressUtil;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;

public class HazelcastCloudDiscovery {
    public static final HazelcastProperty CLOUD_URL_BASE_PROPERTY = new HazelcastProperty("hazelcast.client.cloud.url", "https://api.viridian.hazelcast.com");
    private static final String CLOUD_URL_PATH = "/cluster/discovery?token=";
    private static final String PRIVATE_ADDRESS_PROPERTY = "private-address";
    private static final String PUBLIC_ADDRESS_PROPERTY = "public-address";
    private static final String TPC_PORTS_PROPERTY = "tpc-ports";
    private static final String PUBLIC_PORT_PROPERTY = "public-port";
    private static final String PRIVATE_PORT_PROPERTY = "private-port";
    private final String endpointUrl;
    private final int connectionTimeoutInMillis;
    private final boolean tpcEnabled;

    public HazelcastCloudDiscovery(String endpointUrl, int connectionTimeoutInMillis, boolean tpcEnabled) {
        this.endpointUrl = endpointUrl;
        this.connectionTimeoutInMillis = connectionTimeoutInMillis;
        this.tpcEnabled = tpcEnabled;
    }

    public DiscoveryResponse discoverNodes() {
        try {
            return this.callService();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private DiscoveryResponse callService() throws IOException, CertificateException {
        URL url = URI.create(this.endpointUrl).toURL();
        HttpURLConnection httpsConnection = (HttpURLConnection)url.openConnection();
        httpsConnection.setRequestMethod("GET");
        httpsConnection.setConnectTimeout(this.connectionTimeoutInMillis);
        httpsConnection.setReadTimeout(this.connectionTimeoutInMillis);
        httpsConnection.setRequestProperty("Accept-Charset", StandardCharsets.UTF_8.name());
        httpsConnection.connect();
        this.checkCertificate(httpsConnection);
        HazelcastCloudDiscovery.checkError(httpsConnection);
        try (InputStreamReader reader = new InputStreamReader(httpsConnection.getInputStream(), StandardCharsets.UTF_8);){
            DiscoveryResponse discoveryResponse = HazelcastCloudDiscovery.parseJsonResponse(Json.parse(reader), this.tpcEnabled);
            return discoveryResponse;
        }
    }

    private void checkCertificate(HttpURLConnection connection) throws IOException, CertificateException {
        if (!(connection instanceof HttpsURLConnection)) {
            return;
        }
        HttpsURLConnection con = (HttpsURLConnection)connection;
        for (Certificate cert : con.getServerCertificates()) {
            if (!(cert instanceof X509Certificate)) {
                throw new CertificateException("Invalid certificate from hazelcast.cloud endpoint");
            }
            X509Certificate x509Certificate = (X509Certificate)cert;
            x509Certificate.checkValidity();
        }
    }

    static DiscoveryResponse parseJsonResponse(JsonValue jsonValue, boolean tpcEnabled) throws IOException {
        List<JsonValue> response = jsonValue.asArray().values();
        HashMap<Address, Address> privateToPublic = new HashMap<Address, Address>();
        ArrayList<Address> memberAddresses = new ArrayList<Address>(response.size());
        for (JsonValue value : response) {
            JsonObject object = value.asObject();
            String privateAddress = object.get(PRIVATE_ADDRESS_PROPERTY).asString();
            String publicAddress = object.get(PUBLIC_ADDRESS_PROPERTY).asString();
            Address publicAddr = HazelcastCloudDiscovery.createAddress(publicAddress, -1);
            Address privateAddr = HazelcastCloudDiscovery.createAddress(privateAddress, publicAddr.getPort());
            privateToPublic.put(privateAddr, publicAddr);
            memberAddresses.add(privateAddr);
            JsonValue tpcPorts = object.get(TPC_PORTS_PROPERTY);
            if (!tpcEnabled || tpcPorts == null) continue;
            try {
                for (JsonValue tpcPort : tpcPorts.asArray()) {
                    HazelcastCloudDiscovery.parseTpcPortMapping(tpcPort.asObject(), publicAddr.getHost(), privateAddr.getHost(), privateToPublic);
                }
            }
            catch (Exception ignored) {
                EmptyStatement.ignore(ignored);
            }
        }
        return new DiscoveryResponse(privateToPublic, memberAddresses);
    }

    private static void parseTpcPortMapping(JsonObject mapping, String publicHostName, String privateHostName, Map<Address, Address> privateToPublicAddresses) throws IOException {
        int privatePort = mapping.get(PRIVATE_PORT_PROPERTY).asInt();
        int publicPort = mapping.get(PUBLIC_PORT_PROPERTY).asInt();
        Address privateAddress = new Address(privateHostName, privatePort);
        Address publicAddress = new Address(publicHostName, publicPort);
        privateToPublicAddresses.put(privateAddress, publicAddress);
    }

    private static Address createAddress(String hostname, int defaultPort) throws IOException {
        AddressUtil.AddressHolder addressHolder = AddressUtil.getAddressHolder(hostname, defaultPort);
        String scopedHostName = AddressHelper.getScopedHostName(addressHolder);
        return new Address(scopedHostName, addressHolder.getPort());
    }

    private static void checkError(HttpURLConnection httpConnection) throws IOException {
        int responseCode = httpConnection.getResponseCode();
        if (responseCode != 200) {
            String errorMessage = HazelcastCloudDiscovery.extractErrorMessage(httpConnection);
            throw new IOException(errorMessage);
        }
    }

    private static String extractErrorMessage(HttpURLConnection httpConnection) {
        InputStream errorStream = httpConnection.getErrorStream();
        return errorStream == null ? "" : HazelcastCloudDiscovery.readFrom(errorStream);
    }

    private static String readFrom(InputStream stream) {
        Scanner scanner = new Scanner(stream, StandardCharsets.UTF_8).useDelimiter("\\A");
        return scanner.hasNext() ? scanner.next() : "";
    }

    public static String createUrlEndpoint(String cloudBaseUrl, String cloudToken) {
        return cloudBaseUrl + CLOUD_URL_PATH + cloudToken;
    }

    static final class DiscoveryResponse {
        private final Map<Address, Address> privateToPublicAddresses;
        private final List<Address> privateMemberAddresses;

        DiscoveryResponse(Map<Address, Address> privateToPublicAddresses, List<Address> privateMemberAddresses) {
            this.privateToPublicAddresses = privateToPublicAddresses;
            this.privateMemberAddresses = privateMemberAddresses;
        }

        public List<Address> getPrivateMemberAddresses() {
            return this.privateMemberAddresses;
        }

        public Map<Address, Address> getPrivateToPublicAddresses() {
            return this.privateToPublicAddresses;
        }
    }
}

