/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation.steps;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.operation.steps.IMapOpStep;
import com.hazelcast.map.impl.operation.steps.RemoveOpSteps;
import com.hazelcast.map.impl.operation.steps.engine.State;
import com.hazelcast.map.impl.operation.steps.engine.Step;
import com.hazelcast.map.impl.recordstore.RecordStore;
import java.util.UUID;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum TxnDeleteOpSteps implements IMapOpStep
{
    READ{

        @Override
        public void runStep(State state) {
            RecordStore recordStore = state.getRecordStore();
            Data dataKey = state.getKey();
            long threadId = state.getThreadId();
            long version = state.getVersion();
            UUID ownerUuid = state.getOwnerUuid();
            long callId = state.getOperation().getCallId();
            UUID transactionId = state.getTxnId();
            MapOperation operation = state.getOperation();
            recordStore.unlock(dataKey, ownerUuid, threadId, callId);
            Object record = recordStore.getRecord(dataKey);
            if (record == null || version == (long)record.getVersion()) {
                RemoveOpSteps.READ.runStep(state);
            }
            if (record == null) {
                operation.wbqCapacityCounter().decrement(transactionId);
            }
        }

        @Override
        public Step nextStep(State state) {
            return RemoveOpSteps.READ.nextStep(state);
        }
    };

}

