/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.form;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.CssClassNameAppender;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.Icon;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.core.util.Attributes;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.border.Border;
import org.apache.wicket.model.IModel;

public abstract class InputBorder
extends Border {
    private InputBorder(String id) {
        super(id);
    }

    public InputBorder(String id, IconType iconType) {
        this(id);
        this.addComponent((Component)new Icon(this.id(), iconType));
    }

    public InputBorder(String id, IModel<String> label) {
        this(id);
        this.addComponent((Component)new Label(this.id(), label));
    }

    public InputBorder(String id, Component component) {
        this(id);
        this.addComponent(component);
    }

    protected final void addComponent(Component component) {
        String inputGroupType = "input-group-" + this.getInputGroupType().type;
        component.add(new Behavior[]{new CssClassNameAppender(inputGroupType)});
        this.addToBorder(new Component[]{component});
    }

    protected abstract String id();

    protected Type getInputGroupType() {
        return Type.Addon;
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        Attributes.addClass(tag, "input-group");
    }

    public static enum Type {
        Addon("addon"),
        Button("btn");

        private final String type;

        private Type(String type) {
            this.type = type;
        }
    }
}

