/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Locale;
import opennlp.tools.commons.Internal;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.StringList;
import opennlp.tools.util.StringUtil;

@Internal
public class NameFinderCensus90NameStream
implements ObjectStream<StringList> {
    private final Locale locale = new Locale("en");
    private final Charset encoding;
    private final ObjectStream<String> lineStream;

    public NameFinderCensus90NameStream(ObjectStream<String> lineStream) {
        this.encoding = Charset.defaultCharset();
        this.lineStream = lineStream;
    }

    public NameFinderCensus90NameStream(InputStreamFactory in, Charset encoding) throws IOException {
        this.encoding = encoding;
        this.lineStream = new PlainTextByLineStream(in, this.encoding);
    }

    @Override
    public StringList read() throws IOException {
        int pos;
        String line = this.lineStream.read();
        StringList name = null;
        if (line != null && !StringUtil.isEmpty(line) && (pos = line.indexOf(32)) != -1) {
            String parsed = line.substring(0, pos);
            String name2 = parsed.length() > 2 && parsed.startsWith("MC") ? parsed.substring(0, 1).toUpperCase(this.locale) + parsed.substring(1, 2).toLowerCase(this.locale) + parsed.substring(2, 3).toUpperCase(this.locale) + parsed.substring(3).toLowerCase(this.locale) : parsed.substring(0, 1).toUpperCase(this.locale) + parsed.substring(1).toLowerCase(this.locale);
            name = new StringList(new String[]{name2});
        }
        return name;
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        this.lineStream.reset();
    }

    @Override
    public void close() throws IOException {
        this.lineStream.close();
    }
}

