/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.postag;

import java.io.OutputStream;
import opennlp.tools.cmdline.FineGrainedReportListener;
import opennlp.tools.log.LogPrintStream;
import opennlp.tools.postag.POSSample;
import opennlp.tools.postag.POSTaggerEvaluationMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class POSTaggerFineGrainedReportListener
extends FineGrainedReportListener
implements POSTaggerEvaluationMonitor {
    private static final Logger logger = LoggerFactory.getLogger(POSTaggerFineGrainedReportListener.class);

    public POSTaggerFineGrainedReportListener() {
        this((OutputStream)new LogPrintStream(logger));
    }

    public POSTaggerFineGrainedReportListener(OutputStream outputStream) {
        super(outputStream);
    }

    public void misclassified(POSSample reference, POSSample prediction) {
        this.statsAdd(reference, prediction);
    }

    public void correctlyClassified(POSSample reference, POSSample prediction) {
        this.statsAdd(reference, prediction);
    }

    private void statsAdd(POSSample reference, POSSample prediction) {
        this.getStats().add(reference.getSentence(), reference.getTags(), prediction.getTags());
    }

    @Override
    public void writeReport() {
        this.printGeneralStatistics();
        this.printTokenErrorRank();
        this.printTokenOccurrencesRank();
        this.printTagsErrorRank();
        this.printGeneralConfusionTable();
        this.printDetailedConfusionMatrix();
    }
}

