/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.reader;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.server.timelineservice.TimelineContext;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TimelineReaderContext
extends TimelineContext {
    private String entityType;
    private String entityId;
    private Long entityIdPrefix;
    private String doAsUser;

    public TimelineReaderContext(String clusterId, String userId, String flowName, Long flowRunId, String appId, String entityType, String entityId) {
        super(clusterId, userId, flowName, flowRunId, appId);
        this.entityType = entityType;
        this.entityId = entityId;
    }

    public TimelineReaderContext(String clusterId, String userId, String flowName, Long flowRunId, String appId, String entityType, Long entityIdPrefix, String entityId) {
        this(clusterId, userId, flowName, flowRunId, appId, entityType, entityId);
        this.entityIdPrefix = entityIdPrefix;
    }

    public TimelineReaderContext(String clusterId, String userId, String flowName, Long flowRunId, String appId, String entityType, Long entityIdPrefix, String entityId, String doasUser) {
        this(clusterId, userId, flowName, flowRunId, appId, entityType, entityId);
        this.entityIdPrefix = entityIdPrefix;
        this.doAsUser = doasUser;
    }

    public TimelineReaderContext(TimelineReaderContext other) {
        this(other.getClusterId(), other.getUserId(), other.getFlowName(), other.getFlowRunId(), other.getAppId(), other.getEntityType(), other.getEntityIdPrefix(), other.getEntityId(), other.getDoAsUser());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.entityIdPrefix == null ? 0 : this.entityIdPrefix.hashCode());
        result = 31 * result + (this.entityId == null ? 0 : this.entityId.hashCode());
        result = 31 * result + (this.entityType == null ? 0 : this.entityType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        TimelineReaderContext other = (TimelineReaderContext)obj;
        if (this.entityId == null ? other.entityId != null : !this.entityId.equals(other.entityId)) {
            return false;
        }
        return !(this.entityType == null ? other.entityType != null : !this.entityType.equals(other.entityType));
    }

    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String type) {
        this.entityType = type;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String id) {
        this.entityId = id;
    }

    public Long getEntityIdPrefix() {
        return this.entityIdPrefix;
    }

    public void setEntityIdPrefix(Long entityIdPrefix) {
        this.entityIdPrefix = entityIdPrefix;
    }

    public String getDoAsUser() {
        return this.doAsUser;
    }

    public void setDoAsUser(String doAsUser) {
        this.doAsUser = doAsUser;
    }
}

