/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.logging.Log4jUtils;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class MapreduceDependencyClasspathTool
implements Tool {
    private Configuration conf;

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public int run(String[] args) throws Exception {
        if (args.length > 0) {
            System.err.println("Usage: hbase mapredcp [-Dtmpjars=...]");
            System.err.println("  Construct a CLASSPATH containing dependency jars required to run a mapreduce");
            System.err.println("  job. By default, includes any jars detected by TableMapReduceUtils. Provide");
            System.err.println("  additional entries by specifying a comma-separated list in tmpjars.");
            return 0;
        }
        TableMapReduceUtil.addHBaseDependencyJars(this.getConf());
        System.out.println(TableMapReduceUtil.buildDependencyClasspath(this.getConf()));
        return 0;
    }

    public static void main(String[] argv) throws Exception {
        Log4jUtils.setLogLevel((String)"org.apache.hadoop.hbase", (String)"WARN");
        System.exit(ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new MapreduceDependencyClasspathTool(), (String[])argv));
    }
}

