/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

public class POSplit
extends PhysicalOperator {
    private static final long serialVersionUID = 1L;
    private FileSpec splitStore;
    private List<PhysicalPlan> myPlans = new ArrayList<PhysicalPlan>();
    private BitSet processedSet = new BitSet();
    private transient boolean inpEOP = false;

    public POSplit(OperatorKey k) {
        this(k, -1, null);
    }

    public POSplit(OperatorKey k, int rp) {
        this(k, rp, null);
    }

    public POSplit(OperatorKey k, List<PhysicalOperator> inp) {
        this(k, -1, inp);
    }

    public POSplit(OperatorKey k, int rp, List<PhysicalOperator> inp) {
        super(k, rp, inp);
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitSplit(this);
    }

    @Override
    public String name() {
        return this.getAliasString() + "Split - " + this.mKey.toString();
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return true;
    }

    public FileSpec getSplitStore() {
        return this.splitStore;
    }

    public void setSplitStore(FileSpec splitStore) {
        this.splitStore = splitStore;
    }

    public List<PhysicalPlan> getPlans() {
        return this.myPlans;
    }

    public void addPlan(PhysicalPlan inPlan) {
        this.myPlans.add(inPlan);
        this.processedSet.set(this.myPlans.size() - 1);
    }

    public void removePlan(PhysicalPlan plan) {
        this.myPlans.remove(plan);
        this.processedSet.clear(this.myPlans.size());
    }

    @Override
    public Result getNextTuple() throws ExecException {
        if (this.parentPlan.endOfAllInput) {
            return this.getStreamCloseResult();
        }
        if (this.processedSet.cardinality() == this.myPlans.size()) {
            Result inp = this.processInput();
            if (inp.returnStatus == 3 && this.parentPlan.endOfAllInput) {
                return this.getStreamCloseResult();
            }
            if (inp.returnStatus == 3 || inp.returnStatus == 2) {
                return inp;
            }
            Tuple tuple = (Tuple)inp.result;
            for (PhysicalPlan pl : this.myPlans) {
                pl.attachInput(tuple);
            }
            this.processedSet.clear();
        }
        return this.processPlan();
    }

    private Result processPlan() throws ExecException {
        int idx = this.processedSet.nextClearBit(0);
        PhysicalOperator leaf = (PhysicalOperator)this.myPlans.get(idx).getLeaves().get(0);
        Result res = this.runPipeline(leaf);
        if (res.returnStatus == 3) {
            this.processedSet.set(idx++);
            if (idx < this.myPlans.size()) {
                res = this.processPlan();
            }
        }
        return res.returnStatus == 0 || res.returnStatus == 2 ? res : RESULT_EMPTY;
    }

    private Result runPipeline(PhysicalOperator leaf) throws ExecException {
        Result res = null;
        do {
            res = leaf.getNextTuple();
        } while (res.returnStatus != 0 && (res.returnStatus == 1 || res.returnStatus != 3 && res.returnStatus != 2));
        return res;
    }

    private Result getStreamCloseResult() throws ExecException {
        int idx;
        Result res = null;
        do {
            if (this.processedSet.cardinality() == this.myPlans.size()) {
                Result inp = this.processInput();
                if (inp.returnStatus == 0) {
                    Tuple tuple = (Tuple)inp.result;
                    for (PhysicalPlan pl : this.myPlans) {
                        pl.attachInput(tuple);
                    }
                    this.inpEOP = false;
                } else if (inp.returnStatus == 3) {
                    this.inpEOP = true;
                } else if (inp.returnStatus == 1) {
                    this.inpEOP = false;
                } else if (inp.returnStatus == 2) {
                    return inp;
                }
                this.processedSet.clear();
            }
            idx = this.processedSet.nextClearBit(0);
            if (this.inpEOP) {
                this.myPlans.get((int)idx).endOfAllInput = true;
            }
            PhysicalOperator leaf = (PhysicalOperator)this.myPlans.get(idx).getLeaves().get(0);
            res = leaf.getNextTuple();
            if (res.returnStatus != 3) break;
            this.processedSet.set(idx++);
        } while (idx < this.myPlans.size() || !this.inpEOP && res.returnStatus == 3);
        return res;
    }

    @Override
    public POSplit clone() throws CloneNotSupportedException {
        POSplit opClone = (POSplit)super.clone();
        opClone.processedSet = new BitSet();
        opClone.myPlans = POSplit.clonePlans(this.myPlans);
        return opClone;
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        return null;
    }
}

