/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.streaming;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.impl.streaming.StreamingCommand;
import org.apache.pig.impl.util.UDFContext;

public class StreamingUtil {
    private static Log LOG = LogFactory.getLog(StreamingUtil.class);
    private static final String BASH = "bash";
    private static final String PATH = "PATH";

    public static ProcessBuilder createProcess(StreamingCommand command) {
        ArrayList<String> cmdArgs = new ArrayList<String>();
        String[] argv = command.getCommandArgs();
        StringBuffer argBuffer = new StringBuffer();
        for (String arg : argv) {
            argBuffer.append(arg);
            argBuffer.append(" ");
        }
        String argvAsString = argBuffer.toString();
        if (System.getProperty("os.name").toUpperCase().startsWith("WINDOWS")) {
            cmdArgs.add("cmd");
            cmdArgs.add("/c");
            cmdArgs.add(argvAsString);
        } else {
            cmdArgs.add(BASH);
            cmdArgs.add("-c");
            StringBuffer sb = new StringBuffer();
            sb.append("exec ");
            sb.append(argvAsString);
            cmdArgs.add(sb.toString());
        }
        ProcessBuilder processBuilder = new ProcessBuilder(cmdArgs.toArray(new String[cmdArgs.size()]));
        StreamingUtil.setupEnvironment(processBuilder);
        return processBuilder;
    }

    private static void setupEnvironment(ProcessBuilder pb) {
        String separator = ":";
        Configuration conf = UDFContext.getUDFContext().getJobConf();
        Map<String, String> env = pb.environment();
        StreamingUtil.addJobConfToEnvironment(conf, env);
        File dir = pb.directory();
        String cwd = dir != null ? dir.getAbsolutePath() : System.getProperty("user.dir");
        String envPath = env.get(PATH);
        envPath = envPath == null ? cwd : envPath + separator + cwd;
        env.put(PATH, envPath);
    }

    protected static void addJobConfToEnvironment(Configuration conf, Map<String, String> env) {
        String propsToSend = conf.get("pig.streaming.environment");
        LOG.debug((Object)("Properties to ship to streaming environment set in pig.streaming.environment: " + propsToSend));
        if (propsToSend == null) {
            return;
        }
        for (String prop : propsToSend.split(",")) {
            String value = conf.get(prop);
            if (value == null) {
                LOG.warn((Object)("Property set in pig.streaming.environment not found in Configuration: " + prop));
                continue;
            }
            LOG.debug((Object)("Setting property in streaming environment: " + prop));
            StreamingUtil.envPut(env, prop, value);
        }
    }

    private static void envPut(Map<String, String> env, String name, String value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Add  env entry:" + name + "=" + value));
        }
        env.put(name, value);
    }
}

