/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueResourceQuotas;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacities;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerQueueInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.PartitionQueueCapacitiesInfo;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class QueueCapacitiesInfo {
    protected List<PartitionQueueCapacitiesInfo> queueCapacitiesByPartition = new ArrayList<PartitionQueueCapacitiesInfo>();

    public QueueCapacitiesInfo() {
    }

    public QueueCapacitiesInfo(QueueCapacities capacities, QueueResourceQuotas resourceQuotas, boolean considerAMUsage) {
        if (capacities == null) {
            return;
        }
        for (String partitionName : capacities.getExistingNodeLabels()) {
            float usedCapacity = capacities.getUsedCapacity(partitionName) * 100.0f;
            float capacity = capacities.getCapacity(partitionName) * 100.0f;
            float maxCapacity = capacities.getMaximumCapacity(partitionName);
            float absCapacity = CapacitySchedulerQueueInfo.cap(capacities.getAbsoluteCapacity(partitionName), 0.0f, 1.0f) * 100.0f;
            float absUsedCapacity = CapacitySchedulerQueueInfo.cap(capacities.getAbsoluteUsedCapacity(partitionName), 0.0f, 1.0f) * 100.0f;
            float absMaxCapacity = CapacitySchedulerQueueInfo.cap(capacities.getAbsoluteMaximumCapacity(partitionName), 0.0f, 1.0f) * 100.0f;
            float maxAMLimitPercentage = capacities.getMaxAMResourcePercentage(partitionName) * 100.0f;
            if (maxCapacity < 1.0E-8f || maxCapacity > 1.0f) {
                maxCapacity = 1.0f;
            }
            this.queueCapacitiesByPartition.add(new PartitionQueueCapacitiesInfo(partitionName, capacity, usedCapacity, maxCapacity *= 100.0f, absCapacity, absUsedCapacity, absMaxCapacity, considerAMUsage ? maxAMLimitPercentage : 0.0f, resourceQuotas.getConfiguredMinResource(partitionName), resourceQuotas.getConfiguredMaxResource(partitionName), resourceQuotas.getEffectiveMinResource(partitionName), resourceQuotas.getEffectiveMaxResource(partitionName)));
        }
    }

    public QueueCapacitiesInfo(QueueCapacities capacities, QueueResourceQuotas resourceQuotas) {
        this(capacities, resourceQuotas, true);
    }

    public void add(PartitionQueueCapacitiesInfo partitionQueueCapacitiesInfo) {
        this.queueCapacitiesByPartition.add(partitionQueueCapacitiesInfo);
    }

    public List<PartitionQueueCapacitiesInfo> getQueueCapacitiesByPartition() {
        return this.queueCapacitiesByPartition;
    }

    public void setQueueCapacitiesByPartition(List<PartitionQueueCapacitiesInfo> capacities) {
        this.queueCapacitiesByPartition = capacities;
    }

    public PartitionQueueCapacitiesInfo getPartitionQueueCapacitiesInfo(String partitionName) {
        for (PartitionQueueCapacitiesInfo partitionQueueCapacitiesInfo : this.queueCapacitiesByPartition) {
            if (!partitionQueueCapacitiesInfo.getPartitionName().equals(partitionName)) continue;
            return partitionQueueCapacitiesInfo;
        }
        return new PartitionQueueCapacitiesInfo();
    }
}

