/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public abstract class AbstractTestAsyncTableScan {
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    protected static TableName TABLE_NAME = TableName.valueOf((String)"async");
    protected static byte[] FAMILY = Bytes.toBytes((String)"cf");
    protected static byte[] CQ1 = Bytes.toBytes((String)"cq1");
    protected static byte[] CQ2 = Bytes.toBytes((String)"cq2");
    protected static int COUNT = 1000;
    protected static AsyncConnection ASYNC_CONN;

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL.startMiniCluster(3);
        byte[][] splitKeys = new byte[8][];
        for (int i2 = 111; i2 < 999; i2 += 111) {
            splitKeys[i2 / 111 - 1] = Bytes.toBytes((String)String.format("%03d", i2));
        }
        TEST_UTIL.createTable(TABLE_NAME, FAMILY, (byte[][])splitKeys);
        TEST_UTIL.waitTableAvailable(TABLE_NAME);
        ASYNC_CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();
        ASYNC_CONN.getTable(TABLE_NAME).putAll(IntStream.range(0, COUNT).mapToObj(i -> new Put(Bytes.toBytes((String)String.format("%03d", i))).addColumn(FAMILY, CQ1, Bytes.toBytes((int)i)).addColumn(FAMILY, CQ2, Bytes.toBytes((int)(i * i)))).collect(Collectors.toList())).get();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        ASYNC_CONN.close();
        TEST_UTIL.shutdownMiniCluster();
    }

    protected static Scan createNormalScan() {
        return new Scan();
    }

    protected static Scan createBatchScan() {
        return new Scan().setBatch(1);
    }

    protected static Scan createSmallResultSizeScan() {
        return new Scan().setMaxResultSize(1L);
    }

    protected static Scan createBatchSmallResultSizeScan() {
        return new Scan().setBatch(1).setMaxResultSize(1L);
    }

    protected static AsyncTable<?> getRawTable() {
        return ASYNC_CONN.getTable(TABLE_NAME);
    }

    protected static AsyncTable<?> getTable() {
        return ASYNC_CONN.getTable(TABLE_NAME, (ExecutorService)ForkJoinPool.commonPool());
    }

    private static List<Pair<String, Supplier<Scan>>> getScanCreator() {
        return Arrays.asList(Pair.newPair((Object)"normal", AbstractTestAsyncTableScan::createNormalScan), Pair.newPair((Object)"batch", AbstractTestAsyncTableScan::createBatchScan), Pair.newPair((Object)"smallResultSize", AbstractTestAsyncTableScan::createSmallResultSizeScan), Pair.newPair((Object)"batchSmallResultSize", AbstractTestAsyncTableScan::createBatchSmallResultSizeScan));
    }

    /*
     * Exception decompiling
     */
    protected static List<Object[]> getScanCreatorParams() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static List<Pair<String, Supplier<AsyncTable<?>>>> getTableCreator() {
        return Arrays.asList(Pair.newPair((Object)"raw", AbstractTestAsyncTableScan::getRawTable), Pair.newPair((Object)"normal", AbstractTestAsyncTableScan::getTable));
    }

    protected static List<Object[]> getTableAndScanCreatorParams() {
        List<Pair<String, Supplier<AsyncTable<?>>>> tableCreator = AbstractTestAsyncTableScan.getTableCreator();
        List<Pair<String, Supplier<Scan>>> scanCreator = AbstractTestAsyncTableScan.getScanCreator();
        return tableCreator.stream().flatMap(tp -> scanCreator.stream().map(sp -> new Object[]{tp.getFirst(), tp.getSecond(), sp.getFirst(), sp.getSecond()})).collect(Collectors.toList());
    }

    protected abstract Scan createScan();

    protected abstract List<Result> doScan(Scan var1) throws Exception;

    protected final List<Result> convertFromBatchResult(List<Result> results) {
        Assert.assertTrue((results.size() % 2 == 0 ? 1 : 0) != 0);
        return IntStream.range(0, results.size() / 2).mapToObj(i -> {
            try {
                return Result.createCompleteResult(Arrays.asList((Result)results.get(2 * i), (Result)results.get(2 * i + 1)));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).collect(Collectors.toList());
    }

    @Test
    public void testScanAll() throws Exception {
        List<Result> results = this.doScan(this.createScan());
        TEST_UTIL.getHBaseCluster().getRegionServerThreads().stream().map(t -> t.getRegionServer()).forEach(rs -> Assert.assertEquals((String)("The scanner count of " + rs.getServerName() + " is " + rs.getRSRpcServices().getScannersCount()), (long)0L, (long)rs.getRSRpcServices().getScannersCount()));
        Assert.assertEquals((long)COUNT, (long)results.size());
        IntStream.range(0, COUNT).forEach(i -> {
            Result result = (Result)results.get(i);
            Assert.assertEquals((Object)String.format("%03d", i), (Object)Bytes.toString((byte[])result.getRow()));
            Assert.assertEquals((long)i, (long)Bytes.toInt((byte[])result.getValue(FAMILY, CQ1)));
        });
    }

    private void assertResultEquals(Result result, int i) {
        Assert.assertEquals((Object)String.format("%03d", i), (Object)Bytes.toString((byte[])result.getRow()));
        Assert.assertEquals((long)i, (long)Bytes.toInt((byte[])result.getValue(FAMILY, CQ1)));
        Assert.assertEquals((long)(i * i), (long)Bytes.toInt((byte[])result.getValue(FAMILY, CQ2)));
    }

    @Test
    public void testReversedScanAll() throws Exception {
        List<Result> results = this.doScan(this.createScan().setReversed(true));
        Assert.assertEquals((long)COUNT, (long)results.size());
        IntStream.range(0, COUNT).forEach(i -> this.assertResultEquals((Result)results.get(i), COUNT - i - 1));
    }

    @Test
    public void testScanNoStopKey() throws Exception {
        int start = 345;
        List<Result> results = this.doScan(this.createScan().withStartRow(Bytes.toBytes((String)String.format("%03d", start))));
        Assert.assertEquals((long)(COUNT - start), (long)results.size());
        IntStream.range(0, COUNT - start).forEach(i -> this.assertResultEquals((Result)results.get(i), start + i));
    }

    @Test
    public void testReverseScanNoStopKey() throws Exception {
        int start = 765;
        List<Result> results = this.doScan(this.createScan().withStartRow(Bytes.toBytes((String)String.format("%03d", start))).setReversed(true));
        Assert.assertEquals((long)(start + 1), (long)results.size());
        IntStream.range(0, start + 1).forEach(i -> this.assertResultEquals((Result)results.get(i), start - i));
    }

    @Test
    public void testScanWrongColumnFamily() throws Exception {
        try {
            this.doScan(this.createScan().addFamily(Bytes.toBytes((String)"WrongColumnFamily")));
        }
        catch (Exception e) {
            Assert.assertTrue((e instanceof NoSuchColumnFamilyException || e.getCause() instanceof NoSuchColumnFamilyException ? 1 : 0) != 0);
        }
    }

    private void testScan(int start, boolean startInclusive, int stop, boolean stopInclusive, int limit) throws Exception {
        Scan scan = this.createScan().withStartRow(Bytes.toBytes((String)String.format("%03d", start)), startInclusive).withStopRow(Bytes.toBytes((String)String.format("%03d", stop)), stopInclusive);
        if (limit > 0) {
            scan.setLimit(limit);
        }
        List<Result> results = this.doScan(scan);
        int actualStart = startInclusive ? start : start + 1;
        int actualStop = stopInclusive ? stop + 1 : stop;
        int count = actualStop - actualStart;
        if (limit > 0) {
            count = Math.min(count, limit);
        }
        Assert.assertEquals((long)count, (long)results.size());
        IntStream.range(0, count).forEach(i -> this.assertResultEquals((Result)results.get(i), actualStart + i));
    }

    private void testReversedScan(int start, boolean startInclusive, int stop, boolean stopInclusive, int limit) throws Exception {
        Scan scan = this.createScan().withStartRow(Bytes.toBytes((String)String.format("%03d", start)), startInclusive).withStopRow(Bytes.toBytes((String)String.format("%03d", stop)), stopInclusive).setReversed(true);
        if (limit > 0) {
            scan.setLimit(limit);
        }
        List<Result> results = this.doScan(scan);
        int actualStart = startInclusive ? start : start - 1;
        int actualStop = stopInclusive ? stop - 1 : stop;
        int count = actualStart - actualStop;
        if (limit > 0) {
            count = Math.min(count, limit);
        }
        Assert.assertEquals((long)count, (long)results.size());
        IntStream.range(0, count).forEach(i -> this.assertResultEquals((Result)results.get(i), actualStart - i));
    }

    @Test
    public void testScanWithStartKeyAndStopKey() throws Exception {
        this.testScan(1, true, 998, false, -1);
        this.testScan(123, true, 345, true, -1);
        this.testScan(234, true, 456, false, -1);
        this.testScan(345, false, 567, true, -1);
        this.testScan(456, false, 678, false, -1);
    }

    @Test
    public void testReversedScanWithStartKeyAndStopKey() throws Exception {
        this.testReversedScan(998, true, 1, false, -1);
        this.testReversedScan(543, true, 321, true, -1);
        this.testReversedScan(654, true, 432, false, -1);
        this.testReversedScan(765, false, 543, true, -1);
        this.testReversedScan(876, false, 654, false, -1);
    }

    @Test
    public void testScanAtRegionBoundary() throws Exception {
        this.testScan(222, true, 333, true, -1);
        this.testScan(333, true, 444, false, -1);
        this.testScan(444, false, 555, true, -1);
        this.testScan(555, false, 666, false, -1);
    }

    @Test
    public void testReversedScanAtRegionBoundary() throws Exception {
        this.testReversedScan(333, true, 222, true, -1);
        this.testReversedScan(444, true, 333, false, -1);
        this.testReversedScan(555, false, 444, true, -1);
        this.testReversedScan(666, false, 555, false, -1);
    }

    @Test
    public void testScanWithLimit() throws Exception {
        this.testScan(1, true, 998, false, 900);
        this.testScan(123, true, 234, true, 100);
        this.testScan(234, true, 456, false, 100);
        this.testScan(345, false, 567, true, 100);
        this.testScan(456, false, 678, false, 100);
    }

    @Test
    public void testScanWithLimitGreaterThanActualCount() throws Exception {
        this.testScan(1, true, 998, false, 1000);
        this.testScan(123, true, 345, true, 200);
        this.testScan(234, true, 456, false, 200);
        this.testScan(345, false, 567, true, 200);
        this.testScan(456, false, 678, false, 200);
    }

    @Test
    public void testReversedScanWithLimit() throws Exception {
        this.testReversedScan(998, true, 1, false, 900);
        this.testReversedScan(543, true, 321, true, 100);
        this.testReversedScan(654, true, 432, false, 100);
        this.testReversedScan(765, false, 543, true, 100);
        this.testReversedScan(876, false, 654, false, 100);
    }

    @Test
    public void testReversedScanWithLimitGreaterThanActualCount() throws Exception {
        this.testReversedScan(998, true, 1, false, 1000);
        this.testReversedScan(543, true, 321, true, 200);
        this.testReversedScan(654, true, 432, false, 200);
        this.testReversedScan(765, false, 543, true, 200);
        this.testReversedScan(876, false, 654, false, 200);
    }
}

