/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.regionserver.ConstantSizeRegionSplitPolicy;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.snapshot.SnapshotDoesNotExistException;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class, ClientTests.class})
public class TestSnapshotFromClient {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSnapshotFromClient.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestSnapshotFromClient.class);
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    protected static final int NUM_RS = 2;
    protected static final String STRING_TABLE_NAME = "test";
    protected static final byte[] TEST_FAM = Bytes.toBytes((String)"fam");
    protected static final TableName TABLE_NAME = TableName.valueOf((String)"test");
    private static final Pattern MATCH_ALL = Pattern.compile(".*");
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestSnapshotFromClient.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(2);
    }

    protected static void setupConf(Configuration conf) {
        conf.setInt("hbase.regionsever.info.port", -1);
        conf.setInt("hbase.hregion.memstore.flush.size", 25000);
        conf.setInt("hbase.hstore.compaction.min", 10);
        conf.setInt("hbase.hstore.compactionThreshold", 10);
        conf.setInt("hbase.hstore.blockingStoreFiles", 12);
        conf.setBoolean("hbase.snapshot.enabled", true);
        conf.set("hbase.regionserver.region.split.policy", ConstantSizeRegionSplitPolicy.class.getName());
    }

    @Before
    public void setup() throws Exception {
        this.createTable();
    }

    protected void createTable() throws Exception {
        HTableDescriptor htd = new HTableDescriptor(TABLE_NAME);
        htd.setRegionReplication(this.getNumReplicas());
        UTIL.createTable((TableDescriptor)htd, (byte[][])new byte[][]{TEST_FAM}, null);
    }

    protected int getNumReplicas() {
        return 1;
    }

    @After
    public void tearDown() throws Exception {
        UTIL.deleteTable(TABLE_NAME);
        SnapshotTestingUtils.deleteAllSnapshots(UTIL.getAdmin());
        SnapshotTestingUtils.deleteArchiveDirectory(UTIL);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn("failure shutting down cluster", (Throwable)e);
        }
    }

    @Test
    public void testMetaTablesSnapshot() throws Exception {
        Admin admin = UTIL.getAdmin();
        byte[] snapshotName = Bytes.toBytes((String)"metaSnapshot");
        try {
            admin.snapshot(snapshotName, TableName.META_TABLE_NAME);
            Assert.fail((String)"taking a snapshot of hbase:meta should not be allowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSnapshotDeletionWithRegex() throws Exception {
        Admin admin = UTIL.getAdmin();
        SnapshotTestingUtils.assertNoSnapshots(admin);
        Table table = UTIL.getConnection().getTable(TABLE_NAME);
        UTIL.loadTable(table, TEST_FAM);
        table.close();
        byte[] snapshot1 = Bytes.toBytes((String)"TableSnapshot1");
        admin.snapshot(snapshot1, TABLE_NAME);
        LOG.debug("Snapshot1 completed.");
        byte[] snapshot2 = Bytes.toBytes((String)"TableSnapshot2");
        admin.snapshot(snapshot2, TABLE_NAME);
        LOG.debug("Snapshot2 completed.");
        String snapshot3 = "3rdTableSnapshot";
        admin.snapshot(Bytes.toBytes((String)snapshot3), TABLE_NAME);
        LOG.debug(snapshot3 + " completed.");
        admin.deleteSnapshots(Pattern.compile("TableSnapshot.*"));
        List snapshots = admin.listSnapshots();
        Assert.assertEquals((long)1L, (long)snapshots.size());
        Assert.assertEquals((Object)snapshot3, (Object)((SnapshotDescription)snapshots.get(0)).getName());
        admin.deleteSnapshot(snapshot3);
        admin.close();
    }

    @Test
    public void testOfflineTableSnapshot() throws Exception {
        Admin admin = UTIL.getAdmin();
        SnapshotTestingUtils.assertNoSnapshots(admin);
        Table table = UTIL.getConnection().getTable(TABLE_NAME);
        UTIL.loadTable(table, TEST_FAM, false);
        LOG.debug("FS state before disable:");
        CommonFSUtils.logFileSystemState((FileSystem)UTIL.getTestFileSystem(), (Path)CommonFSUtils.getRootDir((Configuration)UTIL.getConfiguration()), (Logger)LOG);
        admin.disableTable(TABLE_NAME);
        LOG.debug("FS state before snapshot:");
        CommonFSUtils.logFileSystemState((FileSystem)UTIL.getTestFileSystem(), (Path)CommonFSUtils.getRootDir((Configuration)UTIL.getConfiguration()), (Logger)LOG);
        String SNAPSHOT_NAME = "offlineTableSnapshot";
        byte[] snapshot = Bytes.toBytes((String)"offlineTableSnapshot");
        admin.snapshot(new SnapshotDescription("offlineTableSnapshot", TABLE_NAME, SnapshotType.DISABLED, null, -1L, 0, null));
        LOG.debug("Snapshot completed.");
        List snapshots = SnapshotTestingUtils.assertOneSnapshotThatMatches(admin, snapshot, TABLE_NAME);
        FileSystem fs = UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getFileSystem();
        Path rootDir = UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getRootDir();
        LOG.debug("FS state after snapshot:");
        CommonFSUtils.logFileSystemState((FileSystem)UTIL.getTestFileSystem(), (Path)CommonFSUtils.getRootDir((Configuration)UTIL.getConfiguration()), (Logger)LOG);
        SnapshotTestingUtils.confirmSnapshotValid(ProtobufUtil.createHBaseProtosSnapshotDesc((SnapshotDescription)snapshots.get(0)), TABLE_NAME, TEST_FAM, rootDir, admin, fs);
        admin.deleteSnapshot(snapshot);
        snapshots = admin.listSnapshots();
        SnapshotTestingUtils.assertNoSnapshots(admin);
    }

    @Test
    public void testSnapshotFailsOnNonExistantTable() throws Exception {
        Admin admin = UTIL.getAdmin();
        SnapshotTestingUtils.assertNoSnapshots(admin);
        String tableName = "_not_a_table";
        boolean fail = false;
        do {
            try {
                admin.getTableDescriptor(TableName.valueOf((String)tableName));
                fail = true;
                LOG.error("Table:" + tableName + " already exists, checking a new name");
                tableName = tableName + "!";
            }
            catch (TableNotFoundException e) {
                fail = false;
            }
        } while (fail);
        try {
            admin.snapshot("fail", TableName.valueOf((String)tableName));
            Assert.fail((String)"Snapshot succeeded even though there is not table.");
        }
        catch (SnapshotCreationException e) {
            LOG.info("Correctly failed to snapshot a non-existant table:" + e.getMessage());
        }
    }

    @Test
    public void testOfflineTableSnapshotWithEmptyRegions() throws Exception {
        Admin admin = UTIL.getAdmin();
        SnapshotTestingUtils.assertNoSnapshots(admin);
        LOG.debug("FS state before disable:");
        CommonFSUtils.logFileSystemState((FileSystem)UTIL.getTestFileSystem(), (Path)CommonFSUtils.getRootDir((Configuration)UTIL.getConfiguration()), (Logger)LOG);
        admin.disableTable(TABLE_NAME);
        LOG.debug("FS state before snapshot:");
        CommonFSUtils.logFileSystemState((FileSystem)UTIL.getTestFileSystem(), (Path)CommonFSUtils.getRootDir((Configuration)UTIL.getConfiguration()), (Logger)LOG);
        byte[] snapshot = Bytes.toBytes((String)"testOfflineTableSnapshotWithEmptyRegions");
        admin.snapshot(snapshot, TABLE_NAME);
        LOG.debug("Snapshot completed.");
        List snapshots = SnapshotTestingUtils.assertOneSnapshotThatMatches(admin, snapshot, TABLE_NAME);
        FileSystem fs = UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getFileSystem();
        Path rootDir = UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getRootDir();
        LOG.debug("FS state after snapshot:");
        CommonFSUtils.logFileSystemState((FileSystem)UTIL.getTestFileSystem(), (Path)CommonFSUtils.getRootDir((Configuration)UTIL.getConfiguration()), (Logger)LOG);
        ArrayList emptyCfs = Lists.newArrayList((Object[])new byte[][]{TEST_FAM});
        ArrayList nonEmptyCfs = Lists.newArrayList();
        SnapshotTestingUtils.confirmSnapshotValid(ProtobufUtil.createHBaseProtosSnapshotDesc((SnapshotDescription)snapshots.get(0)), TABLE_NAME, nonEmptyCfs, emptyCfs, rootDir, admin, fs);
        admin.deleteSnapshot(snapshot);
        snapshots = admin.listSnapshots();
        SnapshotTestingUtils.assertNoSnapshots(admin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListTableSnapshots() throws Exception {
        Admin admin = null;
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            admin = UTIL.getAdmin();
            HTableDescriptor htd = new HTableDescriptor(tableName);
            UTIL.createTable((TableDescriptor)htd, (byte[][])new byte[][]{TEST_FAM}, UTIL.getConfiguration());
            String table1Snapshot1 = "Table1Snapshot1";
            admin.snapshot(table1Snapshot1, TABLE_NAME);
            LOG.debug("Snapshot1 completed.");
            String table1Snapshot2 = "Table1Snapshot2";
            admin.snapshot(table1Snapshot2, TABLE_NAME);
            LOG.debug("Snapshot2 completed.");
            String table2Snapshot1 = "Table2Snapshot1";
            admin.snapshot(Bytes.toBytes((String)table2Snapshot1), tableName);
            LOG.debug(table2Snapshot1 + " completed.");
            List listTableSnapshots = admin.listTableSnapshots(Pattern.compile("test.*"), MATCH_ALL);
            ArrayList<String> listTableSnapshotNames = new ArrayList<String>();
            Assert.assertEquals((long)3L, (long)listTableSnapshots.size());
            for (SnapshotDescription s : listTableSnapshots) {
                listTableSnapshotNames.add(s.getName());
            }
            Assert.assertTrue((boolean)listTableSnapshotNames.contains(table1Snapshot1));
            Assert.assertTrue((boolean)listTableSnapshotNames.contains(table1Snapshot2));
            Assert.assertTrue((boolean)listTableSnapshotNames.contains(table2Snapshot1));
        }
        finally {
            if (admin != null) {
                try {
                    admin.deleteSnapshots(Pattern.compile("Table.*"));
                }
                catch (SnapshotDoesNotExistException snapshotDoesNotExistException) {}
                if (admin.tableExists(tableName)) {
                    UTIL.deleteTable(tableName);
                }
                admin.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListTableSnapshotsWithRegex() throws Exception {
        Admin admin = null;
        try {
            admin = UTIL.getAdmin();
            String table1Snapshot1 = "Table1Snapshot1";
            admin.snapshot(table1Snapshot1, TABLE_NAME);
            LOG.debug("Snapshot1 completed.");
            String table1Snapshot2 = "Table1Snapshot2";
            admin.snapshot(table1Snapshot2, TABLE_NAME);
            LOG.debug("Snapshot2 completed.");
            String table2Snapshot1 = "Table2Snapshot1";
            admin.snapshot(Bytes.toBytes((String)table2Snapshot1), TABLE_NAME);
            LOG.debug(table2Snapshot1 + " completed.");
            List listTableSnapshots = admin.listTableSnapshots(Pattern.compile("test.*"), Pattern.compile("Table1.*"));
            ArrayList<String> listTableSnapshotNames = new ArrayList<String>();
            Assert.assertEquals((long)2L, (long)listTableSnapshots.size());
            for (SnapshotDescription s : listTableSnapshots) {
                listTableSnapshotNames.add(s.getName());
            }
            Assert.assertTrue((boolean)listTableSnapshotNames.contains(table1Snapshot1));
            Assert.assertTrue((boolean)listTableSnapshotNames.contains(table1Snapshot2));
            Assert.assertFalse((boolean)listTableSnapshotNames.contains(table2Snapshot1));
        }
        finally {
            if (admin != null) {
                try {
                    admin.deleteSnapshots(Pattern.compile("Table.*"));
                }
                catch (SnapshotDoesNotExistException snapshotDoesNotExistException) {}
                admin.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteTableSnapshots() throws Exception {
        Admin admin = null;
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            admin = UTIL.getAdmin();
            HTableDescriptor htd = new HTableDescriptor(tableName);
            UTIL.createTable((TableDescriptor)htd, (byte[][])new byte[][]{TEST_FAM}, UTIL.getConfiguration());
            String table1Snapshot1 = "Table1Snapshot1";
            admin.snapshot(table1Snapshot1, TABLE_NAME);
            LOG.debug("Snapshot1 completed.");
            String table1Snapshot2 = "Table1Snapshot2";
            admin.snapshot(table1Snapshot2, TABLE_NAME);
            LOG.debug("Snapshot2 completed.");
            String table2Snapshot1 = "Table2Snapshot1";
            admin.snapshot(Bytes.toBytes((String)table2Snapshot1), tableName);
            LOG.debug(table2Snapshot1 + " completed.");
            Pattern tableNamePattern = Pattern.compile("test.*");
            admin.deleteTableSnapshots(tableNamePattern, MATCH_ALL);
            Assert.assertEquals((long)0L, (long)admin.listTableSnapshots(tableNamePattern, MATCH_ALL).size());
        }
        finally {
            if (admin != null) {
                if (admin.tableExists(tableName)) {
                    UTIL.deleteTable(tableName);
                }
                admin.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteTableSnapshotsWithRegex() throws Exception {
        Admin admin = null;
        Pattern tableNamePattern = Pattern.compile("test.*");
        try {
            admin = UTIL.getAdmin();
            String table1Snapshot1 = "Table1Snapshot1";
            admin.snapshot(table1Snapshot1, TABLE_NAME);
            LOG.debug("Snapshot1 completed.");
            String table1Snapshot2 = "Table1Snapshot2";
            admin.snapshot(table1Snapshot2, TABLE_NAME);
            LOG.debug("Snapshot2 completed.");
            String table2Snapshot1 = "Table2Snapshot1";
            admin.snapshot(Bytes.toBytes((String)table2Snapshot1), TABLE_NAME);
            LOG.debug(table2Snapshot1 + " completed.");
            admin.deleteTableSnapshots(tableNamePattern, Pattern.compile("Table1.*"));
            Assert.assertEquals((long)1L, (long)admin.listTableSnapshots(tableNamePattern, MATCH_ALL).size());
        }
        finally {
            if (admin != null) {
                try {
                    admin.deleteTableSnapshots(tableNamePattern, MATCH_ALL);
                }
                catch (SnapshotDoesNotExistException snapshotDoesNotExistException) {}
                admin.close();
            }
        }
    }
}

