/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureScheduler;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureSchedulerPerformanceEvaluation;
import org.apache.hadoop.hbase.master.procedure.PeerProcedureInterface;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.master.procedure.TestMasterProcedureScheduler;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMasterProcedureSchedulerConcurrency {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterProcedureSchedulerConcurrency.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestMasterProcedureSchedulerConcurrency.class);
    private MasterProcedureScheduler queue;

    @Before
    public void setUp() throws IOException {
        this.queue = new MasterProcedureScheduler(pid -> null);
        this.queue.start();
    }

    @After
    public void tearDown() throws IOException {
        Assert.assertEquals((String)"proc-queue expected to be empty", (long)0L, (long)this.queue.size());
        this.queue.stop();
        this.queue.clear();
    }

    @Test
    public void testConcurrentPeerOperations() throws Exception {
        int i;
        final TestPeerProcedureSet procSet = new TestPeerProcedureSet(this.queue);
        int NUM_ITEMS = 10;
        final int NUM_PEERS = 5;
        final AtomicInteger opsCount = new AtomicInteger(0);
        for (int i2 = 0; i2 < NUM_PEERS; ++i2) {
            String peerId = String.format("test-peer-%04d", i2);
            for (int j = 1; j < NUM_ITEMS; ++j) {
                procSet.addBack(new TestMasterProcedureScheduler.TestPeerProcedure(i2 * 100 + j, peerId, PeerProcedureInterface.PeerOperationType.ADD));
                opsCount.incrementAndGet();
            }
        }
        Assert.assertEquals((long)opsCount.get(), (long)this.queue.size());
        Thread[] threads = new Thread[NUM_PEERS * 2];
        final HashSet concurrentPeers = new HashSet();
        final ArrayList failures = new ArrayList();
        final AtomicInteger concurrentCount = new AtomicInteger(0);
        for (i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (opsCount.get() > 0) {
                        try {
                            TestMasterProcedureScheduler.TestPeerProcedure proc = procSet.acquire();
                            if (proc == null) {
                                TestMasterProcedureSchedulerConcurrency.this.queue.signalAll();
                                if (opsCount.get() <= 0) break;
                                continue;
                            }
                            String peerId = proc.getPeerId();
                            HashSet hashSet = concurrentPeers;
                            synchronized (hashSet) {
                                Assert.assertTrue((String)("unexpected concurrency on " + peerId), (boolean)concurrentPeers.add(peerId));
                            }
                            Assert.assertTrue((opsCount.decrementAndGet() >= 0 ? 1 : 0) != 0);
                            try {
                                long procId = proc.getProcId();
                                int concurrent = concurrentCount.incrementAndGet();
                                Assert.assertTrue((String)("inc-concurrent=" + concurrent + " 1 <= concurrent <= " + NUM_PEERS), (concurrent >= 1 && concurrent <= NUM_PEERS ? 1 : 0) != 0);
                                LOG.debug("[S] peerId=" + peerId + " procId=" + procId + " concurrent=" + concurrent);
                                Thread.sleep(2000L);
                                concurrent = concurrentCount.decrementAndGet();
                                LOG.debug("[E] peerId=" + peerId + " procId=" + procId + " concurrent=" + concurrent);
                                Assert.assertTrue((String)("dec-concurrent=" + concurrent), (concurrent < NUM_PEERS ? 1 : 0) != 0);
                            }
                            finally {
                                hashSet = concurrentPeers;
                                synchronized (hashSet) {
                                    Assert.assertTrue((boolean)concurrentPeers.remove(peerId));
                                }
                                procSet.release(proc);
                            }
                        }
                        catch (Throwable e) {
                            LOG.error("Failed " + e.getMessage(), e);
                            ArrayList arrayList = failures;
                            synchronized (arrayList) {
                                failures.add(e.getMessage());
                            }
                        }
                        finally {
                            TestMasterProcedureSchedulerConcurrency.this.queue.signalAll();
                        }
                    }
                }
            };
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].join();
        }
        Assert.assertTrue((String)failures.toString(), (boolean)failures.isEmpty());
        Assert.assertEquals((long)0L, (long)opsCount.get());
        Assert.assertEquals((long)0L, (long)this.queue.size());
    }

    @Test
    public void testConcurrentWriteOps() throws Exception {
        int i;
        final TestTableProcSet procSet = new TestTableProcSet(this.queue);
        int NUM_ITEMS = 10;
        int NUM_TABLES = 4;
        final AtomicInteger opsCount = new AtomicInteger(0);
        for (int i2 = 0; i2 < 4; ++i2) {
            TableName tableName = TableName.valueOf((String)String.format("testtb-%04d", i2));
            for (int j = 1; j < 10; ++j) {
                procSet.addBack((Procedure)new TestMasterProcedureScheduler.TestTableProcedure(i2 * 100 + j, tableName, TableProcedureInterface.TableOperationType.EDIT));
                opsCount.incrementAndGet();
            }
        }
        Assert.assertEquals((long)opsCount.get(), (long)this.queue.size());
        Thread[] threads = new Thread[8];
        final HashSet concurrentTables = new HashSet();
        final ArrayList failures = new ArrayList();
        final AtomicInteger concurrentCount = new AtomicInteger(0);
        for (i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (opsCount.get() > 0) {
                        try {
                            Procedure proc = procSet.acquire();
                            if (proc == null) {
                                TestMasterProcedureSchedulerConcurrency.this.queue.signalAll();
                                if (opsCount.get() <= 0) break;
                                continue;
                            }
                            TableName tableId = procSet.getTableName(proc);
                            HashSet hashSet = concurrentTables;
                            synchronized (hashSet) {
                                Assert.assertTrue((String)("unexpected concurrency on " + tableId), (boolean)concurrentTables.add(tableId));
                            }
                            Assert.assertTrue((opsCount.decrementAndGet() >= 0 ? 1 : 0) != 0);
                            try {
                                long procId = proc.getProcId();
                                int concurrent = concurrentCount.incrementAndGet();
                                Assert.assertTrue((String)("inc-concurrent=" + concurrent + " 1 <= concurrent <= " + 4), (concurrent >= 1 && concurrent <= 4 ? 1 : 0) != 0);
                                LOG.debug("[S] tableId=" + tableId + " procId=" + procId + " concurrent=" + concurrent);
                                Thread.sleep(2000L);
                                concurrent = concurrentCount.decrementAndGet();
                                LOG.debug("[E] tableId=" + tableId + " procId=" + procId + " concurrent=" + concurrent);
                                Assert.assertTrue((String)("dec-concurrent=" + concurrent), (concurrent < 4 ? 1 : 0) != 0);
                            }
                            finally {
                                hashSet = concurrentTables;
                                synchronized (hashSet) {
                                    Assert.assertTrue((boolean)concurrentTables.remove(tableId));
                                }
                                procSet.release(proc);
                            }
                        }
                        catch (Throwable e) {
                            LOG.error("Failed " + e.getMessage(), e);
                            ArrayList arrayList = failures;
                            synchronized (arrayList) {
                                failures.add(e.getMessage());
                            }
                        }
                        finally {
                            TestMasterProcedureSchedulerConcurrency.this.queue.signalAll();
                        }
                    }
                }
            };
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].join();
        }
        Assert.assertTrue((String)failures.toString(), (boolean)failures.isEmpty());
        Assert.assertEquals((long)0L, (long)opsCount.get());
        Assert.assertEquals((long)0L, (long)this.queue.size());
        for (i = 1; i <= 4; ++i) {
            TableName table = TableName.valueOf((String)String.format("testtb-%04d", i));
            TestMasterProcedureScheduler.TestTableProcedure dummyProc = new TestMasterProcedureScheduler.TestTableProcedure(100L, table, TableProcedureInterface.TableOperationType.DELETE);
            Assert.assertTrue((String)("queue should be deleted, table=" + table), (boolean)this.queue.markTableAsDeleted(table, (Procedure)dummyProc));
        }
    }

    @Test
    public void testMasterProcedureSchedulerPerformanceEvaluation() throws Exception {
        MasterProcedureSchedulerPerformanceEvaluation.main(new String[]{"-num_ops", "1000"});
    }

    public static class TestPeerProcedureSet {
        private final MasterProcedureScheduler queue;

        public TestPeerProcedureSet(MasterProcedureScheduler queue) {
            this.queue = queue;
        }

        public void addBack(TestMasterProcedureScheduler.TestPeerProcedure proc) {
            this.queue.addBack((Procedure)proc);
        }

        public TestMasterProcedureScheduler.TestPeerProcedure acquire() {
            TestMasterProcedureScheduler.TestPeerProcedure proc = null;
            boolean waiting = true;
            block4: while (waiting && this.queue.size() > 0) {
                proc = (TestMasterProcedureScheduler.TestPeerProcedure)this.queue.poll(100000000L);
                if (proc == null) continue;
                switch (proc.getPeerOperationType()) {
                    case ADD: 
                    case REMOVE: 
                    case ENABLE: 
                    case DISABLE: 
                    case UPDATE_CONFIG: {
                        waiting = this.queue.waitPeerExclusiveLock((Procedure)proc, proc.getPeerId());
                        continue block4;
                    }
                    case REFRESH: {
                        waiting = false;
                        continue block4;
                    }
                }
                throw new UnsupportedOperationException();
            }
            return proc;
        }

        public void release(TestMasterProcedureScheduler.TestPeerProcedure proc) {
            switch (proc.getPeerOperationType()) {
                case ADD: 
                case REMOVE: 
                case ENABLE: 
                case DISABLE: 
                case UPDATE_CONFIG: {
                    this.queue.wakePeerExclusiveLock((Procedure)proc, proc.getPeerId());
                    break;
                }
                case REFRESH: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    public static class TestTableProcSet {
        private final MasterProcedureScheduler queue;

        public TestTableProcSet(MasterProcedureScheduler queue) {
            this.queue = queue;
        }

        public void addBack(Procedure proc) {
            this.queue.addBack(proc);
        }

        public void addFront(Procedure proc) {
            this.queue.addFront(proc);
        }

        public Procedure acquire() {
            Procedure proc = null;
            boolean waiting = true;
            block4: while (waiting && this.queue.size() > 0) {
                proc = this.queue.poll(100000000L);
                if (proc == null) continue;
                switch (this.getTableOperationType(proc)) {
                    case CREATE: 
                    case DELETE: 
                    case EDIT: {
                        waiting = this.queue.waitTableExclusiveLock(proc, this.getTableName(proc));
                        continue block4;
                    }
                    case READ: {
                        waiting = this.queue.waitTableSharedLock(proc, this.getTableName(proc));
                        continue block4;
                    }
                }
                throw new UnsupportedOperationException();
            }
            return proc;
        }

        public void release(Procedure proc) {
            switch (this.getTableOperationType(proc)) {
                case CREATE: 
                case DELETE: 
                case EDIT: {
                    this.queue.wakeTableExclusiveLock(proc, this.getTableName(proc));
                    break;
                }
                case READ: {
                    this.queue.wakeTableSharedLock(proc, this.getTableName(proc));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }

        public TableName getTableName(Procedure proc) {
            return ((TableProcedureInterface)proc).getTableName();
        }

        public TableProcedureInterface.TableOperationType getTableOperationType(Procedure proc) {
            return ((TableProcedureInterface)proc).getTableOperationType();
        }
    }
}

