/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
@Category(value={MediumTests.class})
public class TestMultiLogThreshold {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMultiLogThreshold.class);
    private static final TableName NAME = TableName.valueOf((String)"tableName");
    private static final byte[] TEST_FAM = Bytes.toBytes((String)"fam");
    private HBaseTestingUtility util;
    private Configuration conf;
    private int threshold;
    private HRegionServer rs;
    private RSRpcServices services;
    private Appender appender;
    @Parameterized.Parameter
    public static boolean rejectLargeBatchOp;

    @Parameterized.Parameters
    public static List<Object[]> params() {
        return Arrays.asList({false}, {true});
    }

    @Before
    public void setupTest() throws Exception {
        this.util = new HBaseTestingUtility();
        this.conf = this.util.getConfiguration();
        this.threshold = this.conf.getInt("hbase.rpc.rows.warning.threshold", 5000);
        this.conf.setBoolean("hbase.rpc.rows.size.threshold.reject", rejectLargeBatchOp);
        this.util.startMiniCluster();
        this.util.createTable(NAME, TEST_FAM);
        this.rs = this.util.getRSForFirstRegionInTable(NAME);
        this.appender = (Appender)Mockito.mock(Appender.class);
        LogManager.getLogger(RSRpcServices.class).addAppender(this.appender);
    }

    @After
    public void tearDown() throws Exception {
        LogManager.getLogger(RSRpcServices.class).removeAppender(this.appender);
        this.util.shutdownMiniCluster();
    }

    private void sendMultiRequest(int rows, ActionType actionType) throws ServiceException, IOException {
        RpcController rpcc = (RpcController)Mockito.mock(HBaseRpcController.class);
        ClientProtos.MultiRequest.Builder builder = ClientProtos.MultiRequest.newBuilder();
        int numRAs = 1;
        int numAs = 1;
        switch (actionType) {
            case REGION_ACTIONS: {
                numRAs = rows;
                break;
            }
            case ACTIONS: {
                numAs = rows;
            }
        }
        for (int i = 0; i < numRAs; ++i) {
            ClientProtos.RegionAction.Builder rab = ClientProtos.RegionAction.newBuilder();
            rab.setRegion(RequestConverter.buildRegionSpecifier((HBaseProtos.RegionSpecifier.RegionSpecifierType)HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, (byte[])new String("someStuff" + i).getBytes()));
            for (int j = 0; j < numAs; ++j) {
                ClientProtos.Action.Builder ab = ClientProtos.Action.newBuilder();
                rab.addAction(ab.build());
            }
            builder.addRegionAction(rab.build());
        }
        this.services = new RSRpcServices(this.rs);
        this.services.multi(rpcc, builder.build());
    }

    private void assertLogBatchWarnings(boolean expected) {
        ArgumentCaptor captor = ArgumentCaptor.forClass(LoggingEvent.class);
        ((Appender)Mockito.verify((Object)this.appender, (VerificationMode)Mockito.atLeastOnce())).doAppend((LoggingEvent)captor.capture());
        boolean actual = false;
        for (LoggingEvent event : captor.getAllValues()) {
            if (event.getLevel() != Level.WARN || !event.getRenderedMessage().contains("Large batch operation detected")) continue;
            actual = true;
            break;
        }
        Mockito.reset((Object[])new Appender[]{this.appender});
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testMultiLogThresholdRegionActions() throws ServiceException, IOException {
        try {
            this.sendMultiRequest(this.threshold + 1, ActionType.REGION_ACTIONS);
            Assert.assertFalse((boolean)rejectLargeBatchOp);
        }
        catch (ServiceException e) {
            Assert.assertTrue((boolean)rejectLargeBatchOp);
        }
        this.assertLogBatchWarnings(true);
        this.sendMultiRequest(this.threshold, ActionType.REGION_ACTIONS);
        this.assertLogBatchWarnings(false);
        try {
            this.sendMultiRequest(this.threshold + 1, ActionType.ACTIONS);
            Assert.assertFalse((boolean)rejectLargeBatchOp);
        }
        catch (ServiceException e) {
            Assert.assertTrue((boolean)rejectLargeBatchOp);
        }
        this.assertLogBatchWarnings(true);
        this.sendMultiRequest(this.threshold, ActionType.ACTIONS);
        this.assertLogBatchWarnings(false);
    }

    private static enum ActionType {
        REGION_ACTIONS,
        ACTIONS;

    }
}

