/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
public class TestReplicationStuckWithDeletedTableCFs {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationStuckWithDeletedTableCFs.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestReplicationStuckWithDeletedTableCFs.class);
    private static Configuration conf1 = HBaseConfiguration.create();
    private static Configuration conf2 = HBaseConfiguration.create();
    protected static HBaseTestingUtility utility1;
    protected static HBaseTestingUtility utility2;
    private static Admin admin1;
    private static Admin admin2;
    private static final TableName TABLE;
    private static final byte[] ROW;
    private static final byte[] NORMAL_FAMILY;
    private static final byte[] DROPPED_FAMILY;
    private static final byte[] QUALIFIER;
    private static final byte[] VALUE;
    private static final String PEER_ID = "1";
    private static final long SLEEP_TIME = 1000L;
    private static final int NB_RETRIES = 10;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf1.set("zookeeper.znode.parent", "/1");
        conf1.setInt("replication.source.nb.capacity", 1);
        utility1 = new HBaseTestingUtility(conf1);
        utility1.startMiniZKCluster();
        MiniZooKeeperCluster miniZK = utility1.getZkCluster();
        conf1 = utility1.getConfiguration();
        conf2 = HBaseConfiguration.create((Configuration)conf1);
        conf2.set("zookeeper.znode.parent", "/2");
        utility2 = new HBaseTestingUtility(conf2);
        utility2.setZkCluster(miniZK);
        utility1.startMiniCluster(1);
        utility2.startMiniCluster(1);
        admin1 = utility1.getAdmin();
        admin2 = utility2.getAdmin();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        utility2.shutdownMiniCluster();
        utility1.shutdownMiniCluster();
    }

    private void createTable(TableName tableName) throws Exception {
        TableDescriptor desc = this.createTableDescriptor(DROPPED_FAMILY, NORMAL_FAMILY);
        admin1.createTable(desc);
        admin2.createTable(desc);
        utility1.waitUntilAllRegionsAssigned(tableName);
        utility2.waitUntilAllRegionsAssigned(tableName);
    }

    @Test
    public void testEditsStuckBehindDeletedCFs() throws Exception {
        ReplicationPeerConfig rpc = ReplicationPeerConfig.newBuilder().setClusterKey(utility2.getClusterKey()).setReplicateAllUserTables(true).build();
        admin1.addReplicationPeer(PEER_ID, rpc);
        this.createTable(TABLE);
        admin1.disableReplicationPeer(PEER_ID);
        try (Table droppedTable = utility1.getConnection().getTable(TABLE);){
            Put put = new Put(ROW);
            put.addColumn(DROPPED_FAMILY, QUALIFIER, VALUE).addColumn(NORMAL_FAMILY, QUALIFIER, VALUE);
            droppedTable.put(put);
        }
        TableDescriptor desc = this.createTableDescriptor(new byte[][]{NORMAL_FAMILY});
        admin1.modifyTable(desc);
        admin2.modifyTable(desc);
        admin1.enableReplicationPeer(PEER_ID);
        this.verifyReplicationStuck();
        admin1.removeReplicationPeer(PEER_ID);
        admin1.disableTable(TABLE);
        admin1.deleteTable(TABLE);
        admin2.disableTable(TABLE);
        admin2.deleteTable(TABLE);
    }

    private void verifyReplicationStuck() throws Exception {
        try (Table normalTable = utility1.getConnection().getTable(TABLE);){
            Put put = new Put(ROW);
            put.addColumn(NORMAL_FAMILY, QUALIFIER, VALUE);
            normalTable.put(put);
        }
        normalTable = utility2.getConnection().getTable(TABLE);
        var2_2 = null;
        try {
            for (int i = 0; i < 10; ++i) {
                Result result = normalTable.get(new Get(ROW).addColumn(NORMAL_FAMILY, QUALIFIER));
                if (result != null && !result.isEmpty()) {
                    Assert.fail((String)("Edit should have been stuck behind dropped tables, but value is " + Bytes.toString((byte[])result.getValue(NORMAL_FAMILY, QUALIFIER))));
                    continue;
                }
                LOG.info("Row not replicated, let's wait a bit more...");
                Thread.sleep(1000L);
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (normalTable != null) {
                if (var2_2 != null) {
                    try {
                        normalTable.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    normalTable.close();
                }
            }
        }
    }

    private TableDescriptor createTableDescriptor(byte[] ... cfs) {
        return TableDescriptorBuilder.newBuilder((TableName)TABLE).setColumnFamilies((Collection)Arrays.stream(cfs).map(cf -> ColumnFamilyDescriptorBuilder.newBuilder((byte[])cf).setScope(1).build()).collect(Collectors.toList())).build();
    }

    static {
        TABLE = TableName.valueOf((String)"normal-table");
        ROW = Bytes.toBytes((String)"row");
        NORMAL_FAMILY = Bytes.toBytes((String)"nf");
        DROPPED_FAMILY = Bytes.toBytes((String)"df");
        QUALIFIER = Bytes.toBytes((String)"q");
        VALUE = Bytes.toBytes((String)"value");
    }
}

