/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.token;

import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.ipc.NettyRpcClient;
import org.apache.hadoop.hbase.security.token.ClientTokenUtil;
import org.apache.hadoop.hbase.security.token.SecureTestCluster;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={SecurityTests.class, MediumTests.class})
public class TestDelegationTokenWithEncryption
extends SecureTestCluster {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestDelegationTokenWithEncryption.class);
    @Parameterized.Parameter
    public String rpcClientImpl;
    @Rule
    public TestName testName = new TestName();

    @BeforeClass
    public static void setUp() throws Exception {
        TEST_UTIL.getConfiguration().set("hbase.rpc.protection", "privacy");
        SecureTestCluster.setUp();
        try (Connection conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());){
            Token token = ClientTokenUtil.obtainToken((Connection)conn);
            UserGroupInformation.getCurrentUser().addToken(token);
        }
    }

    @Parameterized.Parameters(name="{index}: rpcClientImpl={0}")
    public static Collection<Object> parameters() {
        return Arrays.asList(NettyRpcClient.class.getName());
    }

    @Before
    public void setUpBeforeMethod() {
        TEST_UTIL.getConfiguration().set("hbase.rpc.client.impl", this.rpcClientImpl);
    }

    private TableName getTestTableName() {
        return TableName.valueOf((String)this.testName.getMethodName().replaceAll("[^0-9A-Za-z]", "_"));
    }

    @Test
    public void testPutGetWithDelegationToken() throws Exception {
        TableName tableName = this.getTestTableName();
        byte[] family = Bytes.toBytes((String)"f");
        byte[] qualifier = Bytes.toBytes((String)"q");
        byte[] row = Bytes.toBytes((String)"row");
        byte[] value = Bytes.toBytes((String)"data");
        try (Connection conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());){
            Admin admin = conn.getAdmin();
            HTableDescriptor tableDescriptor = new HTableDescriptor(new HTableDescriptor(tableName));
            tableDescriptor.addFamily(new HColumnDescriptor(family));
            admin.createTable((TableDescriptor)tableDescriptor);
            try (Table table = conn.getTable(tableName);){
                table.put(new Put(row).addColumn(family, qualifier, value));
                Result result = table.get(new Get(row));
                Assert.assertArrayEquals((byte[])value, (byte[])result.getValue(family, qualifier));
            }
        }
    }
}

