/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockReportLeaseManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.Namesystem;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestSortLocatedBlock {
    private static final long STALE_INTERVAL = 1800000L;

    @Test(timeout=30000L)
    public void testWithStaleDatanodes() throws IOException {
        long blockID = Long.MIN_VALUE;
        int totalDns = 5;
        DatanodeInfo[] locs = new DatanodeInfo[totalDns];
        for (int i = 0; i < totalDns; ++i) {
            String ip = i + "." + i + "." + i + "." + i;
            locs[i] = DFSTestUtil.getDatanodeInfo(ip);
            locs[i].setLastUpdateMonotonic(Time.monotonicNow());
        }
        locs[0].setDecommissioned();
        locs[2].setDecommissioned();
        ArrayList<DatanodeInfo> decommissionedNodes = new ArrayList<DatanodeInfo>();
        decommissionedNodes.add(locs[0]);
        decommissionedNodes.add(locs[2]);
        locs[1].startMaintenance();
        locs[3].setLastUpdateMonotonic(Time.monotonicNow() - 30000000L - 1L);
        ArrayList<LocatedBlock> locatedBlocks = new ArrayList<LocatedBlock>();
        locatedBlocks.add(new LocatedBlock(new ExtendedBlock("pool", blockID, 1024L, new Date().getTime()), locs));
        DatanodeManager dm = TestSortLocatedBlock.mockDatanodeManager(true, false);
        dm.sortLocatedBlocks(null, locatedBlocks);
        LocatedBlock locatedBlock = (LocatedBlock)locatedBlocks.get(0);
        DatanodeInfoWithStorage[] locations = locatedBlock.getLocations();
        Assert.assertEquals((Object)locs[4].getIpAddr(), (Object)locations[0].getIpAddr());
        Assert.assertEquals((Object)locs[3].getIpAddr(), (Object)locations[1].getIpAddr());
        Assert.assertEquals((Object)locs[1].getIpAddr(), (Object)locations[2].getIpAddr());
        Assert.assertEquals((Object)true, (Object)(decommissionedNodes.contains(locations[3]) && decommissionedNodes.contains(locations[4]) ? 1 : 0));
    }

    @Test(timeout=30000L)
    public void testAviodStaleAndSlowDatanodes() throws IOException {
        DatanodeManager dm = TestSortLocatedBlock.mockDatanodeManager(true, true);
        DatanodeInfo[] locs = TestSortLocatedBlock.mockDatanodes(dm);
        ArrayList<LocatedBlock> locatedBlocks = new ArrayList<LocatedBlock>();
        locatedBlocks.add(new LocatedBlock(new ExtendedBlock("pool", Long.MIN_VALUE, 1024L, new Date().getTime()), locs));
        dm.sortLocatedBlocks(null, locatedBlocks);
        LocatedBlock locatedBlock = (LocatedBlock)locatedBlocks.get(0);
        DatanodeInfoWithStorage[] locations = locatedBlock.getLocations();
        Assert.assertEquals((Object)locs[5].getIpAddr(), (Object)locations[0].getIpAddr());
        Assert.assertEquals((Object)locs[4].getIpAddr(), (Object)locations[1].getIpAddr());
        Assert.assertEquals((Object)locs[3].getIpAddr(), (Object)locations[2].getIpAddr());
        Assert.assertEquals((Object)locs[2].getIpAddr(), (Object)locations[3].getIpAddr());
        Assert.assertEquals((Object)locs[1].getIpAddr(), (Object)locations[4].getIpAddr());
        Assert.assertEquals((Object)locs[0].getIpAddr(), (Object)locations[5].getIpAddr());
    }

    @Test(timeout=30000L)
    public void testAviodStaleDatanodes() throws IOException {
        DatanodeManager dm = TestSortLocatedBlock.mockDatanodeManager(true, false);
        DatanodeInfo[] locs = TestSortLocatedBlock.mockDatanodes(dm);
        ArrayList<LocatedBlock> locatedBlocks = new ArrayList<LocatedBlock>();
        locatedBlocks.add(new LocatedBlock(new ExtendedBlock("pool", Long.MIN_VALUE, 1024L, new Date().getTime()), locs));
        dm.sortLocatedBlocks(null, locatedBlocks);
        LocatedBlock locatedBlock = (LocatedBlock)locatedBlocks.get(0);
        DatanodeInfoWithStorage[] locations = locatedBlock.getLocations();
        Assert.assertTrue((locs[5].getIpAddr() == locations[0].getIpAddr() && locs[4].getIpAddr() == locations[1].getIpAddr() || locs[5].getIpAddr() == locations[1].getIpAddr() && locs[4].getIpAddr() == locations[0].getIpAddr() ? 1 : 0) != 0);
        Assert.assertTrue((locs[3].getIpAddr() == locations[2].getIpAddr() && locs[2].getIpAddr() == locations[3].getIpAddr() || locs[3].getIpAddr() == locations[3].getIpAddr() && locs[2].getIpAddr() == locations[2].getIpAddr() ? 1 : 0) != 0);
        Assert.assertEquals((Object)locs[1].getIpAddr(), (Object)locations[4].getIpAddr());
        Assert.assertEquals((Object)locs[0].getIpAddr(), (Object)locations[5].getIpAddr());
    }

    @Test(timeout=30000L)
    public void testAviodSlowDatanodes() throws IOException {
        DatanodeManager dm = TestSortLocatedBlock.mockDatanodeManager(false, true);
        DatanodeInfo[] locs = TestSortLocatedBlock.mockDatanodes(dm);
        ArrayList<LocatedBlock> locatedBlocks = new ArrayList<LocatedBlock>();
        locatedBlocks.add(new LocatedBlock(new ExtendedBlock("pool", Long.MIN_VALUE, 1024L, new Date().getTime()), locs));
        dm.sortLocatedBlocks(null, locatedBlocks);
        LocatedBlock locatedBlock = (LocatedBlock)locatedBlocks.get(0);
        DatanodeInfoWithStorage[] locations = locatedBlock.getLocations();
        Assert.assertTrue((locs[5].getIpAddr() == locations[0].getIpAddr() && locs[3].getIpAddr() == locations[1].getIpAddr() || locs[5].getIpAddr() == locations[1].getIpAddr() && locs[3].getIpAddr() == locations[0].getIpAddr() ? 1 : 0) != 0);
        Assert.assertTrue((locs[4].getIpAddr() == locations[2].getIpAddr() && locs[2].getIpAddr() == locations[3].getIpAddr() || locs[4].getIpAddr() == locations[3].getIpAddr() && locs[2].getIpAddr() == locations[2].getIpAddr() ? 1 : 0) != 0);
        Assert.assertEquals((Object)locs[1].getIpAddr(), (Object)locations[4].getIpAddr());
        Assert.assertEquals((Object)locs[0].getIpAddr(), (Object)locations[5].getIpAddr());
    }

    private static DatanodeInfo[] mockDatanodes(DatanodeManager dm) {
        int totalDns = 6;
        DatanodeInfo[] locs = new DatanodeInfo[totalDns];
        for (int i = 0; i < totalDns; ++i) {
            String ip = i + "." + i + "." + i + "." + i;
            locs[i] = DFSTestUtil.getDatanodeInfo(ip);
            locs[i].setLastUpdateMonotonic(Time.monotonicNow());
        }
        locs[0].setDecommissioned();
        locs[1].startMaintenance();
        locs[2].setLastUpdateMonotonic(Time.monotonicNow() - 30000000L - 1L);
        dm.addSlowPeers(locs[2].getDatanodeUuid());
        locs[3].setLastUpdateMonotonic(Time.monotonicNow() - 30000000L - 1L);
        dm.addSlowPeers(locs[4].getDatanodeUuid());
        return locs;
    }

    private static DatanodeManager mockDatanodeManager(boolean avoidStaleDNForRead, boolean avoidSlowDNForRead) throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.namenode.avoid.read.stale.datanode", avoidStaleDNForRead);
        conf.setBoolean("dfs.namenode.avoid.read.slow.datanode", avoidSlowDNForRead);
        conf.setLong("dfs.namenode.stale.datanode.interval", 1800000L);
        FSNamesystem fsn = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        BlockManager bm = (BlockManager)Mockito.mock(BlockManager.class);
        BlockReportLeaseManager blm = new BlockReportLeaseManager(conf);
        Mockito.when((Object)bm.getBlockReportLeaseManager()).thenReturn((Object)blm);
        return new DatanodeManager(bm, (Namesystem)fsn, conf);
    }
}

