/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ipc.CallQueueInfo;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.RpcCall;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hbase.thirdparty.io.netty.util.internal.StringUtil;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class FifoRpcScheduler
extends RpcScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(FifoRpcScheduler.class);
    protected final int handlerCount;
    protected final int maxQueueLength;
    protected final AtomicInteger queueSize = new AtomicInteger(0);
    protected ThreadPoolExecutor executor;

    public FifoRpcScheduler(Configuration conf, int handlerCount) {
        this.handlerCount = handlerCount;
        this.maxQueueLength = conf.getInt("hbase.ipc.server.max.callqueue.length", handlerCount * 10);
    }

    @Override
    public void init(RpcScheduler.Context context) {
    }

    @Override
    public void start() {
        LOG.info("Using {} as user call queue; handlerCount={}; maxQueueLength={}", new Object[]{this.getClass().getSimpleName(), this.handlerCount, this.maxQueueLength});
        this.executor = new ThreadPoolExecutor(this.handlerCount, this.handlerCount, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(this.maxQueueLength), new ThreadFactoryBuilder().setNameFormat("FifoRpcScheduler.handler-pool-%d").setDaemon(true).setUncaughtExceptionHandler(Threads.LOGGING_EXCEPTION_HANDLER).build(), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    @Override
    public void stop() {
        this.executor.shutdown();
    }

    @Override
    public boolean dispatch(CallRunner task) throws IOException, InterruptedException {
        return this.executeRpcCall(this.executor, this.queueSize, task);
    }

    protected boolean executeRpcCall(ThreadPoolExecutor executor, final AtomicInteger queueSize, final CallRunner task) {
        int queued = queueSize.getAndIncrement();
        if (this.maxQueueLength > 0 && queued >= this.maxQueueLength) {
            queueSize.decrementAndGet();
            return false;
        }
        executor.execute(new FifoCallRunner(task){

            @Override
            public void run() {
                task.setStatus(RpcServer.getStatus());
                task.run();
                queueSize.decrementAndGet();
            }
        });
        return true;
    }

    @Override
    public int getGeneralQueueLength() {
        return this.executor.getQueue().size();
    }

    @Override
    public int getPriorityQueueLength() {
        return 0;
    }

    @Override
    public int getReplicationQueueLength() {
        return 0;
    }

    @Override
    public int getActiveRpcHandlerCount() {
        return this.executor.getActiveCount();
    }

    @Override
    public int getActiveGeneralRpcHandlerCount() {
        return this.getActiveRpcHandlerCount();
    }

    @Override
    public int getActivePriorityRpcHandlerCount() {
        return 0;
    }

    @Override
    public int getActiveReplicationRpcHandlerCount() {
        return 0;
    }

    @Override
    public int getActiveMetaPriorityRpcHandlerCount() {
        return 0;
    }

    @Override
    public long getNumGeneralCallsDropped() {
        return 0L;
    }

    @Override
    public long getNumLifoModeSwitches() {
        return 0L;
    }

    @Override
    public int getWriteQueueLength() {
        return 0;
    }

    @Override
    public int getReadQueueLength() {
        return 0;
    }

    @Override
    public int getScanQueueLength() {
        return 0;
    }

    @Override
    public int getActiveWriteRpcHandlerCount() {
        return 0;
    }

    @Override
    public int getActiveReadRpcHandlerCount() {
        return 0;
    }

    @Override
    public int getActiveScanRpcHandlerCount() {
        return 0;
    }

    @Override
    public int getMetaPriorityQueueLength() {
        return 0;
    }

    @Override
    public CallQueueInfo getCallQueueInfo() {
        String queueName = "Fifo Queue";
        HashMap<String, Long> methodCount = new HashMap<String, Long>();
        HashMap<String, Long> methodSize = new HashMap<String, Long>();
        CallQueueInfo callQueueInfo = new CallQueueInfo();
        callQueueInfo.setCallMethodCount(queueName, methodCount);
        callQueueInfo.setCallMethodSize(queueName, methodSize);
        this.updateMethodCountAndSizeByQueue(this.executor.getQueue(), methodCount, methodSize);
        return callQueueInfo;
    }

    protected void updateMethodCountAndSizeByQueue(BlockingQueue<Runnable> queue, HashMap<String, Long> methodCount, HashMap<String, Long> methodSize) {
        for (Runnable r : queue) {
            FifoCallRunner mcr = (FifoCallRunner)r;
            RpcCall rpcCall = mcr.getCallRunner().getRpcCall();
            String method = this.getCallMethod(mcr.getCallRunner());
            if (StringUtil.isNullOrEmpty(method)) {
                method = "Unknown";
            }
            long size = rpcCall.getSize();
            methodCount.put(method, 1L + methodCount.getOrDefault(method, 0L));
            methodSize.put(method, size + methodSize.getOrDefault(method, 0L));
        }
    }

    protected String getCallMethod(CallRunner task) {
        RpcCall call = task.getRpcCall();
        if (call != null && call.getMethod() != null) {
            return call.getMethod().getName();
        }
        return null;
    }

    private static class FifoCallRunner
    implements Runnable {
        private final CallRunner callRunner;

        FifoCallRunner(CallRunner cr) {
            this.callRunner = cr;
        }

        CallRunner getCallRunner() {
            return this.callRunner;
        }

        @Override
        public void run() {
            this.callRunner.run();
        }
    }
}

