/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.apache.avro.tool.Tool;
import org.apache.avro.tool.Util;

public class JsonToBinaryFragmentTool
implements Tool {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(InputStream stdin, PrintStream out, PrintStream err, List<String> args) throws Exception {
        String inputFile;
        Schema schema;
        OptionParser optionParser = new OptionParser();
        ArgumentAcceptingOptionSpec schemaFileOption = optionParser.accepts("schema-file", "File containing schema, must not occur with inline schema.").withOptionalArg().ofType(String.class);
        OptionSet optionSet = optionParser.parse(args.toArray(new String[0]));
        List nargs = optionSet.nonOptionArguments();
        String schemaFile = (String)schemaFileOption.value(optionSet);
        if (nargs.size() != (schemaFile == null ? 2 : 1)) {
            err.println("jsontofrag --schema-file <file> [inline-schema] input-file");
            err.println("   converts JSON to Avro fragments.");
            optionParser.printHelpOn((OutputStream)err);
            err.println("   A dash '-' for input-file means stdin.");
            return 1;
        }
        if (schemaFile == null) {
            schema = new Schema.Parser().parse((String)nargs.get(0));
            inputFile = (String)nargs.get(1);
        } else {
            schema = new Schema.Parser().parse(Util.openFromFS(schemaFile));
            inputFile = (String)nargs.get(0);
        }
        BufferedInputStream input = Util.fileOrStdin(inputFile, stdin);
        try {
            GenericDatumReader reader = new GenericDatumReader(schema);
            JsonDecoder jsonDecoder = DecoderFactory.get().jsonDecoder(schema, (InputStream)input);
            GenericDatumWriter writer = new GenericDatumWriter(schema);
            BinaryEncoder e = EncoderFactory.get().binaryEncoder((OutputStream)out, null);
            Object datum = null;
            while (true) {
                try {
                    datum = reader.read(datum, (Decoder)jsonDecoder);
                }
                catch (EOFException eofException) {
                    break;
                }
                writer.write(datum, (Encoder)e);
                e.flush();
            }
        }
        finally {
            Util.close(input);
        }
        return 0;
    }

    @Override
    public String getName() {
        return "jsontofrag";
    }

    @Override
    public String getShortDescription() {
        return "Renders a JSON-encoded Avro datum as binary.";
    }
}

