/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.directentrylogger;

import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.bookkeeper.bookie.storage.directentrylogger.Buffer;
import org.apache.bookkeeper.common.util.nativeio.NativeIO;

public class BufferPool
implements AutoCloseable {
    private final ArrayBlockingQueue<Buffer> pool;

    BufferPool(NativeIO nativeIO, ByteBufAllocator allocator, int bufferSize, int maxPoolSize) throws IOException {
        this.pool = new ArrayBlockingQueue(maxPoolSize);
        for (int i = 0; i < maxPoolSize; ++i) {
            this.pool.add(new Buffer(nativeIO, allocator, bufferSize));
        }
    }

    Buffer acquire() throws IOException {
        try {
            return this.pool.take();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new IOException(ie);
        }
    }

    void release(Buffer buffer) {
        buffer.reset();
        if (!this.pool.add(buffer)) {
            buffer.free();
        }
    }

    @Override
    public void close() {
        Buffer b;
        while ((b = this.pool.poll()) != null) {
            b.free();
        }
    }
}

