/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.extensions.store;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.loadbalance.extensions.store.LoadDataStore;
import org.apache.pulsar.broker.loadbalance.extensions.store.LoadDataStoreException;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.TableView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableViewLoadDataStoreImpl<T>
implements LoadDataStore<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TableViewLoadDataStoreImpl.class);
    private static final long LOAD_DATA_REPORT_UPDATE_MAX_INTERVAL_MULTIPLIER_BEFORE_RESTART = 2L;
    private static final String SHUTDOWN_ERR_MSG = "This load store tableview has been shutdown";
    private static final long INIT_TIMEOUT_IN_SECS = 5L;
    private volatile TableView<T> tableView;
    private volatile long tableViewLastUpdateTimestamp;
    private volatile long producerLastPublishTimestamp;
    private volatile Producer<T> producer;
    private final ServiceConfiguration conf;
    private final PulsarClient client;
    private final String topic;
    private final Class<T> clazz;
    private volatile boolean isShutdown;

    public TableViewLoadDataStoreImpl(PulsarService pulsar, String topic, Class<T> clazz) throws LoadDataStoreException {
        try {
            this.conf = pulsar.getConfiguration();
            this.client = pulsar.getClient();
            this.topic = topic;
            this.clazz = clazz;
            this.isShutdown = false;
        }
        catch (Exception e) {
            throw new LoadDataStoreException(e);
        }
    }

    @Override
    public synchronized CompletableFuture<Void> pushAsync(String key, T loadData) {
        String msg = this.validateProducer();
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return CompletableFuture.failedFuture(new IllegalStateException(msg));
        }
        return this.producer.newMessage().key(key).value(loadData).sendAsync().thenAccept(__ -> {
            this.producerLastPublishTimestamp = System.currentTimeMillis();
        });
    }

    @Override
    public synchronized CompletableFuture<Void> removeAsync(String key) {
        String msg = this.validateProducer();
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return CompletableFuture.failedFuture(new IllegalStateException(msg));
        }
        return this.producer.newMessage().key(key).value(null).sendAsync().thenAccept(__ -> {
            this.producerLastPublishTimestamp = System.currentTimeMillis();
        });
    }

    @Override
    public synchronized Optional<T> get(String key) {
        String msg = this.validateTableView();
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            if (msg.equals(SHUTDOWN_ERR_MSG)) {
                return Optional.empty();
            }
            throw new IllegalStateException(msg);
        }
        return Optional.ofNullable(this.tableView.get(key));
    }

    @Override
    public synchronized void forEach(BiConsumer<String, T> action) {
        String msg = this.validateTableView();
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            throw new IllegalStateException(msg);
        }
        this.tableView.forEach(action);
    }

    @Override
    public synchronized Set<Map.Entry<String, T>> entrySet() {
        String msg = this.validateTableView();
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            throw new IllegalStateException(msg);
        }
        return this.tableView.entrySet();
    }

    @Override
    public synchronized int size() {
        String msg = this.validateTableView();
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            throw new IllegalStateException(msg);
        }
        return this.tableView.size();
    }

    private void validateState() {
        if (this.isShutdown) {
            throw new IllegalStateException(SHUTDOWN_ERR_MSG);
        }
    }

    @Override
    public synchronized void init() throws IOException {
        this.validateState();
        this.close();
        this.start();
    }

    @Override
    public synchronized void closeTableView() throws IOException {
        this.validateState();
        if (this.tableView != null) {
            this.tableView.close();
            this.tableView = null;
        }
    }

    @Override
    public synchronized void start() throws LoadDataStoreException {
        this.validateState();
        this.startProducer();
        this.startTableView();
    }

    private synchronized void closeProducer() throws IOException {
        this.validateState();
        if (this.producer != null) {
            this.producer.close();
            this.producer = null;
        }
    }

    @Override
    public synchronized void startTableView() throws LoadDataStoreException {
        this.validateState();
        if (this.tableView == null) {
            try {
                this.tableView = (TableView)this.client.newTableViewBuilder(Schema.JSON(this.clazz)).topic(this.topic).createAsync().get(5L, TimeUnit.SECONDS);
                this.tableViewLastUpdateTimestamp = System.currentTimeMillis();
                this.tableView.forEachAndListen((k, v) -> {
                    this.tableViewLastUpdateTimestamp = System.currentTimeMillis();
                });
            }
            catch (Exception e) {
                this.tableView = null;
                throw new LoadDataStoreException(e);
            }
        }
    }

    @Override
    public synchronized void startProducer() throws LoadDataStoreException {
        this.validateState();
        if (this.producer == null) {
            try {
                this.producer = (Producer)this.client.newProducer(Schema.JSON(this.clazz)).topic(this.topic).createAsync().get(5L, TimeUnit.SECONDS);
                this.producerLastPublishTimestamp = System.currentTimeMillis();
            }
            catch (Exception e) {
                this.producer = null;
                throw new LoadDataStoreException(e);
            }
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.isShutdown) {
            return;
        }
        this.closeProducer();
        this.closeTableView();
    }

    @Override
    public synchronized void shutdown() throws IOException {
        this.close();
        this.isShutdown = true;
    }

    private String validateProducer() {
        if (this.isShutdown) {
            return SHUTDOWN_ERR_MSG;
        }
        String restartReason = this.getRestartReason(this.producer, this.producerLastPublishTimestamp);
        if (StringUtils.isNotBlank((CharSequence)restartReason)) {
            try {
                this.closeProducer();
                this.startProducer();
                log.info("Restarted producer on {}, {}", (Object)this.topic, (Object)restartReason);
            }
            catch (Exception e) {
                String msg = "Failed to restart producer on " + this.topic + ", restart reason: " + restartReason;
                log.error(msg, (Throwable)e);
                return msg;
            }
        }
        return null;
    }

    private String validateTableView() {
        if (this.isShutdown) {
            return SHUTDOWN_ERR_MSG;
        }
        String restartReason = this.getRestartReason(this.tableView, this.tableViewLastUpdateTimestamp);
        if (StringUtils.isNotBlank((CharSequence)restartReason)) {
            try {
                this.closeTableView();
                this.startTableView();
                log.info("Restarted tableview on {}, {}", (Object)this.topic, (Object)restartReason);
            }
            catch (Exception e) {
                String msg = "Failed to tableview on " + this.topic + ", restart reason: " + restartReason;
                log.error(msg, (Throwable)e);
                return msg;
            }
        }
        return null;
    }

    private String getRestartReason(Object obj, long lastUpdateTimestamp) {
        String restartReason = null;
        if (obj == null) {
            restartReason = "object is null";
        } else {
            long threshold;
            long inactiveDuration = System.currentTimeMillis() - lastUpdateTimestamp;
            if (inactiveDuration > (threshold = TimeUnit.MINUTES.toMillis(this.conf.getLoadBalancerReportUpdateMaxIntervalMinutes()) * 2L)) {
                restartReason = String.format("inactiveDuration=%d secs > threshold = %d secs", TimeUnit.MILLISECONDS.toSeconds(inactiveDuration), TimeUnit.MILLISECONDS.toSeconds(threshold));
            }
        }
        return restartReason;
    }
}

