/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.persistent;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import lombok.Generated;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.ScanOutcome;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.intercept.BrokerInterceptor;
import org.apache.pulsar.broker.loadbalance.extensions.ExtensibleLoadManagerImpl;
import org.apache.pulsar.broker.loadbalance.extensions.data.BrokerLookupData;
import org.apache.pulsar.broker.service.AbstractBaseDispatcher;
import org.apache.pulsar.broker.service.AbstractSubscription;
import org.apache.pulsar.broker.service.AnalyzeBacklogResult;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.Dispatcher;
import org.apache.pulsar.broker.service.EntryFilterSupport;
import org.apache.pulsar.broker.service.GetStatsOptions;
import org.apache.pulsar.broker.service.StickyKeyDispatcher;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.persistent.AbstractPersistentDispatcherMultipleConsumers;
import org.apache.pulsar.broker.service.persistent.PersistentDispatcherMultipleConsumers;
import org.apache.pulsar.broker.service.persistent.PersistentDispatcherMultipleConsumersClassic;
import org.apache.pulsar.broker.service.persistent.PersistentDispatcherSingleActiveConsumer;
import org.apache.pulsar.broker.service.persistent.PersistentMessageExpiryMonitor;
import org.apache.pulsar.broker.service.persistent.PersistentMessageFinder;
import org.apache.pulsar.broker.service.persistent.PersistentStickyKeyDispatcherMultipleConsumers;
import org.apache.pulsar.broker.service.persistent.PersistentStickyKeyDispatcherMultipleConsumersClassic;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.broker.service.persistent.ReplicatedSubscriptionSnapshotCache;
import org.apache.pulsar.broker.service.plugin.EntryFilter;
import org.apache.pulsar.broker.transaction.pendingack.PendingAckHandle;
import org.apache.pulsar.broker.transaction.pendingack.impl.PendingAckHandleDisabled;
import org.apache.pulsar.broker.transaction.pendingack.impl.PendingAckHandleImpl;
import org.apache.pulsar.client.api.Range;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.common.api.proto.CommandAck;
import org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.apache.pulsar.common.api.proto.KeySharedMeta;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.common.api.proto.ReplicatedSubscriptionsSnapshot;
import org.apache.pulsar.common.api.proto.TxnAction;
import org.apache.pulsar.common.naming.SystemTopicNames;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.TransactionInPendingAckStats;
import org.apache.pulsar.common.policies.data.TransactionPendingAckStats;
import org.apache.pulsar.common.policies.data.stats.ConsumerStatsImpl;
import org.apache.pulsar.common.policies.data.stats.SubscriptionStatsImpl;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.common.stats.PositionInPendingAckStats;
import org.apache.pulsar.common.util.FutureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentSubscription
extends AbstractSubscription {
    protected final PersistentTopic topic;
    protected final ManagedCursor cursor;
    protected volatile Dispatcher dispatcher;
    protected final String topicName;
    protected final String subName;
    protected final String fullName;
    private static final int FALSE = 0;
    private static final int TRUE = 1;
    private static final AtomicIntegerFieldUpdater<PersistentSubscription> IS_FENCED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(PersistentSubscription.class, "isFenced");
    private volatile int isFenced = 0;
    private PersistentMessageExpiryMonitor expiryMonitor;
    private volatile long lastExpireTimestamp = 0L;
    private volatile long lastConsumedFlowTimestamp = 0L;
    private volatile long lastMarkDeleteAdvancedTimestamp = 0L;
    private static final int MINIMUM_BACKLOG_FOR_EXPIRY_CHECK = 1000;
    protected static final String REPLICATED_SUBSCRIPTION_PROPERTY = "pulsar.replicated.subscription";
    private static final Map<String, Long> REPLICATED_SUBSCRIPTION_CURSOR_PROPERTIES = Map.of("pulsar.replicated.subscription", 1L);
    private static final Map<String, Long> NON_REPLICATED_SUBSCRIPTION_CURSOR_PROPERTIES = Map.of();
    private volatile ReplicatedSubscriptionSnapshotCache replicatedSubscriptionSnapshotCache;
    private final PendingAckHandle pendingAckHandle;
    private volatile Map<String, String> subscriptionProperties;
    private volatile CompletableFuture<Void> fenceFuture;
    private volatile CompletableFuture<Void> inProgressResetCursorFuture;
    private volatile Boolean replicatedControlled;
    private final ServiceConfiguration config;
    private final AsyncCallbacks.MarkDeleteCallback markDeleteCallback = new AsyncCallbacks.MarkDeleteCallback(){

        public void markDeleteComplete(Object ctx) {
            Position oldMD = (Position)ctx;
            Position newMD = PersistentSubscription.this.cursor.getMarkDeletedPosition();
            if (log.isDebugEnabled()) {
                log.debug("[{}][{}] Mark deleted messages to position {} from position {}", new Object[]{PersistentSubscription.this.topicName, PersistentSubscription.this.subName, newMD, oldMD});
            }
            if (PersistentSubscription.this.dispatcher != null) {
                PersistentSubscription.this.dispatcher.afterAckMessages(null, ctx);
            }
            PersistentSubscription.this.notifyTheMarkDeletePositionChanged(oldMD);
        }

        public void markDeleteFailed(ManagedLedgerException exception, Object ctx) {
            if (log.isDebugEnabled()) {
                log.debug("[{}][{}] Failed to mark delete for position {}: {}", new Object[]{PersistentSubscription.this.topicName, PersistentSubscription.this.subName, ctx, exception});
            }
            if (PersistentSubscription.this.dispatcher != null) {
                PersistentSubscription.this.dispatcher.afterAckMessages(null, ctx);
            }
        }
    };
    private final AsyncCallbacks.DeleteCallback deleteCallback = new AsyncCallbacks.DeleteCallback(){

        public void deleteComplete(Object context) {
            if (log.isDebugEnabled()) {
                log.debug("[{}][{}] Deleted message at {}", new Object[]{PersistentSubscription.this.topicName, PersistentSubscription.this.subName, context});
            }
            if (PersistentSubscription.this.dispatcher != null) {
                PersistentSubscription.this.dispatcher.afterAckMessages(null, context);
            }
            PersistentSubscription.this.notifyTheMarkDeletePositionChanged((Position)context);
        }

        public void deleteFailed(ManagedLedgerException exception, Object ctx) {
            log.warn("[{}][{}] Failed to delete message at {}: {}", new Object[]{PersistentSubscription.this.topicName, PersistentSubscription.this.subName, ctx, exception});
            if (PersistentSubscription.this.dispatcher != null) {
                PersistentSubscription.this.dispatcher.afterAckMessages(exception, ctx);
            }
        }
    };
    private static final Logger log = LoggerFactory.getLogger(PersistentSubscription.class);

    static Map<String, Long> getBaseCursorProperties(Boolean isReplicated) {
        return isReplicated != null && isReplicated != false ? REPLICATED_SUBSCRIPTION_CURSOR_PROPERTIES : NON_REPLICATED_SUBSCRIPTION_CURSOR_PROPERTIES;
    }

    static Optional<Boolean> getReplicatedSubscriptionConfiguration(ManagedCursor cursor) {
        Long v = (Long)cursor.getProperties().get(REPLICATED_SUBSCRIPTION_PROPERTY);
        if (v == null || v < 0L || v > 1L) {
            return Optional.empty();
        }
        return Optional.of(v == 1L);
    }

    public PersistentSubscription(PersistentTopic topic, String subscriptionName, ManagedCursor cursor, Boolean replicated) {
        this(topic, subscriptionName, cursor, replicated, Collections.emptyMap());
    }

    public PersistentSubscription(PersistentTopic topic, String subscriptionName, ManagedCursor cursor, Boolean replicated, Map<String, String> subscriptionProperties) {
        this.topic = topic;
        this.config = topic.getBrokerService().getPulsar().getConfig();
        this.cursor = cursor;
        this.topicName = topic.getName();
        this.subName = subscriptionName;
        this.fullName = MoreObjects.toStringHelper((Object)this).add("topic", (Object)this.topicName).add("name", (Object)this.subName).toString();
        this.expiryMonitor = new PersistentMessageExpiryMonitor(topic, subscriptionName, cursor, this);
        if (replicated != null) {
            this.setReplicated(replicated);
        }
        this.subscriptionProperties = MapUtils.isEmpty(subscriptionProperties) ? Collections.emptyMap() : Collections.unmodifiableMap(subscriptionProperties);
        this.pendingAckHandle = this.config.isTransactionCoordinatorEnabled() && !SystemTopicNames.isEventSystemTopic((TopicName)TopicName.get((String)this.topicName)) && !ExtensibleLoadManagerImpl.isInternalTopic(this.topicName) ? new PendingAckHandleImpl(this) : new PendingAckHandleDisabled();
        IS_FENCED_UPDATER.set(this, 0);
    }

    public void updateLastMarkDeleteAdvancedTimestamp() {
        this.lastMarkDeleteAdvancedTimestamp = Math.max(this.lastMarkDeleteAdvancedTimestamp, System.currentTimeMillis());
    }

    @Override
    public BrokerInterceptor interceptor() {
        return this.topic.getBrokerService().getInterceptor();
    }

    @Override
    public String getName() {
        return this.subName;
    }

    @Override
    public Topic getTopic() {
        return this.topic;
    }

    @Override
    public boolean isReplicated() {
        return this.replicatedSubscriptionSnapshotCache != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setReplicated(boolean replicated) {
        this.replicatedControlled = replicated;
        if (!replicated || !this.config.isEnableReplicatedSubscriptions()) {
            this.replicatedSubscriptionSnapshotCache = null;
        } else if (this.replicatedSubscriptionSnapshotCache == null) {
            this.replicatedSubscriptionSnapshotCache = new ReplicatedSubscriptionSnapshotCache(this.subName, this.config.getReplicatedSubscriptionsSnapshotMaxCachedPerSubscription(), arg_0 -> ((ManagedLedger)this.getCursor().getManagedLedger()).getNumberOfEntries(arg_0));
        }
        if (this.cursor == null) return false;
        if (!replicated) return this.cursor.removeProperty(REPLICATED_SUBSCRIPTION_PROPERTY);
        if (this.config.isEnableReplicatedSubscriptions()) return this.cursor.putProperty(REPLICATED_SUBSCRIPTION_PROPERTY, Long.valueOf(1L));
        log.warn("[{}][{}] Failed set replicated subscription status to {}, please enable the configuration enableReplicatedSubscriptions", new Object[]{this.topicName, this.subName, replicated});
        return false;
    }

    @Override
    public CompletableFuture<Void> addConsumer(Consumer consumer) {
        CompletableFuture<Void> inProgressResetCursorFuture = this.inProgressResetCursorFuture;
        if (inProgressResetCursorFuture != null) {
            return ((CompletableFuture)inProgressResetCursorFuture.handle((ignore, ignoreEx) -> null)).thenCompose(ignore -> this.addConsumerInternal(consumer));
        }
        return this.addConsumerInternal(consumer);
    }

    private CompletableFuture<Void> addConsumerInternal(Consumer consumer) {
        return this.pendingAckHandle.pendingAckHandleFuture().thenCompose(future -> {
            PersistentSubscription persistentSubscription = this;
            synchronized (persistentSubscription) {
                this.cursor.updateLastActive();
                if (!this.cursor.isActive() && (this.topic.getManagedLedger().getConfig().isCacheEvictionByExpectedReadCount() || this.topic.getBackloggedCursorThresholdEntries() < 0L || this.cursor.getNumberOfEntries() <= this.topic.getBackloggedCursorThresholdEntries())) {
                    this.cursor.setActive();
                }
                if (IS_FENCED_UPDATER.get(this) == 1) {
                    log.warn("Attempting to add consumer {} on a fenced subscription", (Object)consumer);
                    return FutureUtil.failedFuture((Throwable)new BrokerServiceException.SubscriptionFencedException("Subscription is fenced"));
                }
                if (this.dispatcher == null || !this.dispatcher.isConsumerConnected()) {
                    if (consumer.subType() == null) {
                        return FutureUtil.failedFuture((Throwable)new BrokerServiceException.ServerMetadataException("Unsupported subscription type"));
                    }
                    this.dispatcher = this.reuseOrCreateDispatcher(this.dispatcher, consumer);
                } else {
                    Optional<CompletableFuture<Void>> compatibilityError = this.checkForConsumerCompatibilityErrorWithDispatcher(this.dispatcher, consumer);
                    if (compatibilityError.isPresent()) {
                        return compatibilityError.get();
                    }
                }
                return this.dispatcher.addConsumer(consumer);
            }
        });
    }

    protected Dispatcher reuseOrCreateDispatcher(Dispatcher dispatcher, Consumer consumer) {
        Dispatcher previousDispatcher = null;
        switch (consumer.subType()) {
            case Exclusive: {
                if (dispatcher != null && dispatcher.getType() == CommandSubscribe.SubType.Exclusive) break;
                previousDispatcher = dispatcher;
                dispatcher = new PersistentDispatcherSingleActiveConsumer(this.cursor, CommandSubscribe.SubType.Exclusive, 0, this.topic, this);
                break;
            }
            case Shared: {
                if (dispatcher != null && dispatcher.getType() == CommandSubscribe.SubType.Shared) break;
                previousDispatcher = dispatcher;
                if (this.config.isSubscriptionSharedUseClassicPersistentImplementation()) {
                    dispatcher = new PersistentDispatcherMultipleConsumersClassic(this.topic, this.cursor, this);
                    break;
                }
                dispatcher = new PersistentDispatcherMultipleConsumers(this.topic, this.cursor, this);
                break;
            }
            case Failover: {
                int partitionIndex = TopicName.getPartitionIndex((String)this.topicName);
                if (partitionIndex < 0) {
                    partitionIndex = -1;
                }
                if (dispatcher != null && dispatcher.getType() == CommandSubscribe.SubType.Failover) break;
                previousDispatcher = dispatcher;
                dispatcher = new PersistentDispatcherSingleActiveConsumer(this.cursor, CommandSubscribe.SubType.Failover, partitionIndex, this.topic, this);
                break;
            }
            case Key_Shared: {
                KeySharedMeta ksm = consumer.getKeySharedMeta();
                if (dispatcher != null && dispatcher.getType() == CommandSubscribe.SubType.Key_Shared && ((StickyKeyDispatcher)dispatcher).hasSameKeySharedPolicy(ksm)) break;
                previousDispatcher = dispatcher;
                dispatcher = this.config.isSubscriptionKeySharedUseClassicPersistentImplementation() ? new PersistentStickyKeyDispatcherMultipleConsumersClassic(this.topic, this.cursor, this, this.config, ksm) : new PersistentStickyKeyDispatcherMultipleConsumers(this.topic, this.cursor, this, this.config, ksm);
            }
        }
        if (previousDispatcher != null) {
            ((CompletableFuture)previousDispatcher.close().thenRun(() -> log.info("[{}][{}] Successfully closed previous dispatcher", (Object)this.topicName, (Object)this.subName))).exceptionally(ex -> {
                log.error("[{}][{}] Failed to close previous dispatcher", new Object[]{this.topicName, this.subName, ex});
                return null;
            });
        }
        return dispatcher;
    }

    @Override
    public synchronized void removeConsumer(Consumer consumer, boolean isResetCursor) throws BrokerServiceException {
        this.cursor.updateLastActive();
        if (this.dispatcher != null) {
            this.dispatcher.removeConsumer(consumer);
        }
        ConsumerStatsImpl stats = consumer.getStats();
        this.bytesOutFromRemovedConsumers.add(stats.bytesOutCounter);
        this.msgOutFromRemovedConsumer.add(stats.msgOutCounter);
        if (this.dispatcher != null && this.dispatcher.getConsumers().isEmpty()) {
            this.deactivateCursor();
            this.topic.getManagedLedger().removeWaitingCursor(this.cursor);
            if (!this.cursor.isDurable()) {
                ((CompletableFuture)this.closeCursor(false).thenRun(() -> {
                    PersistentSubscription persistentSubscription = this;
                    synchronized (persistentSubscription) {
                        if (this.dispatcher != null) {
                            ((CompletableFuture)this.dispatcher.close().thenRun(() -> log.info("[{}][{}] Successfully closed dispatcher for reader", (Object)this.topicName, (Object)this.subName))).exceptionally(ex -> {
                                log.error("[{}][{}] Failed to close dispatcher for reader", new Object[]{this.topicName, this.subName, ex});
                                return null;
                            });
                        }
                    }
                })).exceptionally(exception -> {
                    log.error("[{}][{}] Failed to close subscription for reader", new Object[]{this.topicName, this.subName, exception});
                    return null;
                });
                this.topic.getBrokerService().pulsar().getExecutor().execute(() -> this.topic.removeSubscription(this.subName).thenRunAsync(() -> {
                    if (!isResetCursor) {
                        try {
                            this.topic.getManagedLedger().deleteCursor(this.cursor.getName());
                        }
                        catch (InterruptedException | ManagedLedgerException e) {
                            log.warn("[{}] [{}] Failed to remove non durable cursor", new Object[]{this.topic.getName(), this.subName, e});
                        }
                    }
                }, this.topic.getBrokerService().pulsar().getExecutor()));
            }
        }
        this.topic.decrementUsageCount();
        if (log.isDebugEnabled()) {
            log.debug("[{}] [{}] [{}] Removed consumer -- count: {}", new Object[]{this.topic.getName(), this.subName, consumer.consumerName(), this.topic.currentUsageCount()});
        }
    }

    public void deactivateCursor() {
        this.cursor.setInactive();
    }

    @Override
    public void consumerFlow(Consumer consumer, int additionalNumberOfMessages) {
        this.lastConsumedFlowTimestamp = System.currentTimeMillis();
        this.dispatcher.consumerFlow(consumer, additionalNumberOfMessages);
    }

    @Override
    public void acknowledgeMessage(List<Position> positions, CommandAck.AckType ackType, Map<String, Long> properties) {
        this.cursor.updateLastActive();
        Position previousMarkDeletePosition = this.cursor.getMarkDeletedPosition();
        if (ackType == CommandAck.AckType.Cumulative) {
            if (positions.size() != 1) {
                log.warn("[{}][{}] Invalid cumulative ack received with multiple message ids.", (Object)this.topicName, (Object)this.subName);
                return;
            }
            Position position2 = positions.get(0);
            if (log.isDebugEnabled()) {
                log.debug("[{}][{}] Cumulative ack on {}", new Object[]{this.topicName, this.subName, position2});
            }
            this.cursor.asyncMarkDelete(position2, this.mergeCursorProperties(properties), this.markDeleteCallback, (Object)previousMarkDeletePosition);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("[{}][{}] Individual acks on {}", new Object[]{this.topicName, this.subName, positions});
            }
            this.cursor.asyncDelete(positions, this.deleteCallback, (Object)previousMarkDeletePosition);
            if (this.config.isTransactionCoordinatorEnabled()) {
                positions.forEach(position -> {
                    if (this.cursor.isMessageDeleted(position)) {
                        this.pendingAckHandle.clearIndividualPosition((Position)position);
                    }
                });
            }
            if (this.dispatcher != null) {
                this.dispatcher.getRedeliveryTracker().removeBatch(positions);
            }
        }
        if (this.topic.getManagedLedger().isTerminated() && this.cursor.getNumberOfEntriesInBacklog(false) == 0L && this.dispatcher != null) {
            AbstractBaseDispatcher.checkAndApplyReachedEndOfTopicOrTopicMigration(this.topic, this.dispatcher.getConsumers());
        }
    }

    public CompletableFuture<Void> transactionIndividualAcknowledge(TxnID txnId, List<MutablePair<Position, Integer>> positions) {
        return this.pendingAckHandle.individualAcknowledgeMessage(txnId, positions);
    }

    public CompletableFuture<Void> transactionCumulativeAcknowledge(TxnID txnId, List<Position> positions) {
        return this.pendingAckHandle.cumulativeAcknowledgeMessage(txnId, positions);
    }

    private void notifyTheMarkDeletePositionChanged(Position oldPosition) {
        Position newMD = this.cursor.getMarkDeletedPosition();
        if (newMD.compareTo(oldPosition) != 0) {
            this.updateLastMarkDeleteAdvancedTimestamp();
            this.handleReplicatedSubscriptionsUpdate(newMD);
            if (this.dispatcher != null) {
                this.dispatcher.markDeletePositionMoveForward();
            }
        }
    }

    private void handleReplicatedSubscriptionsUpdate(Position markDeletePosition) {
        ReplicatedSubscriptionSnapshotCache.SnapshotResult snapshot;
        ReplicatedSubscriptionSnapshotCache snapshotCache = this.replicatedSubscriptionSnapshotCache;
        if (snapshotCache != null && (snapshot = snapshotCache.advancedMarkDeletePosition(markDeletePosition)) != null) {
            this.topic.getReplicatedSubscriptionController().ifPresent(c -> c.localSubscriptionUpdated(this.subName, snapshot));
        }
    }

    public String toString() {
        return this.fullName;
    }

    @Override
    public String getTopicName() {
        return this.topicName;
    }

    @Override
    public CommandSubscribe.SubType getType() {
        return this.dispatcher != null ? this.dispatcher.getType() : null;
    }

    @Override
    public String getTypeString() {
        CommandSubscribe.SubType type = this.getType();
        if (type == null) {
            return "None";
        }
        switch (type) {
            case Exclusive: {
                return "Exclusive";
            }
            case Failover: {
                return "Failover";
            }
            case Shared: {
                return "Shared";
            }
            case Key_Shared: {
                return "Key_Shared";
            }
        }
        return "Null";
    }

    @Override
    public CompletableFuture<AnalyzeBacklogResult> analyzeBacklog(Optional<Position> position) {
        ManagedCursor newNonDurableCursor;
        ManagedLedger managedLedger = this.topic.getManagedLedger();
        String newNonDurableCursorName = "analyze-backlog-" + String.valueOf(UUID.randomUUID());
        try {
            newNonDurableCursor = this.cursor.duplicateNonDurableCursor(newNonDurableCursorName);
        }
        catch (ManagedLedgerException e) {
            return CompletableFuture.failedFuture(e);
        }
        long start = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("[{}][{}] Starting to analyze backlog", (Object)this.topicName, (Object)this.subName);
        }
        AtomicLong entries = new AtomicLong();
        AtomicLong accepted = new AtomicLong();
        AtomicLong rejected = new AtomicLong();
        AtomicLong rescheduled = new AtomicLong();
        AtomicLong messages = new AtomicLong();
        AtomicLong markerMessages = new AtomicLong();
        AtomicLong acceptedMessages = new AtomicLong();
        AtomicLong rejectedMessages = new AtomicLong();
        AtomicLong rescheduledMessages = new AtomicLong();
        Position currentPosition = newNonDurableCursor.getMarkDeletedPosition();
        if (log.isDebugEnabled()) {
            log.debug("[{}][{}] currentPosition {}", new Object[]{this.topicName, this.subName, currentPosition});
        }
        EntryFilterSupport entryFilterSupport = this.dispatcher != null ? (EntryFilterSupport)((Object)this.dispatcher) : new EntryFilterSupport(this);
        long maxEntries = this.config.getSubscriptionBacklogScanMaxEntries();
        long timeOutMs = this.config.getSubscriptionBacklogScanMaxTimeMs();
        int batchSize = this.config.getDispatcherMaxReadBatchSize();
        AtomicReference firstPosition = new AtomicReference();
        AtomicReference lastPosition = new AtomicReference();
        Predicate<Entry> condition = entry -> {
            EntryFilter.FilterResult filterResult;
            if (log.isDebugEnabled()) {
                log.debug("found {}", entry);
            }
            Position entryPosition = entry.getPosition();
            firstPosition.compareAndSet(null, entryPosition);
            lastPosition.set(entryPosition);
            ByteBuf metadataAndPayload = entry.getDataBuffer();
            MessageMetadata messageMetadata = entry.getMessageMetadata() != null ? entry.getMessageMetadata() : Commands.peekMessageMetadata((ByteBuf)metadataAndPayload, (String)"", (long)-1L);
            if (messageMetadata.hasMarkerType()) {
                markerMessages.incrementAndGet();
                return true;
            }
            int numMessages = 1;
            if (messageMetadata.hasNumMessagesInBatch()) {
                numMessages = messageMetadata.getNumMessagesInBatch();
            }
            if ((filterResult = entryFilterSupport.runFiltersForEntry((Entry)entry, messageMetadata, null)) == null) {
                filterResult = EntryFilter.FilterResult.ACCEPT;
            }
            switch (filterResult) {
                case REJECT: {
                    rejected.incrementAndGet();
                    rejectedMessages.addAndGet(numMessages);
                    break;
                }
                case RESCHEDULE: {
                    rescheduled.incrementAndGet();
                    rescheduledMessages.addAndGet(numMessages);
                    break;
                }
                default: {
                    accepted.incrementAndGet();
                    acceptedMessages.addAndGet(numMessages);
                }
            }
            long num = entries.incrementAndGet();
            messages.addAndGet(numMessages);
            if (num % 1000L == 0L) {
                long end = System.currentTimeMillis();
                log.info("[{}][{}] scan running since {} ms - scanned {} entries", new Object[]{this.topicName, this.subName, end - start, num});
            }
            return true;
        };
        CompletionStage res = newNonDurableCursor.scan(position, condition, batchSize, maxEntries, timeOutMs).thenApply(outcome -> {
            long end = System.currentTimeMillis();
            AnalyzeBacklogResult result = new AnalyzeBacklogResult();
            result.setFirstPosition((Position)firstPosition.get());
            result.setLastPosition((Position)lastPosition.get());
            result.setEntries(entries.get());
            result.setMessages(messages.get());
            result.setMarkerMessages(markerMessages.get());
            result.setFilterAcceptedEntries(accepted.get());
            result.setFilterAcceptedMessages(acceptedMessages.get());
            result.setFilterRejectedEntries(rejected.get());
            result.setFilterRejectedMessages(rejectedMessages.get());
            result.setFilterRescheduledEntries(rescheduled.get());
            result.setFilterRescheduledMessages(rescheduledMessages.get());
            result.setScanOutcome((ScanOutcome)outcome);
            log.info("[{}][{}] scan took {} ms - {}", new Object[]{this.topicName, this.subName, end - start, result});
            return result;
        });
        ((CompletableFuture)res).whenComplete((__, ex) -> managedLedger.asyncDeleteCursor(newNonDurableCursorName, new AsyncCallbacks.DeleteCursorCallback(){

            public void deleteCursorComplete(Object ctx) {
            }

            public void deleteCursorFailed(ManagedLedgerException exception, Object ctx) {
                log.warn("[{}][{}] Delete non-durable cursor[{}] failed when analyze backlog.", new Object[]{PersistentSubscription.this.topicName, PersistentSubscription.this.subName, newNonDurableCursor.getName()});
            }
        }, null));
        return res;
    }

    @Override
    public CompletableFuture<Void> clearBacklog() {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (log.isDebugEnabled()) {
            log.debug("[{}][{}] Backlog size before clearing: {}", new Object[]{this.topicName, this.subName, this.cursor.getNumberOfEntriesInBacklog(false)});
        }
        this.cursor.asyncClearBacklog(new AsyncCallbacks.ClearBacklogCallback(){

            public void clearBacklogComplete(Object ctx) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}][{}] Backlog size after clearing: {}", new Object[]{PersistentSubscription.this.topicName, PersistentSubscription.this.subName, PersistentSubscription.this.cursor.getNumberOfEntriesInBacklog(false)});
                }
                if (PersistentSubscription.this.dispatcher != null) {
                    PersistentSubscription.this.dispatcher.clearDelayedMessages().whenComplete((__, ex) -> {
                        if (ex != null) {
                            future.completeExceptionally((Throwable)ex);
                        } else {
                            future.complete(null);
                        }
                    });
                    PersistentSubscription.this.dispatcher.afterAckMessages(null, ctx);
                } else {
                    future.complete(null);
                }
            }

            public void clearBacklogFailed(ManagedLedgerException exception, Object ctx) {
                log.error("[{}][{}] Failed to clear backlog", new Object[]{PersistentSubscription.this.topicName, PersistentSubscription.this.subName, exception});
                future.completeExceptionally(exception);
                if (PersistentSubscription.this.dispatcher != null) {
                    PersistentSubscription.this.dispatcher.afterAckMessages(exception, ctx);
                }
            }
        }, null);
        return future;
    }

    @Override
    public CompletableFuture<Void> skipMessages(final int numMessagesToSkip) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (log.isDebugEnabled()) {
            log.debug("[{}][{}] Skipping {} messages, current backlog {}", new Object[]{this.topicName, this.subName, numMessagesToSkip, this.cursor.getNumberOfEntriesInBacklog(false)});
        }
        this.cursor.asyncSkipEntries(numMessagesToSkip, ManagedCursor.IndividualDeletedEntries.Exclude, new AsyncCallbacks.SkipEntriesCallback(){

            public void skipEntriesComplete(Object ctx) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}][{}] Skipped {} messages, new backlog {}", new Object[]{PersistentSubscription.this.topicName, PersistentSubscription.this.subName, numMessagesToSkip, PersistentSubscription.this.cursor.getNumberOfEntriesInBacklog(false)});
                }
                future.complete(null);
                if (PersistentSubscription.this.dispatcher != null) {
                    PersistentSubscription.this.dispatcher.afterAckMessages(null, ctx);
                }
            }

            public void skipEntriesFailed(ManagedLedgerException exception, Object ctx) {
                log.error("[{}][{}] Failed to skip {} messages", new Object[]{PersistentSubscription.this.topicName, PersistentSubscription.this.subName, numMessagesToSkip, exception});
                future.completeExceptionally(exception);
                if (PersistentSubscription.this.dispatcher != null) {
                    PersistentSubscription.this.dispatcher.afterAckMessages(exception, ctx);
                }
            }
        }, null);
        return future;
    }

    @Override
    public CompletableFuture<Void> resetCursor(final long timestamp) {
        if (!IS_FENCED_UPDATER.compareAndSet(this, 0, 1)) {
            return CompletableFuture.failedFuture(new BrokerServiceException.SubscriptionBusyException("Failed to fence subscription"));
        }
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.inProgressResetCursorFuture = future;
        PersistentMessageFinder persistentMessageFinder = new PersistentMessageFinder(this.topicName, this.cursor, this.config.getManagedLedgerCursorResetLedgerCloseTimestampMaxClockSkewMillis());
        if (log.isDebugEnabled()) {
            log.debug("[{}][{}] Resetting subscription to timestamp {}", new Object[]{this.topicName, this.subName, timestamp});
        }
        persistentMessageFinder.findMessages(timestamp, new AsyncCallbacks.FindEntryCallback(){

            public void findEntryComplete(Position position, Object ctx) {
                Position finalPosition;
                if (position == null) {
                    finalPosition = PersistentSubscription.this.cursor.getFirstPosition();
                    if (finalPosition == null) {
                        log.warn("[{}][{}] Unable to find position for timestamp {}. Unable to reset cursor to first position", new Object[]{PersistentSubscription.this.topicName, PersistentSubscription.this.subName, timestamp});
                        IS_FENCED_UPDATER.set(PersistentSubscription.this, 0);
                        PersistentSubscription.this.inProgressResetCursorFuture = null;
                        future.completeExceptionally(new BrokerServiceException.SubscriptionInvalidCursorPosition("Unable to find position for specified timestamp"));
                        return;
                    }
                    log.info("[{}][{}] Unable to find position for timestamp {}. Resetting cursor to first position {} in ledger", new Object[]{PersistentSubscription.this.topicName, PersistentSubscription.this.subName, timestamp, finalPosition});
                } else {
                    finalPosition = position.getNext();
                }
                CompletableFuture<Void> resetCursorFuture = PersistentSubscription.this.resetCursorInternal(finalPosition, future, true);
                FutureUtil.completeAfter((CompletableFuture)future, resetCursorFuture);
            }

            public void findEntryFailed(ManagedLedgerException exception, Optional<Position> failedReadPosition, Object ctx) {
                IS_FENCED_UPDATER.set(PersistentSubscription.this, 0);
                PersistentSubscription.this.inProgressResetCursorFuture = null;
                if (exception instanceof ManagedLedgerException.ConcurrentFindCursorPositionException) {
                    future.completeExceptionally(new BrokerServiceException.SubscriptionBusyException(exception.getMessage()));
                } else {
                    future.completeExceptionally(new BrokerServiceException(exception));
                }
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> resetCursor(Position finalPosition) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        return this.resetCursorInternal(finalPosition, future, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> resetCursorInternal(final Position finalPosition, final CompletableFuture<Void> future, boolean alreadyFenced) {
        CompletableFuture<Object> disconnectFuture;
        if (!alreadyFenced && !IS_FENCED_UPDATER.compareAndSet(this, 0, 1)) {
            return CompletableFuture.failedFuture(new BrokerServiceException.SubscriptionBusyException("Failed to fence subscription"));
        }
        this.inProgressResetCursorFuture = future;
        PersistentSubscription persistentSubscription = this;
        synchronized (persistentSubscription) {
            disconnectFuture = this.dispatcher != null && this.dispatcher.isConsumerConnected() ? this.dispatcher.disconnectActiveConsumers(true) : CompletableFuture.completedFuture(null);
        }
        disconnectFuture.whenComplete((aVoid, throwable) -> {
            if (this.dispatcher != null) {
                this.dispatcher.resetCloseFuture();
            }
            if (throwable != null) {
                log.error("[{}][{}] Failed to disconnect consumer from subscription", new Object[]{this.topicName, this.subName, throwable});
                IS_FENCED_UPDATER.set(this, 0);
                this.inProgressResetCursorFuture = null;
                future.completeExceptionally(new BrokerServiceException.SubscriptionBusyException("Failed to disconnect consumers from subscription"));
                return;
            }
            log.info("[{}][{}] Successfully disconnected consumers from subscription, proceeding with cursor reset", (Object)this.topicName, (Object)this.subName);
            CompletableFuture<Boolean> forceReset = new CompletableFuture<Boolean>();
            if (this.topic.getTopicCompactionService() == null) {
                forceReset.complete(false);
            } else {
                ((CompletableFuture)this.topic.getTopicCompactionService().getLastCompactedPosition().thenAccept(lastCompactedPosition -> {
                    Position resetTo = finalPosition;
                    if (lastCompactedPosition != null && resetTo.compareTo(lastCompactedPosition.getLedgerId(), lastCompactedPosition.getEntryId()) <= 0) {
                        forceReset.complete(true);
                    } else {
                        forceReset.complete(false);
                    }
                })).exceptionally(ex -> {
                    forceReset.completeExceptionally((Throwable)ex);
                    return null;
                });
            }
            ((CompletableFuture)forceReset.thenAccept(forceResetValue -> this.cursor.asyncResetCursor(finalPosition, forceResetValue.booleanValue(), new AsyncCallbacks.ResetCursorCallback(){

                public void resetComplete(Object ctx) {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}][{}] Successfully reset subscription to position {}", new Object[]{PersistentSubscription.this.topicName, PersistentSubscription.this.subName, finalPosition});
                    }
                    if (PersistentSubscription.this.dispatcher != null) {
                        PersistentSubscription.this.dispatcher.cursorIsReset();
                        PersistentSubscription.this.dispatcher.afterAckMessages(null, finalPosition);
                    }
                    IS_FENCED_UPDATER.set(PersistentSubscription.this, 0);
                    PersistentSubscription.this.inProgressResetCursorFuture = null;
                    future.complete(null);
                }

                public void resetFailed(ManagedLedgerException exception, Object ctx) {
                    log.error("[{}][{}] Failed to reset subscription to position {}", new Object[]{PersistentSubscription.this.topicName, PersistentSubscription.this.subName, finalPosition, exception});
                    IS_FENCED_UPDATER.set(PersistentSubscription.this, 0);
                    PersistentSubscription.this.inProgressResetCursorFuture = null;
                    if (exception instanceof ManagedLedgerException.InvalidCursorPositionException) {
                        future.completeExceptionally(new BrokerServiceException.SubscriptionInvalidCursorPosition(exception.getMessage()));
                    } else if (exception instanceof ManagedLedgerException.ConcurrentFindCursorPositionException) {
                        future.completeExceptionally(new BrokerServiceException.SubscriptionBusyException(exception.getMessage()));
                    } else {
                        future.completeExceptionally(new BrokerServiceException(exception));
                    }
                }
            }))).exceptionally(e -> {
                log.error("[{}][{}] Error while resetting cursor", new Object[]{this.topicName, this.subName, e});
                IS_FENCED_UPDATER.set(this, 0);
                this.inProgressResetCursorFuture = null;
                future.completeExceptionally(new BrokerServiceException((Throwable)e));
                return null;
            });
        });
        return future;
    }

    @Override
    public CompletableFuture<Entry> peekNthMessage(int messagePosition) {
        final CompletableFuture<Entry> future = new CompletableFuture<Entry>();
        if (log.isDebugEnabled()) {
            log.debug("[{}][{}] Getting message at position {}", new Object[]{this.topicName, this.subName, messagePosition});
        }
        this.cursor.asyncGetNthEntry(messagePosition, ManagedCursor.IndividualDeletedEntries.Exclude, new AsyncCallbacks.ReadEntryCallback(){

            public void readEntryFailed(ManagedLedgerException exception, Object ctx) {
                future.completeExceptionally(exception);
            }

            public void readEntryComplete(Entry entry, Object ctx) {
                future.complete(entry);
            }

            public String toString() {
                return String.format("Subscription [%s-%s] async replay entries", PersistentSubscription.this.topicName, PersistentSubscription.this.subName);
            }
        }, null);
        return future;
    }

    @Override
    public long getNumberOfEntriesInBacklog(boolean getPreciseBacklog) {
        return this.cursor.getNumberOfEntriesInBacklog(getPreciseBacklog);
    }

    @Override
    public synchronized Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public long getNumberOfEntriesSinceFirstNotAckedMessage() {
        return this.cursor.getNumberOfEntriesSinceFirstNotAckedMessage();
    }

    public int getTotalNonContiguousDeletedMessagesRange() {
        return this.cursor.getTotalNonContiguousDeletedMessagesRange();
    }

    private synchronized CompletableFuture<Void> closeCursor(boolean checkActiveConsumers) {
        if (checkActiveConsumers && this.dispatcher != null && this.dispatcher.isConsumerConnected()) {
            return FutureUtil.failedFuture((Throwable)new BrokerServiceException.SubscriptionBusyException("Subscription has active consumers"));
        }
        return this.pendingAckHandle.closeAsync().thenAccept(v -> {
            IS_FENCED_UPDATER.set(this, 1);
            log.info("[{}][{}] Successfully closed subscription [{}]", new Object[]{this.topicName, this.subName, this.cursor});
        });
    }

    @Override
    public synchronized CompletableFuture<Void> disconnect(Optional<BrokerLookupData> assignedBrokerLookupData) {
        CompletableFuture<Void> disconnectFuture = new CompletableFuture<Void>();
        ((CompletableFuture)(this.dispatcher != null ? this.dispatcher.disconnectAllConsumers(false, assignedBrokerLookupData) : CompletableFuture.completedFuture(null)).thenRun(() -> {
            log.info("[{}][{}] Successfully disconnected subscription consumers", (Object)this.topicName, (Object)this.subName);
            disconnectFuture.complete(null);
        })).exceptionally(exception -> {
            log.error("[{}][{}] Error disconnecting subscription consumers", new Object[]{this.topicName, this.subName, exception});
            disconnectFuture.completeExceptionally((Throwable)exception);
            return null;
        });
        return disconnectFuture;
    }

    @Override
    public synchronized CompletableFuture<Void> close(boolean disconnectConsumers, Optional<BrokerLookupData> assignedBrokerLookupData) {
        if (this.fenceFuture != null) {
            return this.fenceFuture;
        }
        this.fenceFuture = new CompletableFuture();
        IS_FENCED_UPDATER.set(this, 1);
        ((CompletableFuture)((CompletableFuture)(this.dispatcher != null ? this.dispatcher.close(disconnectConsumers, assignedBrokerLookupData) : CompletableFuture.completedFuture(null)).thenCompose(__ -> this.closeCursor(false))).thenRun(() -> {
            log.info("[{}][{}] Successfully closed the subscription", (Object)this.topicName, (Object)this.subName);
            this.fenceFuture.complete(null);
        })).exceptionally(exception -> {
            log.error("[{}][{}] Error closing the subscription", new Object[]{this.topicName, this.subName, exception});
            this.fenceFuture.completeExceptionally((Throwable)exception);
            this.resumeAfterFence();
            return null;
        });
        return this.fenceFuture;
    }

    public synchronized void resumeAfterFence() {
        if (this.fenceFuture != null) {
            this.fenceFuture.whenComplete((ignore, ignoreEx) -> {
                PersistentSubscription persistentSubscription = this;
                synchronized (persistentSubscription) {
                    try {
                        if (IS_FENCED_UPDATER.compareAndSet(this, 1, 0) && this.dispatcher != null) {
                            this.dispatcher.reset();
                        }
                        this.fenceFuture = null;
                    }
                    catch (Exception ex) {
                        log.error("[{}] Resume subscription [{}] failure", new Object[]{this.topicName, this.subName, ex});
                    }
                }
            });
        }
    }

    @Override
    public CompletableFuture<Void> delete() {
        return this.delete(false);
    }

    @Override
    public CompletableFuture<Void> deleteForcefully() {
        return this.delete(true);
    }

    private CompletableFuture<Void> delete(boolean closeIfConsumersConnected) {
        CompletableFuture<Void> deleteFuture = new CompletableFuture<Void>();
        log.info("[{}][{}] Unsubscribing", (Object)this.topicName, (Object)this.subName);
        CompletableFuture closeSubscriptionFuture = new CompletableFuture();
        if (closeIfConsumersConnected) {
            ((CompletableFuture)this.close(true, Optional.empty()).thenRun(() -> closeSubscriptionFuture.complete(null))).exceptionally(ex -> {
                log.error("[{}][{}] Error disconnecting and closing subscription", new Object[]{this.topicName, this.subName, ex});
                closeSubscriptionFuture.completeExceptionally((Throwable)ex);
                return null;
            });
        } else {
            ((CompletableFuture)this.closeCursor(true).thenRun(() -> closeSubscriptionFuture.complete(null))).exceptionally(exception -> {
                log.error("[{}][{}] Error closing subscription", new Object[]{this.topicName, this.subName, exception});
                closeSubscriptionFuture.completeExceptionally((Throwable)exception);
                return null;
            });
        }
        ((CompletableFuture)((CompletableFuture)closeSubscriptionFuture.thenCompose(v -> this.topic.unsubscribe(this.subName))).thenAccept(v -> {
            PersistentSubscription persistentSubscription = this;
            synchronized (persistentSubscription) {
                ((CompletableFuture)(this.dispatcher != null ? this.dispatcher.close() : CompletableFuture.completedFuture(null)).thenRun(() -> {
                    log.info("[{}][{}] Successfully deleted subscription", (Object)this.topicName, (Object)this.subName);
                    deleteFuture.complete(null);
                })).exceptionally(ex -> {
                    IS_FENCED_UPDATER.set(this, 0);
                    if (this.dispatcher != null) {
                        this.dispatcher.reset();
                    }
                    log.error("[{}][{}] Error deleting subscription", new Object[]{this.topicName, this.subName, ex});
                    deleteFuture.completeExceptionally((Throwable)ex);
                    return null;
                });
            }
        })).exceptionally(exception -> {
            IS_FENCED_UPDATER.set(this, 0);
            log.error("[{}][{}] Error deleting subscription", new Object[]{this.topicName, this.subName, exception});
            deleteFuture.completeExceptionally((Throwable)exception);
            return null;
        });
        return deleteFuture;
    }

    @Override
    public CompletableFuture<Void> doUnsubscribe(Consumer consumer) {
        return this.doUnsubscribe(consumer, false);
    }

    @Override
    public CompletableFuture<Void> doUnsubscribe(Consumer consumer, boolean force) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            if (force || this.dispatcher.canUnsubscribe(consumer)) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] unsubscribing forcefully {}-{}", new Object[]{this.topicName, this.subName, consumer.consumerName()});
                }
                consumer.close();
                return this.delete(force);
            }
            future.completeExceptionally(new BrokerServiceException.ServerMetadataException("Unconnected or shared consumer attempting to unsubscribe"));
        }
        catch (BrokerServiceException e) {
            log.warn("Error removing consumer {}", (Object)consumer);
            future.completeExceptionally(e);
        }
        return future;
    }

    @Override
    public List<Consumer> getConsumers() {
        Dispatcher dispatcher = this.dispatcher;
        if (dispatcher != null) {
            return dispatcher.getConsumers();
        }
        return Collections.emptyList();
    }

    @Override
    public boolean expireMessages(int messageTTLInSeconds) {
        long backlog = this.getNumberOfEntriesInBacklog(false);
        if (backlog == 0L || this.dispatcher != null && this.dispatcher.isConsumerConnected() && backlog < 1000L && !this.topic.isOldestMessageExpired(this.cursor, messageTTLInSeconds)) {
            return false;
        }
        this.lastExpireTimestamp = System.currentTimeMillis();
        return this.expiryMonitor.expireMessages(messageTTLInSeconds);
    }

    @Override
    public CompletableFuture<Boolean> expireMessagesAsync(int messageTTLInSeconds) {
        long backlog = this.getNumberOfEntriesInBacklog(false);
        if (backlog == 0L) {
            return CompletableFuture.completedFuture(false);
        }
        if (this.dispatcher != null && this.dispatcher.isConsumerConnected() && backlog < 1000L) {
            return this.topic.isOldestMessageExpiredAsync(this.cursor, messageTTLInSeconds).thenCompose(oldestMsgExpired -> {
                if (oldestMsgExpired.booleanValue()) {
                    this.lastExpireTimestamp = System.currentTimeMillis();
                    return this.expiryMonitor.expireMessagesAsync(messageTTLInSeconds);
                }
                return CompletableFuture.completedFuture(false);
            });
        }
        return this.expiryMonitor.expireMessagesAsync(messageTTLInSeconds);
    }

    @Override
    public boolean expireMessages(Position position) {
        this.lastExpireTimestamp = System.currentTimeMillis();
        return this.expiryMonitor.expireMessages(position);
    }

    @Override
    public double getExpiredMessageRate() {
        return this.expiryMonitor.getMessageExpiryRate();
    }

    public PersistentMessageExpiryMonitor getExpiryMonitor() {
        return this.expiryMonitor;
    }

    public long estimateBacklogSize() {
        return this.cursor.getEstimatedSizeSinceMarkDeletePosition();
    }

    public CompletableFuture<SubscriptionStatsImpl> getStatsAsync(GetStatsOptions getStatsOptions) {
        Consumer activeConsumer;
        SubscriptionStatsImpl subStats = new SubscriptionStatsImpl();
        subStats.lastExpireTimestamp = this.lastExpireTimestamp;
        subStats.lastConsumedFlowTimestamp = this.lastConsumedFlowTimestamp;
        subStats.lastMarkDeleteAdvancedTimestamp = this.lastMarkDeleteAdvancedTimestamp;
        subStats.bytesOutCounter = this.bytesOutFromRemovedConsumers.longValue();
        subStats.msgOutCounter = this.msgOutFromRemovedConsumer.longValue();
        Dispatcher dispatcher = this.dispatcher;
        if (dispatcher != null) {
            Map<Consumer, List<Range>> consumerKeyHashRanges = this.getType() == CommandSubscribe.SubType.Key_Shared ? ((StickyKeyDispatcher)dispatcher).getConsumerKeyHashRanges() : null;
            dispatcher.getConsumers().forEach(consumer -> {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * java.lang.UnsupportedOperationException
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            });
            subStats.filterProcessedMsgCount = dispatcher.getFilterProcessedMsgCount();
            subStats.filterAcceptedMsgCount = dispatcher.getFilterAcceptedMsgCount();
            subStats.filterRejectedMsgCount = dispatcher.getFilterRejectedMsgCount();
            subStats.filterRescheduledMsgCount = dispatcher.getFilterRescheduledMsgCount();
            subStats.dispatchThrottledMsgEventsBySubscriptionLimit = dispatcher.getDispatchThrottledMsgEventsBySubscriptionLimit();
            subStats.dispatchThrottledBytesEventsBySubscriptionLimit = dispatcher.getDispatchThrottledBytesBySubscriptionLimit();
            subStats.dispatchThrottledMsgEventsByBrokerLimit = dispatcher.getDispatchThrottledMsgEventsByBrokerLimit();
            subStats.dispatchThrottledBytesEventsByBrokerLimit = dispatcher.getDispatchThrottledBytesEventsByBrokerLimit();
            subStats.dispatchThrottledMsgEventsByTopicLimit = dispatcher.getDispatchThrottledMsgEventsByTopicLimit();
            subStats.dispatchThrottledBytesEventsByTopicLimit = dispatcher.getDispatchThrottledBytesEventsByTopicLimit();
        }
        CommandSubscribe.SubType subType = this.getType();
        subStats.type = this.getTypeString();
        if (dispatcher instanceof PersistentDispatcherSingleActiveConsumer && (activeConsumer = ((PersistentDispatcherSingleActiveConsumer)dispatcher).getActiveConsumer()) != null) {
            subStats.activeConsumerName = activeConsumer.consumerName();
        }
        if (dispatcher instanceof AbstractPersistentDispatcherMultipleConsumers) {
            subStats.delayedMessageIndexSizeInBytes = ((AbstractPersistentDispatcherMultipleConsumers)dispatcher).getDelayedTrackerMemoryUsage();
            subStats.bucketDelayedIndexStats = ((AbstractPersistentDispatcherMultipleConsumers)dispatcher).getBucketDelayedIndexStats();
        }
        if (Subscription.isIndividualAckMode(subType) && dispatcher instanceof AbstractPersistentDispatcherMultipleConsumers) {
            AbstractPersistentDispatcherMultipleConsumers d = (AbstractPersistentDispatcherMultipleConsumers)dispatcher;
            subStats.unackedMessages = d.getTotalUnackedMessages();
            subStats.blockedSubscriptionOnUnackedMsgs = d.isBlockedDispatcherOnUnackedMsgs();
            subStats.msgDelayed = d.getNumberOfDelayedMessages();
            subStats.msgInReplay = d.getNumberOfMessagesInReplay();
        }
        subStats.msgBacklog = this.getNumberOfEntriesInBacklog(getStatsOptions.isGetPreciseBacklog());
        subStats.backlogSize = getStatsOptions.isSubscriptionBacklogSize() ? this.topic.getManagedLedger().getEstimatedBacklogSize(this.cursor.getMarkDeletedPosition()) : -1L;
        subStats.msgBacklogNoDelayed = subStats.msgBacklog - subStats.msgDelayed;
        subStats.msgRateExpired = this.expiryMonitor.getMessageExpiryRate();
        subStats.msgExpired = this.expiryMonitor.getMessageExpiryCount();
        subStats.totalMsgExpired = this.expiryMonitor.getTotalMessageExpired();
        subStats.isReplicated = this.isReplicated();
        subStats.subscriptionProperties = this.subscriptionProperties;
        subStats.isDurable = this.cursor.isDurable();
        if (this.getType() == CommandSubscribe.SubType.Key_Shared && dispatcher instanceof StickyKeyDispatcher) {
            StickyKeyDispatcher keySharedDispatcher = (StickyKeyDispatcher)dispatcher;
            subStats.allowOutOfOrderDelivery = keySharedDispatcher.isAllowOutOfOrderDelivery();
            subStats.keySharedMode = keySharedDispatcher.getKeySharedMode().toString();
            LinkedHashMap<Consumer, Position> recentlyJoinedConsumers = keySharedDispatcher.getRecentlyJoinedConsumers();
            if (recentlyJoinedConsumers != null && recentlyJoinedConsumers.size() > 0) {
                recentlyJoinedConsumers.forEach((k, v) -> subStats.consumersAfterMarkDeletePosition.put(k.consumerName(), v.toString()));
            }
        }
        subStats.nonContiguousDeletedMessagesRanges = this.cursor.getTotalNonContiguousDeletedMessagesRange();
        subStats.nonContiguousDeletedMessagesRangesSerializedSize = this.cursor.getNonContiguousDeletedMessagesRangeSerializedSize();
        if (!getStatsOptions.isGetEarliestTimeInBacklog()) {
            return CompletableFuture.completedFuture(subStats);
        }
        if (subStats.msgBacklog > 0L) {
            ManagedLedger managedLedger = this.cursor.getManagedLedger();
            Position markDeletedPosition = this.cursor.getMarkDeletedPosition();
            return this.getEarliestMessagePublishTimeOfPos(managedLedger, markDeletedPosition).thenApply(v -> {
                subStats.earliestMsgPublishTimeInBacklog = v;
                return subStats;
            });
        }
        subStats.earliestMsgPublishTimeInBacklog = -1L;
        return CompletableFuture.completedFuture(subStats);
    }

    private CompletableFuture<Long> getEarliestMessagePublishTimeOfPos(final ManagedLedger ml, Position pos) {
        final CompletableFuture<Long> future = new CompletableFuture<Long>();
        if (pos == null) {
            future.complete(0L);
            return future;
        }
        final Position nextPos = ml.getNextValidPosition(pos);
        if (nextPos.compareTo(ml.getLastConfirmedEntry()) > 0) {
            return CompletableFuture.completedFuture(-1L);
        }
        ml.asyncReadEntry(nextPos, new AsyncCallbacks.ReadEntryCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void readEntryComplete(Entry entry, Object ctx) {
                try {
                    long entryTimestamp = entry.getEntryTimestamp();
                    future.complete(entryTimestamp);
                }
                catch (Exception e) {
                    log.error("Error deserializing message for message position {}", (Object)nextPos, (Object)e);
                    future.completeExceptionally(e);
                }
                finally {
                    entry.release();
                }
            }

            public void readEntryFailed(ManagedLedgerException exception, Object ctx) {
                log.error("Error read entry for position {}", (Object)nextPos, (Object)exception);
                future.completeExceptionally(exception);
            }

            public String toString() {
                return String.format("ML [%s] get earliest message publish time of pos", ml.getName());
            }
        }, null);
        return future;
    }

    @Override
    public void redeliverUnacknowledgedMessages(Consumer consumer, long consumerEpoch) {
        Dispatcher dispatcher = this.getDispatcher();
        if (dispatcher != null) {
            dispatcher.redeliverUnacknowledgedMessages(consumer, consumerEpoch);
        }
    }

    @Override
    public void redeliverUnacknowledgedMessages(Consumer consumer, List<Position> positions) {
        Dispatcher dispatcher = this.getDispatcher();
        if (dispatcher != null) {
            dispatcher.redeliverUnacknowledgedMessages(consumer, positions);
        }
    }

    private void trimByMarkDeletePosition(List<Position> positions) {
        positions.removeIf(position -> this.cursor.getMarkDeletedPosition() != null && position.compareTo(this.cursor.getMarkDeletedPosition()) <= 0);
    }

    @Override
    public void addUnAckedMessages(int unAckMessages) {
        this.dispatcher.addUnAckedMessages(unAckMessages);
    }

    @Override
    public synchronized long getNumberOfEntriesDelayed() {
        if (this.dispatcher != null) {
            return this.dispatcher.getNumberOfDelayedMessages();
        }
        return 0L;
    }

    @Override
    public void markTopicWithBatchMessagePublished() {
        this.topic.markBatchMessagePublished();
    }

    void topicTerminated() {
        if (this.cursor.getNumberOfEntriesInBacklog(false) == 0L && null != this.dispatcher) {
            AbstractBaseDispatcher.checkAndApplyReachedEndOfTopicOrTopicMigration(this.topic, this.dispatcher.getConsumers());
        }
    }

    @Override
    public boolean isSubscriptionMigrated() {
        log.info("backlog for {} - {}", (Object)this.topicName, (Object)this.cursor.getNumberOfEntriesInBacklog(true));
        return this.topic.isMigrated() && this.cursor.getNumberOfEntriesInBacklog(true) <= 0L;
    }

    @Override
    public Map<String, String> getSubscriptionProperties() {
        return this.subscriptionProperties;
    }

    public Position getPositionInPendingAck(Position position) {
        return this.pendingAckHandle.getPositionInPendingAck(position);
    }

    @Override
    public CompletableFuture<Void> updateSubscriptionProperties(Map<String, String> subscriptionProperties) {
        Map<Object, Object> newSubscriptionProperties = subscriptionProperties == null || subscriptionProperties.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(subscriptionProperties);
        return this.cursor.setCursorProperties(newSubscriptionProperties).thenRun(() -> {
            this.subscriptionProperties = newSubscriptionProperties;
        });
    }

    protected Map<String, Long> mergeCursorProperties(Map<String, Long> userProperties) {
        Map<String, Long> baseProperties = PersistentSubscription.getBaseCursorProperties(this.isReplicated());
        if (userProperties.isEmpty()) {
            return baseProperties;
        }
        TreeMap<String, Long> merged = new TreeMap<String, Long>();
        merged.putAll(userProperties);
        merged.putAll(baseProperties);
        return merged;
    }

    @Override
    public void processReplicatedSubscriptionSnapshot(ReplicatedSubscriptionsSnapshot snapshot) {
        ReplicatedSubscriptionSnapshotCache snapshotCache = this.replicatedSubscriptionSnapshotCache;
        if (snapshotCache != null) {
            snapshotCache.addNewSnapshot(new ReplicatedSubscriptionsSnapshot().copyFrom(snapshot));
            this.handleReplicatedSubscriptionsUpdate(this.cursor.getMarkDeletedPosition());
        }
    }

    @Override
    public CompletableFuture<Void> endTxn(long txnidMostBits, long txnidLeastBits, int txnAction, long lowWaterMark) {
        TxnID txnID = new TxnID(txnidMostBits, txnidLeastBits);
        if (TxnAction.COMMIT.getValue() == txnAction) {
            return this.pendingAckHandle.commitTxn(txnID, Collections.emptyMap(), lowWaterMark);
        }
        if (TxnAction.ABORT.getValue() == txnAction) {
            Consumer redeliverConsumer = null;
            if (this.getDispatcher() instanceof PersistentDispatcherSingleActiveConsumer) {
                redeliverConsumer = ((PersistentDispatcherSingleActiveConsumer)this.getDispatcher()).getActiveConsumer();
            }
            return this.pendingAckHandle.abortTxn(txnID, redeliverConsumer, lowWaterMark);
        }
        return FutureUtil.failedFuture((Throwable)new BrokerServiceException.NotAllowedException("Unsupported txnAction " + txnAction));
    }

    @VisibleForTesting
    public ManagedCursor getCursor() {
        return this.cursor;
    }

    public void syncBatchPositionBitSetForPendingAck(Position position) {
        this.pendingAckHandle.syncBatchPositionAckSetForTransaction(position);
    }

    public boolean checkIsCanDeleteConsumerPendingAck(Position position) {
        return this.pendingAckHandle.checkIsCanDeleteConsumerPendingAck(position);
    }

    public TransactionPendingAckStats getTransactionPendingAckStats(boolean lowWaterMarks) {
        return this.pendingAckHandle.getStats(lowWaterMarks);
    }

    public boolean checkAndUnblockIfStuck() {
        return this.dispatcher != null ? this.dispatcher.checkAndUnblockIfStuck() : false;
    }

    public TransactionInPendingAckStats getTransactionInPendingAckStats(TxnID txnID) {
        return this.pendingAckHandle.getTransactionInPendingAckStats(txnID);
    }

    public CompletableFuture<ManagedLedger> getPendingAckManageLedger() {
        if (this.pendingAckHandle instanceof PendingAckHandleImpl) {
            return ((PendingAckHandleImpl)this.pendingAckHandle).getStoreManageLedger();
        }
        return FutureUtil.failedFuture((Throwable)new BrokerServiceException.NotAllowedException("Pending ack handle don't use managedLedger!"));
    }

    public boolean checkIfPendingAckStoreInit() {
        return this.pendingAckHandle.checkIfPendingAckStoreInit();
    }

    public PositionInPendingAckStats checkPositionInPendingAckState(Position position, Integer batchIndex) {
        return this.pendingAckHandle.checkPositionInPendingAckState(position, batchIndex);
    }

    @VisibleForTesting
    public Boolean getReplicatedControlled() {
        return this.replicatedControlled;
    }

    @Generated
    public PendingAckHandle getPendingAckHandle() {
        return this.pendingAckHandle;
    }
}

