/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.expression.accessor;

import java.util.Map;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.query.engine.parsing.expression.AbstractExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.Expression;
import org.apache.qpid.server.query.engine.parsing.expression.accessor.ConfiguredObjectAccessorExpression;
import org.apache.qpid.server.query.engine.parsing.expression.accessor.MapObjectAccessor;
import org.apache.qpid.server.query.engine.parsing.expression.accessor.ObjectAccessorExpression;

public class DelegatingObjectAccessor<T, R>
extends AbstractExpressionNode<T, R> {
    private final String _property;

    public DelegatingObjectAccessor(String alias, String property) {
        super(alias);
        this._metadata.setAccessor(true);
        this._property = property;
    }

    @Override
    public R apply(T value) {
        if (this.ctx().containsAlias(this._property)) {
            Expression expression = this.ctx().removeAlias(this._property);
            Object result = expression.apply(value);
            this.ctx().putAlias(this._property, expression);
            return result;
        }
        if (value instanceof ConfiguredObject) {
            ConfiguredObject configuredObject = (ConfiguredObject)value;
            return new ConfiguredObjectAccessorExpression(this._property).apply(configuredObject);
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return new MapObjectAccessor(this._property).apply(map);
        }
        return new ObjectAccessorExpression(this._property).apply(value);
    }

    @Override
    public String getAlias() {
        return this._property;
    }

    @Override
    public String toString() {
        return this.getAlias();
    }
}

