/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.firewall;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.qpid.server.security.access.firewall.AbstractFirewallRuleImpl;
import org.apache.qpid.server.security.access.firewall.InetNetwork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkFirewallRule
extends AbstractFirewallRuleImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkFirewallRule.class);
    private final Set<InetNetwork> _networks = new HashSet<InetNetwork>();

    public NetworkFirewallRule(String ... networks) {
        this(Arrays.asList(networks));
    }

    public NetworkFirewallRule(Collection<String> networks) {
        for (String network : networks) {
            try {
                this._networks.add(InetNetwork.getFromString(network));
            }
            catch (UnknownHostException uhe) {
                LOGGER.error(String.format("Cannot resolve address: '%s'", network), (Throwable)uhe);
            }
        }
        LOGGER.debug("Created {}", (Object)this);
    }

    @Override
    boolean matches(InetAddress ip) {
        for (InetNetwork network : this._networks) {
            if (!network.contains(ip)) continue;
            LOGGER.debug("Client address '{}' matches configured network '{}'", (Object)ip, (Object)network);
            return true;
        }
        LOGGER.debug("Client address '{}' does not match any configured networks", (Object)ip);
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkFirewallRule that = (NetworkFirewallRule)o;
        return this._networks.equals(that._networks);
    }

    public int hashCode() {
        return this._networks.hashCode();
    }

    public String toString() {
        return "NetworkFirewallRule[networks=" + String.valueOf(this._networks) + "]";
    }
}

