/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.util;

import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.qpid.protonj2.client.impl.ClientDelivery;
import org.apache.qpid.protonj2.client.util.DeliveryQueue;

public final class FifoDeliveryQueue
implements DeliveryQueue {
    private final Deque<ClientDelivery> queue;
    private volatile boolean started;
    private int waiters = 0;

    public FifoDeliveryQueue(int queueDepth) {
        this.queue = new ArrayDeque<ClientDelivery>(Math.max(1, queueDepth));
    }

    @Override
    public synchronized void enqueue(ClientDelivery envelope) {
        this.queue.addLast(envelope);
        if (this.waiters > 0) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ClientDelivery dequeue(long timeout) throws InterruptedException {
        while (this.queue.isEmpty() && timeout != 0L && this.started) {
            if (timeout == -1L) {
                ++this.waiters;
                try {
                    this.wait();
                    continue;
                }
                finally {
                    --this.waiters;
                    continue;
                }
            }
            long start = System.currentTimeMillis();
            ++this.waiters;
            try {
                this.wait(timeout);
            }
            finally {
                --this.waiters;
            }
            timeout = Math.max(timeout + start - System.currentTimeMillis(), 0L);
        }
        if (this.started) {
            return this.queue.pollFirst();
        }
        return null;
    }

    @Override
    public synchronized ClientDelivery dequeueNoWait() {
        if (this.started) {
            return this.queue.pollFirst();
        }
        return null;
    }

    @Override
    public synchronized void start() {
        if (!this.started) {
            this.started = true;
            if (this.waiters > 0) {
                this.notifyAll();
            }
        }
    }

    @Override
    public synchronized void stop() {
        if (this.started) {
            this.started = false;
            if (this.waiters > 0) {
                this.notifyAll();
            }
        }
    }

    @Override
    public boolean isRunning() {
        return this.started;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public synchronized int size() {
        return this.queue.size();
    }

    @Override
    public synchronized void clear() {
        this.queue.clear();
    }

    public synchronized String toString() {
        return this.queue.toString();
    }
}

