/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.kylin.authorizer;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.rest.security.AclPermission;
import org.apache.kylin.rest.security.ExternalAclProvider;
import org.apache.ranger.authorization.kylin.authorizer.RangerKylinAccessRequest;
import org.apache.ranger.authorization.kylin.authorizer.RangerKylinPlugin;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.acls.model.Permission;

public class RangerKylinAuthorizer
extends ExternalAclProvider {
    private static final Logger LOG = LoggerFactory.getLogger(RangerKylinAuthorizer.class);
    private static volatile RangerKylinPlugin kylinPlugin = null;
    private static String clientIPAddress = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void init() {
        RangerKylinPlugin plugin;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerKylinAuthorizer.init()");
        }
        if ((plugin = kylinPlugin) == null) {
            Class<RangerKylinAuthorizer> clazz = RangerKylinAuthorizer.class;
            // MONITORENTER : org.apache.ranger.authorization.kylin.authorizer.RangerKylinAuthorizer.class
            plugin = kylinPlugin;
            if (plugin == null) {
                plugin = new RangerKylinPlugin();
                plugin.init();
                kylinPlugin = plugin;
                clientIPAddress = this.getClientIPAddress();
            }
            // MONITOREXIT : clazz
        }
        if (!LOG.isDebugEnabled()) return;
        LOG.debug("<== RangerKylinAuthorizer.init()");
    }

    public boolean checkPermission(String user, List<String> groups, String entityType, String entityUuid, Permission permission) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerKylinAuthorizer.checkPermission( user=" + user + ", groups=" + groups + ", entityType=" + entityType + ", entityUuid=" + entityUuid + ", permission=" + permission + ")");
        }
        boolean ret = false;
        if (kylinPlugin != null) {
            String accessType;
            RangerKylinAccessRequest request;
            RangerAccessResult result;
            String projectName = null;
            KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
            if ("ProjectInstance".equals(entityType)) {
                ProjectInstance projectInstance = ProjectManager.getInstance((KylinConfig)kylinConfig).getPrjByUuid(entityUuid);
                if (projectInstance != null) {
                    projectName = projectInstance.getName();
                } else if (LOG.isWarnEnabled()) {
                    LOG.warn("Could not find kylin project for given uuid=" + entityUuid);
                }
            }
            if ((result = kylinPlugin.isAccessAllowed((RangerAccessRequest)(request = new RangerKylinAccessRequest(projectName, user, groups, accessType = ExternalAclProvider.transformPermission((Permission)permission), clientIPAddress)))) != null && result.getIsAllowed()) {
                ret = true;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerKylinAuthorizer.checkPermission(): result=" + ret);
        }
        return ret;
    }

    private String getClientIPAddress() {
        InetAddress ip;
        block3: {
            ip = null;
            try {
                ip = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("Failed to get client IP address." + e);
            }
        }
        String ret = null;
        if (ip != null) {
            ret = ip.getHostAddress();
        }
        return ret;
    }

    public List<Pair<String, AclPermission>> getAcl(String entityType, String entityUuid) {
        return null;
    }
}

