/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.apache.rocketmq.test.sendresult;

import org.apache.rocketmq.client.producer.SendResult;

public class ResultWrapper {
    private boolean sendResult = false;
    private String msgId = null;
    private Exception sendException = null;
    private String brokerIp = null;
    private SendResult sendResultObj = null;

    public String getBrokerIp() {
        return brokerIp;
    }

    public void setBrokerIp(String brokerIp) {
        this.brokerIp = brokerIp;
    }

    public boolean isSendResult() {
        return sendResult;
    }

    public void setSendResult(boolean sendResult) {
        this.sendResult = sendResult;
    }

    public String getMsgId() {
        return msgId;
    }

    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    public Exception getSendException() {
        return sendException;
    }

    public void setSendException(Exception sendException) {
        this.sendException = sendException;
    }

    public SendResult getSendResultObj() {
        return sendResultObj;
    }
    public void setSendResultObj(SendResult sendResultObj) {
        this.sendResultObj = sendResultObj;
    }

    @Override
    public String toString() {
        return String.format("sendstatus:%s msgId:%s", sendResult, msgId);
    }
}
