/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.executor;

import com.netflix.config.DynamicPropertyFactory;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.executor.ReactiveExecutor;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.common.utils.BeanUtils;

public class ExecutorManager {
    public static final String KEY_EXECUTORS_PREFIX = "servicecomb.executors.Provider.";
    public static final String KEY_EXECUTORS_DEFAULT = "servicecomb.executors.default";
    public static final String EXECUTOR_GROUP_THREADPOOL = "servicecomb.executor.groupThreadPool";
    public static final String EXECUTOR_REACTIVE = "servicecomb.executor.reactive";
    public static final String EXECUTOR_DEFAULT = "servicecomb.executor.groupThreadPool";
    private final Map<String, Executor> executors = new ConcurrentHashMapEx();

    public ExecutorManager() {
        this.registerExecutor(EXECUTOR_REACTIVE, new ReactiveExecutor());
    }

    public void registerExecutor(String id, Executor executor) {
        Executor existing = this.executors.putIfAbsent(id, executor);
        if (existing != null) {
            throw new IllegalStateException(String.format("duplicated executor, id=%s, old executor=%s, new executor=%s", id, existing.getClass().getName(), executor.getClass().getName()));
        }
    }

    public Executor findExecutor(OperationMeta operationMeta) {
        return this.findExecutor(operationMeta, null);
    }

    public Executor findExecutor(OperationMeta operationMeta, Executor defaultOperationExecutor) {
        Executor executor = this.findByKey(KEY_EXECUTORS_PREFIX + operationMeta.getMicroserviceQualifiedName());
        if (executor != null) {
            return executor;
        }
        executor = this.findByKey(KEY_EXECUTORS_PREFIX + operationMeta.getSchemaQualifiedName());
        if (executor != null) {
            return executor;
        }
        if (defaultOperationExecutor != null) {
            return defaultOperationExecutor;
        }
        executor = this.findByKey(KEY_EXECUTORS_PREFIX + operationMeta.getMicroserviceName() + '.' + operationMeta.getSchemaId());
        if (executor != null) {
            return executor;
        }
        executor = this.findByKey(KEY_EXECUTORS_PREFIX + operationMeta.getSchemaId());
        if (executor != null) {
            return executor;
        }
        executor = this.findByKey(KEY_EXECUTORS_PREFIX + operationMeta.getMicroserviceName());
        if (executor != null) {
            return executor;
        }
        executor = this.findByKey(KEY_EXECUTORS_DEFAULT);
        if (executor != null) {
            return executor;
        }
        return this.findExecutorById("servicecomb.executor.groupThreadPool");
    }

    protected Executor findByKey(String configKey) {
        String id = DynamicPropertyFactory.getInstance().getStringProperty(configKey, null).get();
        if (id == null) {
            return null;
        }
        return this.findExecutorById(id);
    }

    public Executor findExecutorById(String id) {
        Executor executor = this.executors.get(id);
        if (executor != null) {
            return executor;
        }
        return (Executor)BeanUtils.getBean((String)id);
    }
}

