/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.filter.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.configuration.Configuration;
import org.apache.servicecomb.config.ConfigUtil;
import org.apache.servicecomb.core.filter.config.AbstractFilterChainsConfig;
import org.apache.servicecomb.core.filter.config.InvocationFilterChainsConfig;
import org.apache.servicecomb.core.filter.config.TransportChainsConfig;

public class FilterChainsConfig
extends AbstractFilterChainsConfig {
    public static final String TRANSPORT_ROOT = "servicecomb.filter-chains.transport";
    public static final String DEFINITION_ROOT = "servicecomb.filter-chains.definition";
    private final Map<String, TransportChainsConfig> transportChains = new HashMap<String, TransportChainsConfig>();
    private final Map<String, List<String>> definitions = new HashMap<String, List<String>>();
    private InvocationFilterChainsConfig consumer;
    private InvocationFilterChainsConfig producer;
    private boolean enabled;

    public void load() {
        this.enabled = this.config.getBoolean("servicecomb.filter-chains.enabled", false);
        this.loadKeys(TRANSPORT_ROOT, this::loadTransportChain);
        this.loadKeys(DEFINITION_ROOT, this::loadDefinitionChain);
        this.consumer = new InvocationFilterChainsConfig("servicecomb.filter-chains.consumer");
        this.producer = new InvocationFilterChainsConfig("servicecomb.filter-chains.producer");
    }

    private void loadTransportChain(String qualifiedKey) {
        String qualifiedName = qualifiedKey.substring(TRANSPORT_ROOT.length() + 1);
        int dotIdx = qualifiedName.indexOf(46);
        String chainName = qualifiedName.substring(0, dotIdx);
        String transport = qualifiedName.substring(dotIdx + 1);
        this.transportChains.computeIfAbsent(chainName, key -> new TransportChainsConfig()).add(transport, ConfigUtil.getStringList((Configuration)this.config, (String)qualifiedKey));
    }

    private void loadDefinitionChain(String qualifiedKey) {
        String chainName = qualifiedKey.substring(DEFINITION_ROOT.length() + 1);
        this.definitions.put(chainName, ConfigUtil.getStringList((Configuration)this.config, (String)qualifiedKey));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public InvocationFilterChainsConfig getConsumer() {
        return this.consumer;
    }

    public InvocationFilterChainsConfig getProducer() {
        return this.producer;
    }

    public Function<List<String>, List<Object>> getResolver() {
        return this::resolveChain;
    }

    private List<Object> resolveChain(List<String> chain) {
        return chain.stream().flatMap(filterOrReference -> this.resolveFilterOrReference((String)filterOrReference).stream()).collect(Collectors.toList());
    }

    private List<Object> resolveFilterOrReference(String filterOrReference) {
        TransportChainsConfig transportChain = this.transportChains.get(filterOrReference);
        if (transportChain != null) {
            return Collections.singletonList(transportChain);
        }
        List<String> chain = this.definitions.get(filterOrReference);
        if (chain == null) {
            return Collections.singletonList(filterOrReference);
        }
        return this.resolveChain(chain);
    }
}

