/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.kernel.internal.failover;

import org.apache.shardingsphere.elasticjob.kernel.internal.storage.JobNodePath;

public final class FailoverNode {
    private static final String FAILOVER = "failover";
    private static final String LEADER_ROOT = "leader/failover";
    static final String ITEMS_ROOT = "leader/failover/items";
    private static final String ITEMS = "leader/failover/items/%s";
    static final String LATCH = "leader/failover/latch";
    private static final String EXECUTION_FAILOVER = "sharding/%s/failover";
    private static final String FAILOVERING = "failovering";
    private static final String EXECUTING_FAILOVER = "sharding/%s/failovering";
    private final JobNodePath jobNodePath;

    public FailoverNode(String jobName) {
        this.jobNodePath = new JobNodePath(jobName);
    }

    static String getItemsNode(int item) {
        return String.format(ITEMS, item);
    }

    static String getExecutionFailoverNode(int item) {
        return String.format(EXECUTION_FAILOVER, item);
    }

    static String getExecutingFailoverNode(int item) {
        return String.format(EXECUTING_FAILOVER, item);
    }

    public Integer getItemByExecutionFailoverPath(String path) {
        if (!this.isFailoverPath(path)) {
            return null;
        }
        return Integer.parseInt(path.substring(this.jobNodePath.getFullPath("sharding").length() + 1, path.lastIndexOf(FAILOVER) - 1));
    }

    private boolean isFailoverPath(String path) {
        return path.startsWith(this.jobNodePath.getFullPath("sharding")) && path.endsWith(FAILOVER);
    }
}

