/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.zabbix.provider.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.ResourceUtils;
import org.apache.skywalking.oap.server.receiver.zabbix.provider.config.ZabbixConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class ZabbixConfigs {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZabbixConfigs.class);

    public static List<ZabbixConfig> loadConfigs(String path, List<String> fileNames) throws ModuleStartException {
        File[] configs;
        if (CollectionUtils.isEmpty(fileNames)) {
            return Collections.emptyList();
        }
        try {
            configs = ResourceUtils.getPathFiles((String)path);
        }
        catch (FileNotFoundException e) {
            throw new ModuleStartException("Load zabbix configs failed", (Throwable)e);
        }
        return Arrays.stream(configs).filter(File::isFile).map(f -> {
            ZabbixConfig zabbixConfig;
            String fileName = f.getName();
            int dotIndex = fileName.lastIndexOf(46);
            String string = fileName = dotIndex == -1 ? fileName : fileName.substring(0, dotIndex);
            if (!fileNames.contains(fileName)) {
                return null;
            }
            FileReader r = new FileReader((File)f);
            try {
                zabbixConfig = (ZabbixConfig)new Yaml().loadAs((Reader)r, ZabbixConfig.class);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)r).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.warn("Reading file {} failed", f, (Object)e);
                    return null;
                }
            }
            ((Reader)r).close();
            return zabbixConfig;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

