/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.alarm.provider.welink;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.alarm.AlarmMessage;
import org.apache.skywalking.oap.server.core.alarm.HttpAlarmCallback;
import org.apache.skywalking.oap.server.core.alarm.provider.AlarmRulesWatcher;
import org.apache.skywalking.oap.server.core.alarm.provider.welink.WeLinkSettings;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeLinkHookCallback
extends HttpAlarmCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WeLinkHookCallback.class);
    private final AlarmRulesWatcher alarmRulesWatcher;

    public void doAlarm(List<AlarmMessage> alarmMessages) throws Exception {
        Map<String, WeLinkSettings> settingsMap = this.alarmRulesWatcher.getWeLinkSettings();
        if (settingsMap == null || settingsMap.isEmpty()) {
            return;
        }
        Map groupedMessages = this.groupMessagesByHook(alarmMessages);
        for (Map.Entry entry : groupedMessages.entrySet()) {
            String hookName = (String)entry.getKey();
            List messages = (List)entry.getValue();
            WeLinkSettings setting = settingsMap.get(hookName);
            if (setting == null || CollectionUtils.isEmpty(setting.getWebhooks()) || CollectionUtils.isEmpty((List)messages)) continue;
            for (WeLinkSettings.WebHookUrl webHookUrl : setting.getWebhooks()) {
                String accessToken = this.getAccessToken(webHookUrl);
                for (AlarmMessage alarmMessage : messages) {
                    String content = String.format(setting.getTextTemplate(), alarmMessage.getAlarmMessage());
                    this.sendAlarmMessage(webHookUrl, accessToken, content);
                }
            }
        }
    }

    private void sendAlarmMessage(WeLinkSettings.WebHookUrl webHookUrl, String accessToken, String content) throws IOException, InterruptedException {
        JsonObject appServiceInfo = new JsonObject();
        appServiceInfo.addProperty("app_service_id", "1");
        appServiceInfo.addProperty("app_service_name", webHookUrl.getRobotName());
        JsonArray groupIds = new JsonArray();
        Arrays.stream(webHookUrl.getGroupIds().split(",")).forEach(arg_0 -> ((JsonArray)groupIds).add(arg_0));
        JsonObject body = new JsonObject();
        body.add("app_service_info", (JsonElement)appServiceInfo);
        body.addProperty("app_msg_id", UUID.randomUUID().toString());
        body.add("group_id", (JsonElement)groupIds);
        body.addProperty("content", String.format(Locale.US, "<r><n></n><g>0</g><c>&lt;imbody&gt;&lt;imagelist/&gt;&lt;html&gt;&lt;![CDATA[&lt;DIV&gt;%s&lt;/DIV&gt;]]&gt;&lt;/html&gt;&lt;content&gt;&lt;![CDATA[%s]]&gt;&lt;/content&gt;&lt;/imbody&gt;</c></r>", content, content));
        body.addProperty("content_type", (Number)0);
        body.addProperty("client_app_id", "1");
        String requestBody = body.toString();
        this.post(URI.create(webHookUrl.getMessageUrl()), requestBody, Collections.singletonMap("x-wlk-Authorization", accessToken));
    }

    private String getAccessToken(WeLinkSettings.WebHookUrl webHookUrl) throws IOException, InterruptedException {
        String accessTokenUrl = webHookUrl.getAccessTokenUrl();
        String clientId = webHookUrl.getClientId();
        String clientSecret = webHookUrl.getClientSecret();
        String response = this.post(URI.create(accessTokenUrl), String.format(Locale.US, "{\"client_id\":%s,\"client_secret\":%s}", clientId, clientSecret), Collections.emptyMap());
        Gson gson = new Gson();
        JsonObject responseJson = (JsonObject)gson.fromJson(response, JsonObject.class);
        return Optional.ofNullable(responseJson).map(r -> r.get("access_token")).map(JsonElement::getAsString).orElse("");
    }

    @Generated
    public WeLinkHookCallback(AlarmRulesWatcher alarmRulesWatcher) {
        this.alarmRulesWatcher = alarmRulesWatcher;
    }
}

