/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client;

import com.google.protobuf.GeneratedMessageV3;
import java.util.Map;
import java.util.Optional;
import org.apache.skywalking.banyandb.common.v1.BanyandbCommon;
import org.apache.skywalking.banyandb.model.v1.BanyandbModel;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBException;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.InvalidReferenceException;
import org.apache.skywalking.banyandb.v1.client.metadata.MetadataCache;
import org.apache.skywalking.banyandb.v1.client.metadata.Serializable;

public abstract class AbstractWrite<P extends GeneratedMessageV3> {
    protected Optional<Long> timestamp;
    protected final Object[] tags;
    protected final MetadataCache.EntityMetadata entityMetadata;

    public AbstractWrite(MetadataCache.EntityMetadata entityMetadata, long timestamp) {
        this(entityMetadata);
        this.timestamp = Optional.of(timestamp);
    }

    AbstractWrite(MetadataCache.EntityMetadata entityMetadata) {
        if (entityMetadata == null) {
            throw new IllegalArgumentException("metadata not found");
        }
        this.entityMetadata = entityMetadata;
        this.tags = new Object[this.entityMetadata.getTotalTags()];
    }

    public AbstractWrite<P> tag(String tagName, Serializable<BanyandbModel.TagValue> tagValue) throws BanyanDBException {
        Optional<MetadataCache.TagInfo> tagInfo = this.entityMetadata.findTagInfo(tagName);
        if (!tagInfo.isPresent()) {
            throw InvalidReferenceException.fromInvalidTag(tagName);
        }
        this.tags[tagInfo.get().getOffset()] = tagValue;
        return this;
    }

    public P build() {
        BanyandbCommon.Metadata metadata = BanyandbCommon.Metadata.newBuilder().setGroup(this.entityMetadata.getGroup()).setName(this.entityMetadata.getName()).setModRevision(this.entityMetadata.getModRevision()).build();
        return this.build(metadata);
    }

    protected abstract P build(BanyandbCommon.Metadata var1);

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("group=").append(this.entityMetadata.getGroup()).append(", ").append("name=").append(this.entityMetadata.getName()).append(", ").append("timestamp=").append(this.timestamp).append(", ");
        for (int i = 0; i < this.tags.length; ++i) {
            int index = i;
            Map<String, MetadataCache.TagInfo> tagMap = this.entityMetadata.getTagOffset();
            Optional<String> tagName = tagMap.keySet().stream().filter(name -> ((MetadataCache.TagInfo)tagMap.get(name)).getOffset() == index).findAny();
            if (!tagName.isPresent()) continue;
            stringBuilder.append(tagName.get()).append("=").append(((Serializable)this.tags[i]).serialize()).append(", ");
        }
        return stringBuilder.toString();
    }

    public Optional<Long> getTimestamp() {
        return this.timestamp;
    }

    public MetadataCache.EntityMetadata getEntityMetadata() {
        return this.entityMetadata;
    }
}

