/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.cpu.policy;

import org.apache.skywalking.apm.agent.core.boot.OverrideImplementor;
import org.apache.skywalking.apm.agent.core.boot.ServiceManager;
import org.apache.skywalking.apm.agent.core.jvm.JVMService;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.sampling.SamplingService;
import org.apache.skywalking.apm.plugin.cpu.policy.conf.TraceSamplerCpuPolicyPluginConfig;

@OverrideImplementor(value=SamplingService.class)
public class TraceSamplerCpuPolicyExtendService
extends SamplingService {
    private static final ILog LOGGER = LogManager.getLogger(TraceSamplerCpuPolicyExtendService.class);
    private volatile boolean cpuUsagePercentLimitOn = false;
    private volatile JVMService jvmService;

    public void prepare() {
        super.prepare();
    }

    public void boot() {
        super.boot();
        if (TraceSamplerCpuPolicyPluginConfig.Plugin.CpuPolicy.SAMPLE_CPU_USAGE_PERCENT_LIMIT > 0.0) {
            LOGGER.info("TraceSamplerCpuPolicyExtendService cpu usage percent limit open");
            this.jvmService = (JVMService)ServiceManager.INSTANCE.findService(JVMService.class);
            this.cpuUsagePercentLimitOn = true;
        }
    }

    public void onComplete() {
    }

    public void shutdown() {
        super.shutdown();
    }

    public boolean trySampling(String operationName) {
        double cpuUsagePercent;
        if (this.cpuUsagePercentLimitOn && (cpuUsagePercent = this.jvmService.getCpuUsagePercent()) > TraceSamplerCpuPolicyPluginConfig.Plugin.CpuPolicy.SAMPLE_CPU_USAGE_PERCENT_LIMIT) {
            return false;
        }
        return super.trySampling(operationName);
    }

    public void forceSampled() {
        super.forceSampled();
    }
}

