/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.feature.ChiSqSelector;
import org.apache.spark.mllib.feature.ChiSqSelectorModel;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.RichDouble$;
import scala.runtime.java8.JFunction1;

public final class ChiSqSelectorExample$ {
    public static final ChiSqSelectorExample$ MODULE$ = new ChiSqSelectorExample$();

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("ChiSqSelectorExample");
        SparkContext sc = new SparkContext(conf);
        RDD data = MLUtils$.MODULE$.loadLibSVMFile(sc, "data/mllib/sample_libsvm_data.txt");
        RDD discretizedData = data.map((Function1 & Serializable)lp -> new LabeledPoint(lp.label(), Vectors$.MODULE$.dense((double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(lp.features().toArray()), (Function1)(JFunction1.mcDD.sp & Serializable)x -> RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(x / (double)16)), (ClassTag)ClassTag$.MODULE$.Double()))), ClassTag$.MODULE$.apply(LabeledPoint.class));
        ChiSqSelector selector = new ChiSqSelector(50);
        ChiSqSelectorModel transformer = selector.fit(discretizedData);
        RDD filteredData = discretizedData.map((Function1 & Serializable)lp -> new LabeledPoint(lp.label(), transformer.transform(lp.features())), ClassTag$.MODULE$.apply(LabeledPoint.class));
        Predef$.MODULE$.println((Object)"filtered data: ");
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])filteredData.collect()), (Function1 & Serializable)x -> {
            Predef$.MODULE$.println((Object)x);
            return BoxedUnit.UNIT;
        });
        sc.stop();
    }

    private ChiSqSelectorExample$() {
    }
}

