/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.QuaternaryExpression;
import org.apache.spark.sql.catalyst.expressions.RegExpReplace$;
import org.apache.spark.sql.catalyst.expressions.RegExpUtils$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.types.StringTypeBinaryLcase$;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function4;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ExpressionDescription(usage="_FUNC_(str, regexp, rep[, position]) - Replaces all substrings of `str` that match `regexp` with `rep`.", arguments="\n    Arguments:\n      * str - a string expression to search for a regular expression pattern match.\n      * regexp - a string representing a regular expression. The regex string should be a\n          Java regular expression.<br><br>\n          Since Spark 2.0, string literals (including regex patterns) are unescaped in our SQL\n          parser, see the unescaping rules at <a href=\"https://spark.apache.org/docs/latest/sql-ref-literals.html#string-literal\">String Literal</a>.\n          For example, to match \"\\abc\", a regular expression for `regexp` can be \"^\\\\abc$\".<br><br>\n          There is a SQL config 'spark.sql.parser.escapedStringLiterals' that can be used to\n          fallback to the Spark 1.6 behavior regarding string literal parsing. For example,\n          if the config is enabled, the `regexp` that can match \"\\abc\" is \"^\\abc$\".<br><br>\n          It's recommended to use a raw string literal (with the `r` prefix) to avoid escaping\n          special characters in the pattern string if exists.\n      * rep - a string expression to replace matched substrings.\n      * position - a positive integer literal that indicates the position within `str` to begin searching.\n          The default is 1. If position is greater than the number of characters in `str`, the result is `str`.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('100-200', '(\\\\d+)', 'num');\n       num-num\n      > SELECT _FUNC_('100-200', r'(\\d+)', 'num');\n       num-num\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\r-a\u0001\u0002\u001e<\u0001\"C\u0001B\u0019\u0001\u0003\u0016\u0004%\ta\u0019\u0005\tO\u0002\u0011\t\u0012)A\u0005I\"A\u0001\u000e\u0001BK\u0002\u0013\u00051\r\u0003\u0005j\u0001\tE\t\u0015!\u0003e\u0011!Q\u0007A!f\u0001\n\u0003\u0019\u0007\u0002C6\u0001\u0005#\u0005\u000b\u0011\u00023\t\u00111\u0004!Q3A\u0005\u0002\rD\u0001\"\u001c\u0001\u0003\u0012\u0003\u0006I\u0001\u001a\u0005\u0006]\u0002!\ta\u001c\u0005\u0006k\u0002!\tE\u001e\u0005\u0006]\u0002!\tA\u001f\u0005\u0006}\u0002!\te \u0005\f\u0003\u001b\u0001\u0001\u0019!a\u0001\n\u0013\ty\u0001C\u0006\u0002\"\u0001\u0001\r\u00111A\u0005\n\u0005\r\u0002bCA\u0018\u0001\u0001\u0007\t\u0011)Q\u0005\u0003#A1\"!\u000f\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002<!Y\u0011\u0011\u000b\u0001A\u0002\u0003\u0007I\u0011BA*\u0011-\t9\u0006\u0001a\u0001\u0002\u0003\u0006K!!\u0010\t\u0017\u0005m\u0003\u00011AA\u0002\u0013%\u0011Q\f\u0005\f\u0003_\u0002\u0001\u0019!a\u0001\n\u0013\t\t\bC\u0006\u0002v\u0001\u0001\r\u0011!Q!\n\u0005}\u0003bCA=\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u001fA1\"a\u001f\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002~!Y\u0011\u0011\u0011\u0001A\u0002\u0003\u0005\u000b\u0015BA\t\u0011)\t)\t\u0001EC\u0002\u0013%\u0011q\u0011\u0005\n\u0003/\u0003!\u0019!C#\u00033C\u0001\"a3\u0001A\u00035\u00111\u0014\u0005\b\u0003\u001b\u0004A\u0011IAh\u0011\u001d\t9\u000f\u0001C!\u0003SDq!!>\u0001\t\u0003\n9\u0010\u0003\u0006\u0003\u0002\u0001A)\u0019!C\u0003\u0005\u0007AqAa\u0003\u0001\t\u0003\ni\u0006C\u0004\u0003\u000e\u0001!\tFa\u0004\t\r\t-\u0002\u0001\"\u0011d\u0011\u0019\u0011i\u0003\u0001C!G\"1!q\u0006\u0001\u0005B\rDaA!\r\u0001\t\u0003\u001a\u0007b\u0002B\u001a\u0001\u0011E#Q\u0007\u0005\n\u0005\u007f\u0001\u0011\u0011!C\u0001\u0005\u0003B\u0011Ba\u0013\u0001#\u0003%\tA!\u0014\t\u0013\t\r\u0004!%A\u0005\u0002\t5\u0003\"\u0003B3\u0001E\u0005I\u0011\u0001B'\u0011%\u00119\u0007AI\u0001\n\u0003\u0011i\u0005C\u0005\u0003j\u0001\t\t\u0011\"\u0011\u0003l!I!\u0011\u000f\u0001\u0002\u0002\u0013\u0005!1\u0001\u0005\n\u0005g\u0002\u0011\u0011!C\u0001\u0005kB\u0011B!\u001f\u0001\u0003\u0003%\tEa\u001f\t\u0013\t%\u0005!!A\u0005\u0002\t-\u0005\"\u0003BH\u0001\u0005\u0005I\u0011\tBI\u0011%\u0011)\nAA\u0001\n\u0003\u00129jB\u0004\u0003BnB\tAa1\u0007\riZ\u0004\u0012\u0001Bc\u0011\u0019qG\u0007\"\u0001\u0003X\"9!\u0011\u001c\u001b\u0005\u0002\tm\u0007\"\u0003Bmi\u0005\u0005I\u0011\u0011Br\u0011%\u0011i\u000fNA\u0001\n\u0003\u0013y\u000fC\u0005\u0004\u0002Q\n\t\u0011\"\u0003\u0004\u0004\ti!+Z4FqB\u0014V\r\u001d7bG\u0016T!\u0001P\u001f\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003}}\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u0001\u0006\u000b1a]9m\u0015\t\u00115)A\u0003ta\u0006\u00148N\u0003\u0002E\u000b\u00061\u0011\r]1dQ\u0016T\u0011AR\u0001\u0004_J<7\u0001A\n\u0006\u0001%k\u0005K\u0016\t\u0003\u0015.k\u0011aO\u0005\u0003\u0019n\u0012A#U;bi\u0016\u0014h.\u0019:z\u000bb\u0004(/Z:tS>t\u0007C\u0001&O\u0013\ty5H\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\t\tF+D\u0001S\u0015\u0005\u0019\u0016!B:dC2\f\u0017BA+S\u0005\u001d\u0001&o\u001c3vGR\u0004\"aV0\u000f\u0005akfBA-]\u001b\u0005Q&BA.H\u0003\u0019a$o\\8u}%\t1+\u0003\u0002_%\u00069\u0001/Y2lC\u001e,\u0017B\u00011b\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\tq&+A\u0004tk\nTWm\u0019;\u0016\u0003\u0011\u0004\"AS3\n\u0005\u0019\\$AC#yaJ,7o]5p]\u0006A1/\u001e2kK\u000e$\b%\u0001\u0004sK\u001e,\u0007\u0010]\u0001\be\u0016<W\r\u001f9!\u0003\r\u0011X\r]\u0001\u0005e\u0016\u0004\b%A\u0002q_N\fA\u0001]8tA\u00051A(\u001b8jiz\"R\u0001]9sgR\u0004\"A\u0013\u0001\t\u000b\tL\u0001\u0019\u00013\t\u000b!L\u0001\u0019\u00013\t\u000b)L\u0001\u0019\u00013\t\u000b1L\u0001\u0019\u00013\u0002\u001d9,H\u000e\\%oi>dWM]1oiV\tq\u000f\u0005\u0002Rq&\u0011\u0011P\u0015\u0002\b\u0005>|G.Z1o)\u0011\u00018\u0010`?\t\u000b\t\\\u0001\u0019\u00013\t\u000b!\\\u0001\u0019\u00013\t\u000b)\\\u0001\u0019\u00013\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0005\u0005\u0005\u0001\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001dQ(\u0001\u0005b]\u0006d\u0017p]5t\u0013\u0011\tY!!\u0002\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYR\f\u0011\u0002\\1tiJ+w-\u001a=\u0016\u0005\u0005E\u0001\u0003BA\n\u0003;i!!!\u0006\u000b\t\u0005]\u0011\u0011D\u0001\u0006if\u0004Xm\u001d\u0006\u0004\u00037\t\u0015AB;og\u00064W-\u0003\u0003\u0002 \u0005U!AC+U\rb\u001aFO]5oO\u0006iA.Y:u%\u0016<W\r_0%KF$B!!\n\u0002,A\u0019\u0011+a\n\n\u0007\u0005%\"K\u0001\u0003V]&$\b\"CA\u0017\u001d\u0005\u0005\t\u0019AA\t\u0003\rAH%M\u0001\u000bY\u0006\u001cHOU3hKb\u0004\u0003fA\b\u00024A\u0019\u0011+!\u000e\n\u0007\u0005]\"KA\u0005ue\u0006t7/[3oi\u00069\u0001/\u0019;uKJtWCAA\u001f!\u0011\ty$!\u0014\u000e\u0005\u0005\u0005#\u0002BA\"\u0003\u000b\nQA]3hKbTA!a\u0012\u0002J\u0005!Q\u000f^5m\u0015\t\tY%\u0001\u0003kCZ\f\u0017\u0002BA(\u0003\u0003\u0012q\u0001U1ui\u0016\u0014h.A\u0006qCR$XM\u001d8`I\u0015\fH\u0003BA\u0013\u0003+B\u0011\"!\f\u0012\u0003\u0003\u0005\r!!\u0010\u0002\u0011A\fG\u000f^3s]\u0002B3AEA\u001a\u0003=a\u0017m\u001d;SKBd\u0017mY3nK:$XCAA0!\u0011\t\t'!\u001b\u000f\t\u0005\r\u0014Q\r\t\u00033JK1!a\u001aS\u0003\u0019\u0001&/\u001a3fM&!\u00111NA7\u0005\u0019\u0019FO]5oO*\u0019\u0011q\r*\u0002'1\f7\u000f\u001e*fa2\f7-Z7f]R|F%Z9\u0015\t\u0005\u0015\u00121\u000f\u0005\n\u0003[!\u0012\u0011!a\u0001\u0003?\n\u0001\u0003\\1tiJ+\u0007\u000f\\1dK6,g\u000e\u001e\u0011)\u0007U\t\u0019$A\u000bmCN$(+\u001a9mC\u000e,W.\u001a8u\u0013:,FK\u0012\u001d\u000231\f7\u000f\u001e*fa2\f7-Z7f]RLe.\u0016+Gq}#S-\u001d\u000b\u0005\u0003K\ty\bC\u0005\u0002.]\t\t\u00111\u0001\u0002\u0012\u00051B.Y:u%\u0016\u0004H.Y2f[\u0016tG/\u00138V)\u001aC\u0004\u0005K\u0002\u0019\u0003g\taA]3tk2$XCAAE!\u0011\tY)!%\u000e\u0005\u00055%\u0002BAH\u0003\u0013\nA\u0001\\1oO&!\u00111SAG\u00055\u0019FO]5oO\n+\u0018\u000e\u001c3fe\"\u001a\u0011$a\r\u0002\u00199|G-\u001a)biR,'O\\:\u0016\u0005\u0005m\u0005#B,\u0002\u001e\u0006\u0005\u0016bAAPC\n\u00191+Z9\u0011\t\u0005\r\u0016Q\u0019\b\u0005\u0003K\u000byL\u0004\u0003\u0002(\u0006mf\u0002BAU\u0003ssA!a+\u00028:!\u0011QVA[\u001d\u0011\ty+a-\u000f\u0007e\u000b\t,C\u0001G\u0013\t!U)\u0003\u0002C\u0007&\u0011\u0001)Q\u0005\u0003}}J1!!0>\u0003\u0015!(/Z3t\u0013\u0011\t\t-a1\u0002\u0017Q\u0013X-\u001a)biR,'O\u001c\u0006\u0004\u0003{k\u0014\u0002BAd\u0003\u0013\u00141\u0002\u0016:fKB\u000bG\u000f^3s]*!\u0011\u0011YAb\u00035qw\u000eZ3QCR$XM\u001d8tA\u0005aa.\u001e7m'\u00064W-\u0012<bYRQ\u0011\u0011[Al\u00037\fy.a9\u0011\u0007E\u000b\u0019.C\u0002\u0002VJ\u00131!\u00118z\u0011\u001d\tI\u000e\ba\u0001\u0003#\f\u0011a\u001d\u0005\b\u0003;d\u0002\u0019AAi\u0003\u0005\u0001\bbBAq9\u0001\u0007\u0011\u0011[\u0001\u0002e\"9\u0011Q\u001d\u000fA\u0002\u0005E\u0017!A5\u0002\u0011\u0011\fG/\u0019+za\u0016,\"!a;\u0011\t\u00055\u0018\u0011_\u0007\u0003\u0003_T1!a\u0006@\u0013\u0011\t\u00190a<\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!\"\u001b8qkR$\u0016\u0010]3t+\t\tI\u0010E\u0003X\u0003;\u000bY\u0010\u0005\u0003\u0002n\u0006u\u0018\u0002BA\u0000\u0003_\u0014\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u0017\r|G\u000e\\1uS>t\u0017\nZ\u000b\u0003\u0005\u000b\u00012!\u0015B\u0004\u0013\r\u0011IA\u0015\u0002\u0004\u0013:$\u0018A\u00039sKR$\u0018PT1nK\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0005#\u0011iBa\n\u0011\t\tM!\u0011D\u0007\u0003\u0005+Q1Aa\u0006<\u0003\u001d\u0019w\u000eZ3hK:LAAa\u0007\u0003\u0016\tAQ\t\u001f9s\u0007>$W\rC\u0004\u0003 \u0005\u0002\rA!\t\u0002\u0007\r$\b\u0010\u0005\u0003\u0003\u0014\t\r\u0012\u0002\u0002B\u0013\u0005+\u0011abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0003*\u0005\u0002\rA!\u0005\u0002\u0005\u00154\u0018!\u00024jeN$\u0018AB:fG>tG-A\u0003uQ&\u0014H-\u0001\u0004g_V\u0014H\u000f[\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$\u0012\u0002\u001dB\u001c\u0005s\u0011YD!\u0010\t\r\t-b\u00051\u0001e\u0011\u0019\u0011iC\na\u0001I\"1!q\u0006\u0014A\u0002\u0011DaA!\r'\u0001\u0004!\u0017\u0001B2paf$\u0012\u0002\u001dB\"\u0005\u000b\u00129E!\u0013\t\u000f\t<\u0003\u0013!a\u0001I\"9\u0001n\nI\u0001\u0002\u0004!\u0007b\u00026(!\u0003\u0005\r\u0001\u001a\u0005\bY\u001e\u0002\n\u00111\u0001e\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"Aa\u0014+\u0007\u0011\u0014\tf\u000b\u0002\u0003TA!!Q\u000bB0\u001b\t\u00119F\u0003\u0003\u0003Z\tm\u0013!C;oG\",7m[3e\u0015\r\u0011iFU\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B1\u0005/\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011i\u0007\u0005\u0003\u0002\f\n=\u0014\u0002BA6\u0003\u001b\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002R\n]\u0004\"CA\u0017]\u0005\u0005\t\u0019\u0001B\u0003\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B?!\u0019\u0011yH!\"\u0002R6\u0011!\u0011\u0011\u0006\u0004\u0005\u0007\u0013\u0016AC2pY2,7\r^5p]&!!q\u0011BA\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007]\u0014i\tC\u0005\u0002.A\n\t\u00111\u0001\u0002R\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\u0011iGa%\t\u0013\u00055\u0012'!AA\u0002\t\u0015\u0011AB3rk\u0006d7\u000fF\u0002x\u00053C\u0011\"!\f3\u0003\u0003\u0005\r!!5)/\u0001\u0011iJa)\u0003&\n%&1\u0016BX\u0005c\u0013)La.\u0003<\nu\u0006c\u0001&\u0003 &\u0019!\u0011U\u001e\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!qU\u0001h?\u001a+fjQ0)gR\u0014H\u0006\t:fO\u0016D\b\u000f\f\u0011sKB\\F\u0006\t9pg&$\u0018n\u001c8^S\u0001j\u0003EU3qY\u0006\u001cWm\u001d\u0011bY2\u00043/\u001e2tiJLgnZ:!_\u001a\u0004\u0003m\u001d;sA\u0002\"\b.\u0019;![\u0006$8\r\u001b\u0011ae\u0016<W\r\u001f9aA]LG\u000f\u001b\u0011ae\u0016\u0004\bML\u0001\nCJ<W/\\3oiN\f#A!,\u0002\u0015KQ\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006I:ue\u0002j\u0003%\u0019\u0011tiJLgn\u001a\u0011fqB\u0014Xm]:j_:\u0004Co\u001c\u0011tK\u0006\u00148\r\u001b\u0011g_J\u0004\u0013\r\t:fOVd\u0017M\u001d\u0011fqB\u0014Xm]:j_:\u0004\u0003/\u0019;uKJt\u0007%\\1uG\"t#\u0002\t\u0011!A\u0001\u0002#\u0006\t:fO\u0016D\b\u000fI\u0017!C\u0002\u001aHO]5oO\u0002\u0012X\r\u001d:fg\u0016tG/\u001b8hA\u0005\u0004#/Z4vY\u0006\u0014\b%\u001a=qe\u0016\u001c8/[8o]\u0001\"\u0006.\u001a\u0011sK\u001e,\u0007\u0010I:ue&tw\rI:i_VdG\r\t2fA\u0005T\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011KCZ\f\u0007E]3hk2\f'\u000fI3yaJ,7o]5p]:b$M\u001d =EJt$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!'&t7-\u001a\u0011Ta\u0006\u00148\u000e\t\u001a/a1\u00023\u000f\u001e:j]\u001e\u0004C.\u001b;fe\u0006d7\u000f\t\u0015j]\u000edW\u000fZ5oO\u0002\u0012XmZ3yAA\fG\u000f^3s]NL\u0003%\u0019:fAUtWm]2ba\u0016$\u0007%\u001b8!_V\u0014\beU)M\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005]1sg\u0016\u0014H\u0006I:fK\u0002\"\b.\u001a\u0011v]\u0016\u001c8-\u00199j]\u001e\u0004#/\u001e7fg\u0002\nG\u000f\t\u001fbA!\u0014XMZ\u001f#QR$\bo\u001d\u001e0_M\u0004\u0018M]6/CB\f7\r[3/_J<w\u0006Z8dg>b\u0017\r^3ti>\u001a\u0018\u000f\\\u0017sK\u001alC.\u001b;fe\u0006d7O\f5u[2\u001c3\u000f\u001e:j]\u001elC.\u001b;fe\u0006d'EP*ue&tw\r\t'ji\u0016\u0014\u0018\r\u001c\u001f0Czr#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!\r>\u0014\b%\u001a=b[BdW\r\f\u0011u_\u0002j\u0017\r^2iA\tb\u0016MY2#Y\u0001\n\u0007E]3hk2\f'\u000fI3yaJ,7o]5p]\u00022wN\u001d\u0011ae\u0016<W\r\u001f9aA\r\fg\u000e\t2fA\trF\fX1cG\u0012\u0012c\u0006\u00102s}q\u0012'O\u0010\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\"\u0006.\u001a:fA%\u001c\b%\u0019\u0011T#2\u00033m\u001c8gS\u001e\u0004se\u001d9be.t3/\u001d7/a\u0006\u00148/\u001a:/KN\u001c\u0017\r]3e'R\u0014\u0018N\\4MSR,'/\u00197tO\u0001\"\b.\u0019;!G\u0006t\u0007EY3!kN,G\r\t;p\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003EZ1mY\n\f7m\u001b\u0011u_\u0002\"\b.\u001a\u0011Ta\u0006\u00148\u000eI\u0019/m\u0001\u0012W\r[1wS>\u0014\bE]3hCJ$\u0017N\\4!gR\u0014\u0018N\\4!Y&$XM]1mAA\f'o]5oO:\u0002ci\u001c:!Kb\fW\u000e\u001d7fY)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I5gAQDW\rI2p]\u001aLw\rI5tA\u0015t\u0017M\u00197fI2\u0002C\u000f[3!AJ,w-\u001a=qA\u0002\"\b.\u0019;!G\u0006t\u0007%\\1uG\"\u0004#\u0005X1cG\n\u0002\u0013n\u001d\u0011#=r\u000b'm\u0019\u0013#]q\u0012'O\u0010\u001fcezR\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011Ji\u001e\u001a\bE]3d_6lWM\u001c3fI\u0002\"x\u000eI;tK\u0002\n\u0007E]1xAM$(/\u001b8hA1LG/\u001a:bY\u0002Bs/\u001b;iAQDW\r\t1sA\u0002\u0002(/\u001a4jq&\u0002Co\u001c\u0011bm>LG\rI3tG\u0006\u0004\u0018N\\4\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u00023\u000f]3dS\u0006d\u0007e\u00195be\u0006\u001cG/\u001a:tA%t\u0007\u0005\u001e5fAA\fG\u000f^3s]\u0002\u001aHO]5oO\u0002Jg\rI3ySN$8O\f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!e\u0016\u0004\b%\f\u0011bAM$(/\u001b8hA\u0015D\bO]3tg&|g\u000e\t;pAI,\u0007\u000f\\1dK\u0002j\u0017\r^2iK\u0012\u00043/\u001e2tiJLgnZ:/\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\u0002xn]5uS>t\u0007%\f\u0011bAA|7/\u001b;jm\u0016\u0004\u0013N\u001c;fO\u0016\u0014\b\u0005\\5uKJ\fG\u000e\t;iCR\u0004\u0013N\u001c3jG\u0006$Xm\u001d\u0011uQ\u0016\u0004\u0003o\\:ji&|g\u000eI<ji\"Lg\u000e\t1tiJ\u0004\u0007\u0005^8!E\u0016<\u0017N\u001c\u0011tK\u0006\u00148\r[5oO:R\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011UQ\u0016\u0004C-\u001a4bk2$\b%[:!c9\u0002\u0013J\u001a\u0011q_NLG/[8oA%\u001c\be\u001a:fCR,'\u000f\t;iC:\u0004C\u000f[3!]Vl'-\u001a:!_\u001a\u00043\r[1sC\u000e$XM]:!S:\u0004\u0003m\u001d;sA2\u0002C\u000f[3!e\u0016\u001cX\u000f\u001c;!SN\u0004\u0003m\u001d;sA:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!1W\u0001\u0002,)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%\r\u00191[I\u0002\u0004g\n\u0017!O!bF\fZ\u0016*O1\u0002sE\\;nO%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\\;n[9,XN\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(cA\u0002TF\r\u00191O1\u0002#o\n\u0015]I.Js\u0005\f\u0011(]Vlw%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!]VlWF\\;n\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017E\u0001B]\u0003\u0015\td&\u000e\u00181\u0003\u00159'o\\;qC\t\u0011y,\u0001\u0007tiJLgnZ0gk:\u001c7/A\u0007SK\u001e,\u0005\u0010\u001d*fa2\f7-\u001a\t\u0003\u0015R\u001aR\u0001\u000eBd\u0005\u001b\u00042!\u0015Be\u0013\r\u0011YM\u0015\u0002\u0007\u0003:L(+\u001a4\u0011\t\t='Q[\u0007\u0003\u0005#TAAa5\u0002J\u0005\u0011\u0011n\\\u0005\u0004A\nEGC\u0001Bb\u0003\u0015\t\u0007\u000f\u001d7z)\u001d\u0001(Q\u001cBp\u0005CDQA\u0019\u001cA\u0002\u0011DQ\u0001\u001b\u001cA\u0002\u0011DQA\u001b\u001cA\u0002\u0011$\u0012\u0002\u001dBs\u0005O\u0014IOa;\t\u000b\t<\u0004\u0019\u00013\t\u000b!<\u0004\u0019\u00013\t\u000b)<\u0004\u0019\u00013\t\u000b1<\u0004\u0019\u00013\u0002\u000fUt\u0017\r\u001d9msR!!\u0011\u001fB\u007f!\u0015\t&1\u001fB|\u0013\r\u0011)P\u0015\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000fE\u0013I\u0010\u001a3eI&\u0019!1 *\u0003\rQ+\b\u000f\\35\u0011!\u0011y\u0010OA\u0001\u0002\u0004\u0001\u0018a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u00111Q\u0001\t\u0005\u0003\u0017\u001b9!\u0003\u0003\u0004\n\u00055%AB(cU\u0016\u001cG\u000f")
public class RegExpReplace
extends QuaternaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private transient StringBuilder result;
    private int collationId;
    private final Expression subject;
    private final Expression regexp;
    private final Expression rep;
    private final Expression pos;
    private transient UTF8String lastRegex;
    private transient Pattern pattern;
    private transient String lastReplacement;
    private transient UTF8String lastReplacementInUTF8;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple4<Expression, Expression, Expression, Expression>> unapply(RegExpReplace x$0) {
        return RegExpReplace$.MODULE$.unapply(x$0);
    }

    public Expression subject() {
        return this.subject;
    }

    public Expression regexp() {
        return this.regexp;
    }

    public Expression rep() {
        return this.rep;
    }

    public Expression pos() {
        return this.pos;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        if (defaultCheck.isFailure()) {
            return defaultCheck;
        }
        if (!this.pos().foldable()) {
            return new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)Cast$.MODULE$.toSQLId("position")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)Cast$.MODULE$.toSQLType((AbstractDataType)this.pos().dataType())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)Cast$.MODULE$.toSQLExpr(this.pos()))}))));
        }
        Object posEval = this.pos().eval(this.pos().eval$default$1());
        if (posEval == null || BoxesRunTime.unboxToInt((Object)posEval) > 0) {
            return TypeCheckResult$TypeCheckSuccess$.MODULE$;
        }
        return new TypeCheckResult.DataTypeMismatch("VALUE_OUT_OF_RANGE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exprName"), (Object)"position"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueRange"), (Object)("(0, " + Integer.MAX_VALUE + "]")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currentValue"), (Object)Cast$.MODULE$.toSQLValue(posEval, this.pos().dataType()))}))));
    }

    private UTF8String lastRegex() {
        return this.lastRegex;
    }

    private void lastRegex_$eq(UTF8String x$1) {
        this.lastRegex = x$1;
    }

    private Pattern pattern() {
        return this.pattern;
    }

    private void pattern_$eq(Pattern x$1) {
        this.pattern = x$1;
    }

    private String lastReplacement() {
        return this.lastReplacement;
    }

    private void lastReplacement_$eq(String x$1) {
        this.lastReplacement = x$1;
    }

    private UTF8String lastReplacementInUTF8() {
        return this.lastReplacementInUTF8;
    }

    private void lastReplacementInUTF8_$eq(UTF8String x$1) {
        this.lastReplacementInUTF8 = x$1;
    }

    private StringBuilder result$lzycompute() {
        RegExpReplace regExpReplace = this;
        synchronized (regExpReplace) {
            if (!this.bitmap$trans$0) {
                this.result = new StringBuilder();
                this.bitmap$trans$0 = true;
            }
        }
        return this.result;
    }

    private StringBuilder result() {
        if (!this.bitmap$trans$0) {
            return this.result$lzycompute();
        }
        return this.result;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public Object nullSafeEval(Object s, Object p, Object r, Object i) {
        if (!p.equals(this.lastRegex())) {
            Tuple2<Pattern, UTF8String> patternAndRegex = RegExpUtils$.MODULE$.getPatternAndLastRegex(p, this.prettyName(), this.collationId());
            this.pattern_$eq((Pattern)patternAndRegex._1());
            this.lastRegex_$eq((UTF8String)patternAndRegex._2());
        }
        if (!r.equals(this.lastReplacementInUTF8())) {
            this.lastReplacementInUTF8_$eq(((UTF8String)r).clone());
            this.lastReplacement_$eq(this.lastReplacementInUTF8().toString());
        }
        String source = s.toString();
        int position = BoxesRunTime.unboxToInt((Object)i) - 1;
        if (position == 0 || position < source.length()) {
            Matcher m = this.pattern().matcher(source);
            m.region(position, source.length());
            this.result().delete(0, this.result().length());
            while (m.find()) {
                try {
                    m.appendReplacement(this.result(), this.lastReplacement());
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable throwable3 = throwable;
                    if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                        throw QueryExecutionErrors$.MODULE$.invalidRegexpReplaceError(s.toString(), p.toString(), r.toString(), BoxesRunTime.unboxToInt((Object)i), throwable2);
                    }
                    throw throwable;
                }
            }
            m.appendTail(this.result());
            return UTF8String.fromString((String)this.result().toString());
        }
        return s;
    }

    @Override
    public DataType dataType() {
        return this.subject().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeBinaryLcase$.MODULE$, (List)new .colon.colon((Object)StringTypeWithCollation$.MODULE$, (List)new .colon.colon((Object)StringTypeBinaryLcase$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$))));
    }

    private int collationId$lzycompute() {
        RegExpReplace regExpReplace = this;
        synchronized (regExpReplace) {
            if (!this.bitmap$0) {
                this.collationId = ((StringType)this.subject().dataType()).collationId();
                this.bitmap$0 = true;
            }
        }
        return this.collationId;
    }

    public final int collationId() {
        if (!this.bitmap$0) {
            return this.collationId$lzycompute();
        }
        return this.collationId;
    }

    @Override
    public String prettyName() {
        return "regexp_replace";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String termResult = ctx.freshName("termResult");
        String classNameStringBuilder = StringBuilder.class.getCanonicalName();
        String matcher = ctx.freshName("matcher");
        String source = ctx.freshName("source");
        String position = ctx.freshName("position");
        String termLastReplacement = ctx.addMutableState("String", "lastReplacement", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String termLastReplacementInUTF8 = ctx.addMutableState("UTF8String", "lastReplacementInUTF8", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String setEvNotNull = this.nullable() ? ev.isNull() + " = false;" : "";
        return this.nullSafeCodeGen(ctx, ev, (Function4<String, String, String, String, String>)(Function4 & Serializable)(subject, regexp, rep, pos) -> "\n      " + RegExpUtils$.MODULE$.initLastMatcherCode(ctx, (String)subject, (String)regexp, matcher, this.prettyName(), this.collationId()) + "\n      if (!" + rep + ".equals(" + termLastReplacementInUTF8 + ")) {\n        // replacement string changed\n        " + termLastReplacementInUTF8 + " = " + rep + ".clone();\n        " + termLastReplacement + " = " + termLastReplacementInUTF8 + ".toString();\n      }\n      String " + source + " = " + subject + ".toString();\n      int " + position + " = " + pos + " - 1;\n      if (" + position + " == 0 || " + position + " < " + source + ".length()) {\n        " + classNameStringBuilder + " " + termResult + " = new " + classNameStringBuilder + "();\n        " + matcher + ".region(" + position + ", " + source + ".length());\n\n        while (" + matcher + ".find()) {\n          try {\n            " + matcher + ".appendReplacement(" + termResult + ", " + termLastReplacement + ");\n          } catch (Throwable e) {\n            if (scala.util.control.NonFatal.apply(e)) {\n              throw QueryExecutionErrors.invalidRegexpReplaceError(" + source + ", " + regexp + ".toString(),\n                " + rep + ".toString(), " + pos + ", e);\n            } else {\n              throw e;\n            }\n          }\n        }\n        " + matcher + ".appendTail(" + termResult + ");\n        " + ev.value() + " = UTF8String.fromString(" + termResult + ".toString());\n        " + termResult + " = null;\n      } else {\n        " + ev.value() + " = " + subject + ";\n      }\n      " + setEvNotNull + "\n    ");
    }

    @Override
    public Expression first() {
        return this.subject();
    }

    @Override
    public Expression second() {
        return this.regexp();
    }

    @Override
    public Expression third() {
        return this.rep();
    }

    @Override
    public Expression fourth() {
        return this.pos();
    }

    @Override
    public RegExpReplace withNewChildrenInternal(Expression first, Expression second, Expression third, Expression fourth) {
        return this.copy(first, second, third, fourth);
    }

    public RegExpReplace copy(Expression subject, Expression regexp, Expression rep, Expression pos) {
        return new RegExpReplace(subject, regexp, rep, pos);
    }

    public Expression copy$default$1() {
        return this.subject();
    }

    public Expression copy$default$2() {
        return this.regexp();
    }

    public Expression copy$default$3() {
        return this.rep();
    }

    public Expression copy$default$4() {
        return this.pos();
    }

    @Override
    public String productPrefix() {
        return "RegExpReplace";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.subject();
            }
            case 1: {
                return this.regexp();
            }
            case 2: {
                return this.rep();
            }
            case 3: {
                return this.pos();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RegExpReplace;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "subject";
            }
            case 1: {
                return "regexp";
            }
            case 2: {
                return "rep";
            }
            case 3: {
                return "pos";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RegExpReplace)) return false;
        boolean bl = true;
        if (!bl) return false;
        RegExpReplace regExpReplace = (RegExpReplace)x$1;
        Expression expression = this.subject();
        Expression expression2 = regExpReplace.subject();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.regexp();
        Expression expression4 = regExpReplace.regexp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.rep();
        Expression expression6 = regExpReplace.rep();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.pos();
        Expression expression8 = regExpReplace.pos();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        if (!regExpReplace.canEqual(this)) return false;
        return true;
    }

    public RegExpReplace(Expression subject, Expression regexp, Expression rep, Expression pos) {
        this.subject = subject;
        this.regexp = regexp;
        this.rep = rep;
        this.pos = pos;
        ExpectsInputTypes.$init$(this);
        this.nodePatterns = new .colon.colon((Object)TreePattern$.MODULE$.REGEXP_REPLACE(), (List)Nil$.MODULE$);
    }

    public RegExpReplace(Expression subject, Expression regexp, Expression rep) {
        this(subject, regexp, rep, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1)));
    }
}

