/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.hive.ql.exec.tez.KeyValuesAdapter;
import org.apache.tez.runtime.library.api.KeyValueReader;

public class KeyValuesFromKeyValue
implements KeyValuesAdapter {
    protected KeyValueReader reader;
    protected ValueIterator<Object> valueIterator = new ValueIterator();

    public KeyValuesFromKeyValue(KeyValueReader reader) {
        this.reader = reader;
    }

    @Override
    public Object getCurrentKey() throws IOException {
        return this.reader.getCurrentKey();
    }

    @Override
    public Iterable<Object> getCurrentValues() throws IOException {
        Object obj = this.reader.getCurrentValue();
        this.valueIterator.reset(obj);
        return this.valueIterator;
    }

    @Override
    public boolean next() throws IOException {
        return this.reader.next();
    }

    private static class ValueIterator<T>
    implements Iterator<T>,
    Iterable<T> {
        protected boolean hasNextValue = false;
        protected T value = null;

        private ValueIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.hasNextValue;
        }

        @Override
        public T next() {
            if (!this.hasNextValue) {
                throw new NoSuchElementException();
            }
            this.hasNextValue = false;
            return this.value;
        }

        void reset(T value) {
            this.value = value;
            this.hasNextValue = true;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }
    }
}

