/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.util;

import java.io.Serializable;
import java.util.Random;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.DenseMatrix$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.ArrayImplicits$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction2;

public final class MFDataGenerator$ {
    public static final MFDataGenerator$ MODULE$ = new MFDataGenerator$();

    public void main(String[] args) {
        if (args.length < 2) {
            Predef$.MODULE$.println((Object)"Usage: MFDataGenerator <master> <outputDir> [m] [n] [rank] [trainSampFact] [noise] [sigma] [test] [testSampFact]");
            System.exit(1);
        }
        String sparkMaster = args[0];
        String outputPath = args[1];
        int m = args.length > 2 ? StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(args[2])) : 100;
        int n = args.length > 3 ? StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(args[3])) : 100;
        int rank = args.length > 4 ? StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(args[4])) : 10;
        double trainSampFact = args.length > 5 ? StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(args[5])) : 1.0;
        boolean noise = args.length > 6 ? StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(args[6])) : false;
        double sigma = args.length > 7 ? StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(args[7])) : 0.1;
        boolean test = args.length > 8 ? StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(args[8])) : false;
        double testSampFact = args.length > 9 ? StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(args[9])) : 0.1;
        SparkContext sc = new SparkContext(sparkMaster, "MFDataGenerator");
        Random random = new Random(42L);
        DenseMatrix A = DenseMatrix$.MODULE$.randn(m, rank, random);
        DenseMatrix B = DenseMatrix$.MODULE$.randn(rank, n, random);
        double z = 1.0 / package$.MODULE$.sqrt((double)rank);
        DenseMatrix fullData = DenseMatrix$.MODULE$.zeros(m, n);
        BLAS$.MODULE$.gemm(z, (Matrix)A, B, 1.0, fullData);
        int df = rank * (m + n - rank);
        int sampSize = (int)package$.MODULE$.min(package$.MODULE$.round(trainSampFact * (double)df), package$.MODULE$.round(0.99 * (double)m * (double)n));
        scala.util.Random rand = new scala.util.Random();
        int mn = m * n;
        List shuffled = (List)rand.shuffle((IterableOnce)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), mn).toList(), BuildFrom$.MODULE$.buildFromIterableOps());
        List omega = shuffled.slice(0, sampSize);
        int[] ordered = (int[])((IterableOnceOps)omega.sortWith((Function2)(JFunction2.mcZII.sp & Serializable)(x$1, x$2) -> x$1 < x$2)).toArray((ClassTag)ClassTag$.MODULE$.Int());
        RDD trainData = sc.parallelize((Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)ordered).toImmutableArraySeq(), sc.parallelize$default$2(), (ClassTag)ClassTag$.MODULE$.Int()).map((Function1 & Serializable)x -> MFDataGenerator$.$anonfun$main$2(m, fullData, BoxesRunTime.unboxToInt((Object)x)), ClassTag$.MODULE$.apply(Tuple3.class));
        Object object = noise ? trainData.map((Function1 & Serializable)x -> new Tuple3(x._1(), x._2(), (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)x._3()) + rand.nextGaussian() * sigma))), ClassTag$.MODULE$.apply(Tuple3.class)) : BoxedUnit.UNIT;
        trainData.map((Function1 & Serializable)x -> x._1() + "," + x._2() + "," + x._3(), ClassTag$.MODULE$.apply(String.class)).saveAsTextFile(outputPath);
        if (test) {
            int testSampSize = package$.MODULE$.min((int)package$.MODULE$.round((double)sampSize * testSampFact), mn - sampSize);
            List testOmega = shuffled.slice(sampSize, sampSize + testSampSize);
            int[] testOrdered = (int[])((IterableOnceOps)testOmega.sortWith((Function2)(JFunction2.mcZII.sp & Serializable)(x$3, x$4) -> x$3 < x$4)).toArray((ClassTag)ClassTag$.MODULE$.Int());
            RDD testData = sc.parallelize((Seq)ArrayImplicits$.MODULE$.SparkArrayOps((Object)testOrdered).toImmutableArraySeq(), sc.parallelize$default$2(), (ClassTag)ClassTag$.MODULE$.Int()).map((Function1 & Serializable)x -> MFDataGenerator$.$anonfun$main$6(m, fullData, BoxesRunTime.unboxToInt((Object)x)), ClassTag$.MODULE$.apply(Tuple3.class));
            testData.map((Function1 & Serializable)x -> x._1() + "," + x._2() + "," + x._3(), ClassTag$.MODULE$.apply(String.class)).saveAsTextFile(outputPath);
        }
        sc.stop();
    }

    public static final /* synthetic */ Tuple3 $anonfun$main$2(int m$1, DenseMatrix fullData$1, int x) {
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)(x % m$1)), (Object)BoxesRunTime.boxToInteger((int)(x / m$1)), (Object)BoxesRunTime.boxToDouble((double)fullData$1.values()[x]));
    }

    public static final /* synthetic */ Tuple3 $anonfun$main$6(int m$1, DenseMatrix fullData$1, int x) {
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)(x % m$1)), (Object)BoxesRunTime.boxToInteger((int)(x / m$1)), (Object)BoxesRunTime.boxToDouble((double)fullData$1.values()[x]));
    }

    private MFDataGenerator$() {
    }
}

