/*
 * Decompiled with CFR 0.152.
 */
package coursierapi;

import coursierapi.Artifact;
import coursierapi.Cache;
import coursierapi.shaded.coursier.internal.api.ApiHelper;
import java.io.File;

public final class ArchiveCache {
    private File location = ApiHelper.defaultArchiveCacheLocation();
    private Cache cache = Cache.create();

    private ArchiveCache() {
    }

    public static ArchiveCache create() {
        return new ArchiveCache();
    }

    public File get(Artifact artifact) {
        return ApiHelper.archiveCacheGet(this, artifact);
    }

    public File getIfExists(Artifact artifact) {
        return ApiHelper.archiveCacheGetIfExists(this, artifact);
    }

    public boolean equals(Object object) {
        if (object instanceof ArchiveCache) {
            ArchiveCache archiveCache = (ArchiveCache)object;
            return this.location.equals(archiveCache.location) && this.cache.equals(archiveCache.cache);
        }
        return false;
    }

    public int hashCode() {
        return 37 * (17 + this.location.hashCode()) + this.cache.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("ArchiveCache(location=");
        stringBuilder.append(this.location.toString());
        stringBuilder.append(", cache=");
        stringBuilder.append(this.cache.toString());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public ArchiveCache withLocation(File file) {
        this.location = file;
        return this;
    }

    public ArchiveCache withCache(Cache cache) {
        this.cache = cache;
        return this;
    }

    public File getLocation() {
        return this.location;
    }

    public Cache getCache() {
        return this.cache;
    }
}

