/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.Calendar;
import java.util.Date;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.NDV;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.io.Text;
import org.apache.hive.common.util.DateUtils;

@Description(name="add_months", value="_FUNC_(start_date, num_months) - Returns the date that is num_months after start_date.", extended="start_date is a string in the format 'yyyy-MM-dd HH:mm:ss' or 'yyyy-MM-dd'. num_months is a number. The time part of start_date is ignored.\nExample:\n  > SELECT _FUNC_('2009-08-31', 1) FROM src LIMIT 1;\n '2009-09-30'")
@NDV(maxNdv=250L)
public class GenericUDFAddMonths
extends GenericUDF {
    private transient ObjectInspectorConverters.Converter[] converters = new ObjectInspectorConverters.Converter[2];
    private transient PrimitiveObjectInspector.PrimitiveCategory[] inputTypes = new PrimitiveObjectInspector.PrimitiveCategory[2];
    private final Calendar calendar = Calendar.getInstance();
    private final Text output = new Text();
    private transient Integer numMonthsConst;
    private transient boolean isNumMonthsConst;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        this.checkArgsSize(arguments, 2, 2);
        this.checkArgPrimitive(arguments, 0);
        this.checkArgPrimitive(arguments, 1);
        this.checkArgGroups(arguments, 0, this.inputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP, PrimitiveObjectInspectorUtils.PrimitiveGrouping.DATE_GROUP, PrimitiveObjectInspectorUtils.PrimitiveGrouping.VOID_GROUP);
        this.checkArgGroups(arguments, 1, this.inputTypes, PrimitiveObjectInspectorUtils.PrimitiveGrouping.NUMERIC_GROUP, PrimitiveObjectInspectorUtils.PrimitiveGrouping.VOID_GROUP);
        this.obtainDateConverter(arguments, 0, this.inputTypes, this.converters);
        this.obtainIntConverter(arguments, 1, this.inputTypes, this.converters);
        if (arguments[1] instanceof ConstantObjectInspector) {
            this.numMonthsConst = this.getConstantIntValue(arguments, 1);
            this.isNumMonthsConst = true;
        }
        WritableStringObjectInspector outputOI = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        return outputOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Integer numMonthV = this.isNumMonthsConst ? this.numMonthsConst : this.getIntValue(arguments, 1, this.converters);
        if (numMonthV == null) {
            return null;
        }
        int numMonthInt = numMonthV;
        Date date = this.getDateValue(arguments, 0, this.inputTypes, this.converters);
        if (date == null) {
            return null;
        }
        this.addMonth(date, numMonthInt);
        Date newDate = this.calendar.getTime();
        this.output.set(DateUtils.getDateFormat().format(newDate));
        return this.output;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString(this.getFuncName(), children);
    }

    @Override
    protected String getFuncName() {
        return "add_months";
    }

    protected Calendar addMonth(Date d, int numMonths) {
        this.calendar.setTime(d);
        boolean lastDatOfMonth = this.isLastDayOfMonth(this.calendar);
        this.calendar.add(2, numMonths);
        if (lastDatOfMonth) {
            int maxDd = this.calendar.getActualMaximum(5);
            this.calendar.set(5, maxDd);
        }
        return this.calendar;
    }

    protected boolean isLastDayOfMonth(Calendar cal) {
        int maxDd = cal.getActualMaximum(5);
        int dd = cal.get(5);
        return dd == maxDd;
    }
}

