/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hive.beeline.DatabaseConnection;

class DatabaseConnections {
    private final List<DatabaseConnection> connections = new ArrayList<DatabaseConnection>();
    private int index = -1;

    DatabaseConnections() {
    }

    public DatabaseConnection current() {
        if (this.index != -1) {
            return this.connections.get(this.index);
        }
        return null;
    }

    public int size() {
        return this.connections.size();
    }

    public Iterator<DatabaseConnection> iterator() {
        return this.connections.iterator();
    }

    public void remove() {
        if (this.index != -1) {
            this.connections.remove(this.index);
        }
        while (this.index >= this.connections.size()) {
            --this.index;
        }
    }

    public void setConnection(DatabaseConnection connection) {
        if (this.connections.indexOf(connection) == -1) {
            this.connections.add(connection);
        }
        this.index = this.connections.indexOf(connection);
    }

    public int getIndex() {
        return this.index;
    }

    public boolean setIndex(int index) {
        if (index < 0 || index >= this.connections.size()) {
            return false;
        }
        this.index = index;
        return true;
    }
}

