/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jpmml.model.filters;

import org.sparkproject.dmg.pmml.Version;
import org.sparkproject.dmg.pmml.VersionUtil;
import org.sparkproject.jpmml.model.filters.PMMLFilter;
import org.xml.sax.Attributes;
import org.xml.sax.XMLReader;

public class ExportFilter
extends PMMLFilter {
    public ExportFilter(Version target) {
        super(target);
    }

    public ExportFilter(XMLReader reader, Version target) {
        super(reader, target);
    }

    @Override
    public String filterLocalName(String localName) {
        Version target = this.getTarget();
        if ("Trend_ExpoSmooth".equals(localName) && target.compareTo(Version.PMML_4_0) == 0) {
            return "Trend";
        }
        return localName;
    }

    @Override
    public Attributes filterAttributes(String localName, Attributes attributes) {
        Version target = this.getTarget();
        if ("Apply".equals(localName)) {
            String function;
            Version functionVersion;
            if (target.compareTo(Version.PMML_4_1) == 0 && ExportFilter.hasAttribute(attributes, "defaultValue")) {
                if (ExportFilter.hasAttribute(attributes, "mapMissingTo")) {
                    throw new IllegalStateException();
                }
                attributes = ExportFilter.renameAttribute(attributes, "defaultValue", "mapMissingTo");
            }
            if (target.compareTo(Version.PMML_4_4) < 0 && (functionVersion = VersionUtil.getVersion(function = ExportFilter.getAttribute(attributes, "function"))) != null && functionVersion.compareTo(target) > 0) {
                attributes = ExportFilter.setAttribute(attributes, "function", "x-" + function);
            }
        } else if ("MiningField".equals(localName)) {
            if (target.compareTo(Version.PMML_4_3) <= 0) {
                String missingValueTreatment = ExportFilter.getAttribute(attributes, "missingValueTreatment");
                String invalidValueTreatment = ExportFilter.getAttribute(attributes, "invalidValueTreatment");
                attributes = ExportFilter.renameAttribute(attributes, "invalidValueReplacement", "x-invalidValueReplacement");
                if (missingValueTreatment != null) {
                    switch (missingValueTreatment) {
                        case "returnInvalid": {
                            attributes = ExportFilter.setAttribute(attributes, "missingValueTreatment", "x-" + missingValueTreatment);
                            break;
                        }
                    }
                }
                if (invalidValueTreatment != null) {
                    switch (invalidValueTreatment) {
                        case "asValue": {
                            attributes = ExportFilter.setAttribute(attributes, "invalidValueTreatment", "asIs");
                            break;
                        }
                    }
                }
            }
        } else if ("PMML".equals(localName)) {
            if (ExportFilter.hasAttribute(attributes, "x-baseVersion")) {
                attributes = ExportFilter.removeAttribute(attributes, "x-baseVersion");
            }
            attributes = ExportFilter.setAttribute(attributes, "version", target.getVersion());
        } else if ("Segmentation".equals(localName)) {
            if (target.compareTo(Version.PMML_4_3) <= 0) {
                String multipleModelMethod = ExportFilter.getAttribute(attributes, "multipleModelMethod");
                attributes = ExportFilter.renameAttribute(attributes, "missingPredictionTreatment", "x-missingPredictionTreatment");
                attributes = ExportFilter.renameAttribute(attributes, "missingThreshold", "x-missingThreshold");
                if (multipleModelMethod != null) {
                    switch (multipleModelMethod) {
                        case "weightedMedian": 
                        case "weightedSum": {
                            attributes = ExportFilter.setAttribute(attributes, "multipleModelMethod", "x-" + multipleModelMethod);
                            break;
                        }
                    }
                }
            }
        } else if ("TargetValue".equals(localName) && target.compareTo(Version.PMML_3_1) <= 0 && ExportFilter.hasAttribute(attributes, "displayValue")) {
            if (ExportFilter.hasAttribute(attributes, "rawDataValue")) {
                throw new IllegalStateException();
            }
            attributes = ExportFilter.renameAttribute(attributes, "displayValue", "rawDataValue");
        }
        return attributes;
    }
}

