/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.exchange;

import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.apache.spark.ConstantPartitioner;
import org.apache.spark.HashPartitioner;
import org.apache.spark.KeyGroupedPartitioner;
import org.apache.spark.PartitionIdPassthrough;
import org.apache.spark.Partitioner;
import org.apache.spark.RangePartitioner;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.ShuffleDependency$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException$;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.shuffle.ShuffleManager;
import org.apache.spark.shuffle.ShuffleWriteMetricsReporter;
import org.apache.spark.shuffle.ShuffleWriteProcessor;
import org.apache.spark.shuffle.checksum.RowBasedChecksum;
import org.apache.spark.shuffle.sort.SortShuffleManager;
import org.apache.spark.shuffle.sort.SortShuffleManager$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.BindReferences$;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRowChecksum$;
import org.apache.spark.sql.catalyst.expressions.codegen.LazilyGeneratedOrdering;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.catalyst.plans.physical.HashPartitioning;
import org.apache.spark.sql.catalyst.plans.physical.KeyGroupedPartitioning;
import org.apache.spark.sql.catalyst.plans.physical.Partitioning;
import org.apache.spark.sql.catalyst.plans.physical.RangePartitioning;
import org.apache.spark.sql.catalyst.plans.physical.RoundRobinPartitioning;
import org.apache.spark.sql.catalyst.plans.physical.ShufflePartitionIdPassThrough;
import org.apache.spark.sql.catalyst.plans.physical.SinglePartition$;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.execution.RecordBinaryComparator;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.UnsafeExternalRowSorter;
import org.apache.spark.sql.execution.exchange.ENSURE_REQUIREMENTS$;
import org.apache.spark.sql.execution.exchange.ShuffleExchangeExec;
import org.apache.spark.sql.execution.exchange.ShuffleOrigin;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.metric.SQLShuffleWriteMetricsReporter;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.util.MutablePair;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.collection.unsafe.sort.PrefixComparator;
import org.apache.spark.util.collection.unsafe.sort.PrefixComparators;
import org.apache.spark.util.collection.unsafe.sort.RecordComparator;
import org.apache.spark.util.random.XORShiftRandom;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product2;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;

public final class ShuffleExchangeExec$
implements Serializable {
    public static final ShuffleExchangeExec$ MODULE$ = new ShuffleExchangeExec$();
    private static final ExecutionContextExecutorService executionContext = ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)ThreadUtils$.MODULE$.newDaemonCachedThreadPool("shuffle-exchange", BoxesRunTime.unboxToInt((Object)SQLConf$.MODULE$.get().getConf(StaticSQLConf$.MODULE$.SHUFFLE_EXCHANGE_MAX_THREAD_THRESHOLD())), ThreadUtils$.MODULE$.newDaemonCachedThreadPool$default$3()));

    public ShuffleOrigin $lessinit$greater$default$3() {
        return ENSURE_REQUIREMENTS$.MODULE$;
    }

    public Option<Object> $lessinit$greater$default$4() {
        return None$.MODULE$;
    }

    public ExecutionContextExecutorService executionContext() {
        return executionContext;
    }

    private boolean needToCopyObjectsBeforeShuffle(Partitioner partitioner) {
        SparkConf conf = SparkEnv$.MODULE$.get().conf();
        ShuffleManager shuffleManager = SparkEnv$.MODULE$.get().shuffleManager();
        boolean sortBasedShuffleOn = shuffleManager instanceof SortShuffleManager;
        int bypassMergeThreshold = BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.SHUFFLE_SORT_BYPASS_MERGE_THRESHOLD()));
        int numParts = partitioner.numPartitions();
        if (sortBasedShuffleOn) {
            if (numParts <= bypassMergeThreshold) {
                return false;
            }
            return numParts > SortShuffleManager$.MODULE$.MAX_SHUFFLE_OUTPUT_PARTITIONS_FOR_SERIALIZED_MODE();
        }
        return true;
    }

    public ShuffleDependency<Object, InternalRow, InternalRow> prepareShuffleDependency(RDD<InternalRow> rdd, Seq<Attribute> outputAttributes, Partitioning newPartitioning, Serializer serializer, Map<String, SQLMetric> writeMetrics) {
        RDD rDD;
        boolean isOrderSensitive;
        HashPartitioner hashPartitioner;
        Partitioning partitioning2 = newPartitioning;
        if (partitioning2 instanceof RoundRobinPartitioning) {
            RoundRobinPartitioning roundRobinPartitioning = (RoundRobinPartitioning)partitioning2;
            int numPartitions = roundRobinPartitioning.numPartitions();
            hashPartitioner = new HashPartitioner(numPartitions);
        } else if (partitioning2 instanceof HashPartitioning) {
            HashPartitioning hashPartitioning = (HashPartitioning)partitioning2;
            int n = hashPartitioning.numPartitions();
            hashPartitioner = new PartitionIdPassthrough(n);
        } else if (partitioning2 instanceof ShufflePartitionIdPassThrough) {
            ShufflePartitionIdPassThrough shufflePartitionIdPassThrough = (ShufflePartitionIdPassThrough)partitioning2;
            int n = shufflePartitionIdPassThrough.numPartitions();
            hashPartitioner = new PartitionIdPassthrough(n);
        } else if (partitioning2 instanceof RangePartitioning) {
            RangePartitioning rangePartitioning = (RangePartitioning)partitioning2;
            Seq sortingExpressions = rangePartitioning.ordering();
            int numPartitions = rangePartitioning.numPartitions();
            RDD rddForSampling = rdd.mapPartitionsInternal((Function1 & Serializable)iter -> {
                UnsafeProjection projection = UnsafeProjection$.MODULE$.create((Seq)sortingExpressions.map((Function1 & Serializable)x$2 -> x$2.child()), outputAttributes);
                MutablePair mutablePair = new MutablePair();
                return iter.map((Function1 & Serializable)row -> mutablePair.update((Object)projection.apply(row).copy(), null));
            }, rdd.mapPartitionsInternal$default$2(), ClassTag$.MODULE$.apply(MutablePair.class));
            Seq orderingAttributes = (Seq)((IterableOps)sortingExpressions.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    SortOrder ord = (SortOrder)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    return ord.copy((Expression)new BoundReference(i, ord.dataType(), ord.nullable()), ord.copy$default$2(), ord.copy$default$3(), ord.copy$default$4());
                }
                throw new MatchError((Object)tuple2);
            });
            LazilyGeneratedOrdering ordering2 = new LazilyGeneratedOrdering(orderingAttributes);
            hashPartitioner = new RangePartitioner(numPartitions, rddForSampling, true, SQLConf$.MODULE$.get().rangeExchangeSampleSizePerPartition(), (Ordering)ordering2, ClassTag$.MODULE$.apply(InternalRow.class));
        } else if (SinglePartition$.MODULE$.equals(partitioning2)) {
            hashPartitioner = new ConstantPartitioner();
        } else if (partitioning2 instanceof KeyGroupedPartitioning) {
            KeyGroupedPartitioning keyGroupedPartitioning = (KeyGroupedPartitioning)partitioning2;
            Seq expressions = keyGroupedPartitioning.expressions();
            int n = keyGroupedPartitioning.numPartitions();
            Map valueMap = ((IterableOnceOps)((IterableOps)keyGroupedPartitioning.uniquePartitionValues().zipWithIndex()).map((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    InternalRow partition = (InternalRow)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    return new Tuple2((Object)partition.toSeq((Seq)expressions.map((Function1 & Serializable)x$3 -> x$3.dataType())), (Object)BoxesRunTime.boxToInteger((int)index));
                }
                throw new MatchError((Object)tuple2);
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            hashPartitioner = new KeyGroupedPartitioner((scala.collection.mutable.Map)Map$.MODULE$.apply(valueMap.toSeq()), n);
        } else {
            throw SparkException$.MODULE$.internalError("Exchange not implemented for " + newPartitioning);
        }
        HashPartitioner part = hashPartitioner;
        boolean isRoundRobin = newPartitioning instanceof RoundRobinPartitioning && newPartitioning.numPartitions() > 1;
        RDD newRdd = isRoundRobin && SQLConf$.MODULE$.get().sortBeforeRepartition() ? rdd.mapPartitionsInternal((Function1 & Serializable)iter -> {
            Supplier<RecordComparator> recordComparatorSupplier = new Supplier<RecordComparator>(){

                public RecordComparator get() {
                    return new RecordBinaryComparator();
                }
            };
            PrefixComparator prefixComparator = PrefixComparators.LONG;
            UnsafeExternalRowSorter.PrefixComputer prefixComputer = new UnsafeExternalRowSorter.PrefixComputer(){
                private final UnsafeExternalRowSorter.PrefixComputer.Prefix result;

                private UnsafeExternalRowSorter.PrefixComputer.Prefix result() {
                    return this.result;
                }

                public UnsafeExternalRowSorter.PrefixComputer.Prefix computePrefix(InternalRow row) {
                    this.result().isNull = false;
                    this.result().value = row.hashCode();
                    return this.result();
                }
                {
                    this.result = new UnsafeExternalRowSorter.PrefixComputer.Prefix();
                }
            };
            long pageSize = SparkEnv$.MODULE$.get().memoryManager().pageSizeBytes();
            UnsafeExternalRowSorter sorter = UnsafeExternalRowSorter.createWithRecordComparator(DataTypeUtils$.MODULE$.fromAttributes(outputAttributes), recordComparatorSupplier, prefixComparator, prefixComputer, pageSize, false);
            return sorter.sort((Iterator<UnsafeRow>)iter);
        }, rdd.mapPartitionsInternal$default$2(), ClassTag$.MODULE$.apply(InternalRow.class)) : rdd;
        boolean bl = isOrderSensitive = isRoundRobin && !SQLConf$.MODULE$.get().sortBeforeRepartition();
        if (this.needToCopyObjectsBeforeShuffle((Partitioner)part)) {
            Function2 & Serializable x$1 = (arg_0, arg_1) -> ShuffleExchangeExec$.$anonfun$prepareShuffleDependency$16$adapted((Partitioner)part, newPartitioning, outputAttributes, arg_0, arg_1);
            boolean x$2 = isOrderSensitive;
            boolean x$3 = newRdd.mapPartitionsWithIndexInternal$default$2();
            rDD = newRdd.mapPartitionsWithIndexInternal((Function2)x$1, x$3, x$2, ClassTag$.MODULE$.apply(Product2.class));
        } else {
            Function2 & Serializable x$4 = (arg_0, arg_1) -> ShuffleExchangeExec$.$anonfun$prepareShuffleDependency$18$adapted((Partitioner)part, newPartitioning, outputAttributes, arg_0, arg_1);
            boolean x$5 = isOrderSensitive;
            boolean x$6 = newRdd.mapPartitionsWithIndexInternal$default$2();
            rDD = newRdd.mapPartitionsWithIndexInternal((Function2)x$4, x$6, x$5, ClassTag$.MODULE$.apply(Product2.class));
        }
        RDD rddWithPartitionIds = rDD;
        int checksumSize = SQLConf$.MODULE$.get().shuffleOrderIndependentChecksumEnabled() || SQLConf$.MODULE$.get().shuffleChecksumMismatchFullRetryEnabled() ? part.numPartitions() : 0;
        RDD x$7 = rddWithPartitionIds;
        PartitionIdPassthrough x$8 = new PartitionIdPassthrough(part.numPartitions());
        Serializer x$9 = serializer;
        ShuffleWriteProcessor x$10 = this.createShuffleWriteProcessor(writeMetrics);
        RowBasedChecksum[] x$11 = UnsafeRowChecksum$.MODULE$.createUnsafeRowChecksums(checksumSize);
        boolean x$12 = SQLConf$.MODULE$.get().shuffleChecksumMismatchFullRetryEnabled();
        None$ x$13 = ShuffleDependency$.MODULE$.$lessinit$greater$default$4();
        None$ x$14 = ShuffleDependency$.MODULE$.$lessinit$greater$default$5();
        boolean x$15 = ShuffleDependency$.MODULE$.$lessinit$greater$default$6();
        ShuffleDependency dependency = new ShuffleDependency(x$7, (Partitioner)x$8, x$9, (Option)x$13, (Option)x$14, x$15, x$10, x$11, x$12, (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(InternalRow.class), ClassTag$.MODULE$.apply(InternalRow.class));
        return dependency;
    }

    public ShuffleWriteProcessor createShuffleWriteProcessor(Map<String, SQLMetric> metrics) {
        return new ShuffleWriteProcessor(metrics){
            private final Map metrics$1;

            public ShuffleWriteMetricsReporter createMetricsReporter(TaskContext context) {
                return new SQLShuffleWriteMetricsReporter((ShuffleWriteMetricsReporter)context.taskMetrics().shuffleWriteMetrics(), (Map<String, SQLMetric>)this.metrics$1);
            }
            {
                this.metrics$1 = metrics$1;
            }
        };
    }

    public ShuffleExchangeExec apply(Partitioning outputPartitioning2, SparkPlan child, ShuffleOrigin shuffleOrigin, Option<Object> advisoryPartitionSize) {
        return new ShuffleExchangeExec(outputPartitioning2, child, shuffleOrigin, advisoryPartitionSize);
    }

    public ShuffleOrigin apply$default$3() {
        return ENSURE_REQUIREMENTS$.MODULE$;
    }

    public Option<Object> apply$default$4() {
        return None$.MODULE$;
    }

    public Option<Tuple4<Partitioning, SparkPlan, ShuffleOrigin, Option<Object>>> unapply(ShuffleExchangeExec x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4((Object)x$0.outputPartitioning(), (Object)x$0.child(), (Object)x$0.shuffleOrigin(), x$0.advisoryPartitionSize()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ShuffleExchangeExec$.class);
    }

    public static final /* synthetic */ int $anonfun$prepareShuffleDependency$7(IntRef position$1, InternalRow row) {
        ++position$1.elem;
        return position$1.elem;
    }

    public static final /* synthetic */ int $anonfun$prepareShuffleDependency$8(UnsafeProjection projection$2, InternalRow row) {
        return projection$2.apply(row).getInt(0);
    }

    public static final /* synthetic */ int $anonfun$prepareShuffleDependency$14(UnsafeProjection projection$4, InternalRow row) {
        return projection$4.apply(row).getInt(0);
    }

    private static final Function1 getPartitionKeyExtractor$1(Partitioning newPartitioning$1, Seq outputAttributes$1) {
        Partitioning partitioning2 = newPartitioning$1;
        if (partitioning2 instanceof RoundRobinPartitioning) {
            RoundRobinPartitioning roundRobinPartitioning = (RoundRobinPartitioning)partitioning2;
            int numPartitions = roundRobinPartitioning.numPartitions();
            int partitionId = TaskContext$.MODULE$.get().partitionId();
            IntRef position = IntRef.create((int)new XORShiftRandom((long)partitionId).nextInt(numPartitions));
            return (Function1 & Serializable)row -> BoxesRunTime.boxToInteger((int)ShuffleExchangeExec$.$anonfun$prepareShuffleDependency$7(position, row));
        }
        if (partitioning2 instanceof HashPartitioning) {
            HashPartitioning hashPartitioning = (HashPartitioning)partitioning2;
            Expression expression = hashPartitioning.partitionIdExpression();
            UnsafeProjection projection = UnsafeProjection$.MODULE$.create((Seq)Nil$.MODULE$.$colon$colon((Object)expression), outputAttributes$1);
            return (Function1 & Serializable)row -> BoxesRunTime.boxToInteger((int)ShuffleExchangeExec$.$anonfun$prepareShuffleDependency$8(projection, row));
        }
        if (partitioning2 instanceof RangePartitioning) {
            RangePartitioning rangePartitioning = (RangePartitioning)partitioning2;
            Seq sortingExpressions = rangePartitioning.ordering();
            UnsafeProjection projection = UnsafeProjection$.MODULE$.create((Seq)sortingExpressions.map((Function1 & Serializable)x$4 -> x$4.child()), outputAttributes$1);
            return (Function1 & Serializable)row -> projection.apply(row);
        }
        if (SinglePartition$.MODULE$.equals(partitioning2)) {
            return (Function1 & Serializable)x -> (InternalRow)Predef$.MODULE$.identity(x);
        }
        if (partitioning2 instanceof KeyGroupedPartitioning) {
            KeyGroupedPartitioning keyGroupedPartitioning = (KeyGroupedPartitioning)partitioning2;
            Seq expressions = keyGroupedPartitioning.expressions();
            return (Function1 & Serializable)row -> (Seq)BindReferences$.MODULE$.bindReferences(expressions, package$.MODULE$.AttributeSeq(outputAttributes$1)).map((Function1 & Serializable)x$5 -> x$5.eval(row));
        }
        if (partitioning2 instanceof ShufflePartitionIdPassThrough) {
            ShufflePartitionIdPassThrough shufflePartitionIdPassThrough = (ShufflePartitionIdPassThrough)partitioning2;
            Expression expression = shufflePartitionIdPassThrough.partitionIdExpression();
            UnsafeProjection projection = UnsafeProjection$.MODULE$.create((Seq)Nil$.MODULE$.$colon$colon((Object)expression), outputAttributes$1);
            return (Function1 & Serializable)row -> BoxesRunTime.boxToInteger((int)ShuffleExchangeExec$.$anonfun$prepareShuffleDependency$14(projection, row));
        }
        throw SparkException$.MODULE$.internalError("Exchange not implemented for " + newPartitioning$1);
    }

    public static final /* synthetic */ Iterator $anonfun$prepareShuffleDependency$16(Partitioner part$1, Partitioning newPartitioning$1, Seq outputAttributes$1, int x$6, Iterator iter) {
        Function1 getPartitionKey = ShuffleExchangeExec$.getPartitionKeyExtractor$1(newPartitioning$1, outputAttributes$1);
        return iter.map((Function1 & Serializable)row -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)part$1.getPartition(getPartitionKey.apply(row))), (Object)row.copy()));
    }

    public static final /* synthetic */ Iterator $anonfun$prepareShuffleDependency$18(Partitioner part$1, Partitioning newPartitioning$1, Seq outputAttributes$1, int x$7, Iterator iter) {
        Function1 getPartitionKey = ShuffleExchangeExec$.getPartitionKeyExtractor$1(newPartitioning$1, outputAttributes$1);
        MutablePair mutablePair = new MutablePair();
        return iter.map((Function1 & Serializable)row -> mutablePair.update((Object)BoxesRunTime.boxToInteger((int)part$1.getPartition(getPartitionKey.apply(row))), row));
    }

    private ShuffleExchangeExec$() {
    }

    public static final /* synthetic */ Iterator $anonfun$prepareShuffleDependency$16$adapted(Partitioner part$1, Partitioning newPartitioning$1, Seq outputAttributes$1, Object x$6, Iterator iter) {
        return ShuffleExchangeExec$.$anonfun$prepareShuffleDependency$16(part$1, newPartitioning$1, outputAttributes$1, BoxesRunTime.unboxToInt((Object)x$6), iter);
    }

    public static final /* synthetic */ Iterator $anonfun$prepareShuffleDependency$18$adapted(Partitioner part$1, Partitioning newPartitioning$1, Seq outputAttributes$1, Object x$7, Iterator iter) {
        return ShuffleExchangeExec$.$anonfun$prepareShuffleDependency$18(part$1, newPartitioning$1, outputAttributes$1, BoxesRunTime.unboxToInt((Object)x$7), iter);
    }
}

