/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.spark.QueryContext;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.CheckOverflowInSum;
import org.apache.spark.sql.catalyst.expressions.DecimalAddNoOverflowCheck;
import org.apache.spark.sql.catalyst.expressions.EvalMode$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.KnownNotNull;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NumericEvalContext;
import org.apache.spark.sql.catalyst.expressions.NumericEvalContext$;
import org.apache.spark.sql.catalyst.expressions.Predicate;
import org.apache.spark.sql.catalyst.expressions.SupportQueryContext;
import org.apache.spark.sql.catalyst.expressions.aggregate.DeclarativeAggregate;
import org.apache.spark.sql.catalyst.expressions.aggregate.Sum$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnsiIntervalType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the sum calculated from values of a group.", examples="\n    Examples:\n      > SELECT _FUNC_(col) FROM VALUES (5), (10), (15) AS tab(col);\n       30\n      > SELECT _FUNC_(col) FROM VALUES (NULL), (10), (15) AS tab(col);\n       25\n      > SELECT _FUNC_(col) FROM VALUES (NULL), (NULL) AS tab(col);\n       NULL\n  ", group="agg_funcs", since="1.0.0")
@ScalaSignature(bytes="\u0006\u0005\t]e\u0001\u0002\u00180\u0001zB\u0001\"\u001a\u0001\u0003\u0016\u0004%\tA\u001a\u0005\tO\u0002\u0011\t\u0012)A\u0005\u001b\"A\u0001\u000e\u0001BK\u0002\u0013\u0005\u0011\u000e\u0003\u0005n\u0001\tE\t\u0015!\u0003k\u0011\u0015q\u0007\u0001\"\u0001p\u0011\u0015q\u0007\u0001\"\u0001t\u0011\u0015)\b\u0001\"\u0003w\u0011\u0015Q\b\u0001\"\u0011w\u0011\u0015Y\b\u0001\"\u0011}\u0011\u001d\t9\u0001\u0001C!\u0003\u0013Aq!a\u0006\u0001\t\u0003\nI\u0002C\u0005\u0002(\u0001\u0011\r\u0011\"\u0012\u0002*!A\u00111\u000b\u0001!\u0002\u001b\tY\u0003\u0003\u0006\u0002V\u0001A)\u0019!C\u0005\u0003/B!\"a\u001d\u0001\u0011\u000b\u0007I\u0011BA;\u0011)\ti\b\u0001EC\u0002\u0013%\u0011Q\u000f\u0005\u000b\u0003\u007f\u0002\u0001R1A\u0005\n\u0005\u0005\u0005bBAE\u0001\u0011%\u00111\u0012\u0005\u000b\u0003+\u0003\u0001R1A\u0005B\u0005]\u0005BCAN\u0001!\u0015\r\u0011\"\u0011\u0002\u001e\"Q\u0011\u0011\u0015\u0001\t\u0006\u0004%\t%!(\t\u0015\u0005\r\u0006\u0001#b\u0001\n\u0003\ni\nC\u0005\u0002&\u0002A)\u0019!C!M\"9\u0011q\u0015\u0001\u0005B\u0005%\u0006bBA\\\u0001\u0011\u0005\u0013\u0011\u0018\u0005\b\u0003\u0013\u0004A\u0011KAf\u0011%\t\t\u000eAA\u0001\n\u0003\t\u0019\u000eC\u0005\u0002Z\u0002\t\n\u0011\"\u0001\u0002\\\"I\u0011\u0011\u001f\u0001\u0012\u0002\u0013\u0005\u00111\u001f\u0005\n\u0003o\u0004\u0011\u0011!C!\u0003sD\u0011Ba\u0002\u0001\u0003\u0003%\tA!\u0003\t\u0013\tE\u0001!!A\u0005\u0002\tM\u0001\"\u0003B\r\u0001\u0005\u0005I\u0011\tB\u000e\u0011%\u00119\u0003AA\u0001\n\u0003\u0011I\u0003C\u0005\u0003.\u0001\t\t\u0011\"\u0011\u00030!I!1\u0007\u0001\u0002\u0002\u0013\u0005#QG\u0004\n\u00053z\u0013\u0011!E\u0001\u000572\u0001BL\u0018\u0002\u0002#\u0005!Q\f\u0005\u0007]\u001a\"\tAa\u001b\t\u0013\t5d%!A\u0005F\t=\u0004\"\u0003B9M\u0005\u0005I\u0011\u0011B:\u0011%\u0011IHJI\u0001\n\u0003\t\u0019\u0010C\u0005\u0003|\u0019\n\t\u0011\"!\u0003~!I!1\u0012\u0014\u0012\u0002\u0013\u0005\u00111\u001f\u0005\n\u0005\u001b3\u0013\u0011!C\u0005\u0005\u001f\u00131aU;n\u0015\t\u0001\u0014'A\u0005bO\u001e\u0014XmZ1uK*\u0011!gM\u0001\fKb\u0004(/Z:tS>t7O\u0003\u00025k\u0005A1-\u0019;bYf\u001cHO\u0003\u00027o\u0005\u00191/\u001d7\u000b\u0005aJ\u0014!B:qCJ\\'B\u0001\u001e<\u0003\u0019\t\u0007/Y2iK*\tA(A\u0002pe\u001e\u001c\u0001aE\u0004\u0001\u007f\r;\u0005kU-\u0011\u0005\u0001\u000bU\"A\u0018\n\u0005\t{#\u0001\u0006#fG2\f'/\u0019;jm\u0016\fum\u001a:fO\u0006$X\r\u0005\u0002E\u000b6\t\u0011'\u0003\u0002Gc\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000fE\u0002I\u00176k\u0011!\u0013\u0006\u0003\u0015N\nQ\u0001\u001e:fKNL!\u0001T%\u0003\u0013Us\u0017M]=MS.,\u0007C\u0001#O\u0013\ty\u0015G\u0001\u0006FqB\u0014Xm]:j_:\u0004\"\u0001R)\n\u0005I\u000b$aE*vaB|'\u000f^)vKJL8i\u001c8uKb$\bC\u0001+X\u001b\u0005)&\"\u0001,\u0002\u000bM\u001c\u0017\r\\1\n\u0005a+&a\u0002)s_\u0012,8\r\u001e\t\u00035\nt!a\u00171\u000f\u0005q{V\"A/\u000b\u0005yk\u0014A\u0002\u001fs_>$h(C\u0001W\u0013\t\tW+A\u0004qC\u000e\\\u0017mZ3\n\u0005\r$'\u0001D*fe&\fG.\u001b>bE2,'BA1V\u0003\u0015\u0019\u0007.\u001b7e+\u0005i\u0015AB2iS2$\u0007%A\u0006fm\u0006d7i\u001c8uKb$X#\u00016\u0011\u0005\u0011[\u0017B\u000172\u0005IqU/\\3sS\u000e,e/\u00197D_:$X\r\u001f;\u0002\u0019\u00154\u0018\r\\\"p]R,\u0007\u0010\u001e\u0011\u0002\rqJg.\u001b;?)\r\u0001\u0018O\u001d\t\u0003\u0001\u0002AQ!Z\u0003A\u00025Cq\u0001[\u0003\u0011\u0002\u0003\u0007!\u000e\u0006\u0002qi\")QM\u0002a\u0001\u001b\u0006\u00112\u000f[8vY\u0012$&/Y2l\u0013N,U\u000e\u001d;z+\u00059\bC\u0001+y\u0013\tIXKA\u0004C_>dW-\u00198\u0002\u00119,H\u000e\\1cY\u0016\f\u0001\u0002Z1uCRK\b/Z\u000b\u0002{B\u0019a0a\u0001\u000e\u0003}T1!!\u00016\u0003\u0015!\u0018\u0010]3t\u0013\r\t)a \u0002\t\t\u0006$\u0018\rV=qK\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0005\u0005-\u0001#\u0002.\u0002\u000e\u0005E\u0011bAA\bI\n\u00191+Z9\u0011\u0007y\f\u0019\"C\u0002\u0002\u0016}\u0014\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0005\u0005m\u0001\u0003BA\u000f\u0003Gi!!a\b\u000b\u0007\u0005\u00052'\u0001\u0005b]\u0006d\u0017p]5t\u0013\u0011\t)#a\b\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYR\fAB\\8eKB\u000bG\u000f^3s]N,\"!a\u000b\u0011\u000bi\u000bi!!\f\u0011\t\u0005=\u0012Q\n\b\u0005\u0003c\tIE\u0004\u0003\u00024\u0005\u001dc\u0002BA\u001b\u0003\u000brA!a\u000e\u0002D9!\u0011\u0011HA!\u001d\u0011\tY$a\u0010\u000f\u0007q\u000bi$C\u0001=\u0013\tQ4(\u0003\u00029s%\u0011agN\u0005\u0003iUJ!AS\u001a\n\u0007\u0005-\u0013*A\u0006Ue\u0016,\u0007+\u0019;uKJt\u0017\u0002BA(\u0003#\u00121\u0002\u0016:fKB\u000bG\u000f^3s]*\u0019\u00111J%\u0002\u001b9|G-\u001a)biR,'O\\:!\u0003)\u0011Xm];miRK\b/Z\u000b\u0003\u00033\u0012r!a\u0017\u0002`M\u000b)G\u0002\u0004\u0002^\u0001\u0001\u0011\u0011\f\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\t\u0004}\u0006\u0005\u0014bAA2\u007f\nQ\u0011\t^8nS\u000e$\u0016\u0010]3\u0011\t\u0005\u001d\u0014\u0011O\u0007\u0003\u0003SRA!a\u001b\u0002n\u0005\u0011\u0011n\u001c\u0006\u0003\u0003_\nAA[1wC&\u00191-!\u001b\u0002\u0007M,X.\u0006\u0002\u0002xA\u0019A)!\u001f\n\u0007\u0005m\u0014G\u0001\nBiR\u0014\u0018NY;uKJ+g-\u001a:f]\u000e,\u0017aB5t\u000b6\u0004H/_\u0001\u0005u\u0016\u0014x.\u0006\u0002\u0002\u0004B\u0019A)!\"\n\u0007\u0005\u001d\u0015GA\u0004MSR,'/\u00197\u0002\u0007\u0005$G\rF\u0003N\u0003\u001b\u000b\t\n\u0003\u0004\u0002\u0010J\u0001\r!T\u0001\u0005Y\u00164G\u000f\u0003\u0004\u0002\u0014J\u0001\r!T\u0001\u0006e&<\u0007\u000e^\u0001\u0014C\u001e<')\u001e4gKJ\fE\u000f\u001e:jEV$Xm]\u000b\u0003\u00033\u0003RAWA\u0007\u0003o\nQ\"\u001b8ji&\fGNV1mk\u0016\u001cXCAAP!\u0011Q\u0016QB'\u0002#U\u0004H-\u0019;f\u000bb\u0004(/Z:tS>t7/\u0001\tnKJ<W-\u0012=qe\u0016\u001c8/[8og\u0006\u0011RM^1mk\u0006$X-\u0012=qe\u0016\u001c8/[8o\u000351G.\u0019;Be\u001e,X.\u001a8ugV\u0011\u00111\u0016\t\u00065\u00065\u0016\u0011W\u0005\u0004\u0003_#'\u0001C%uKJ\fGo\u001c:\u0011\u0007Q\u000b\u0019,C\u0002\u00026V\u00131!\u00118z\u0003AIg.\u001b;Rk\u0016\u0014\u0018pQ8oi\u0016DH\u000f\u0006\u0002\u0002<B)A+!0\u0002B&\u0019\u0011qX+\u0003\r=\u0003H/[8o!\u0011\t\u0019-!2\u000e\u0003]J1!a28\u00051\tV/\u001a:z\u0007>tG/\u001a=u\u0003Q9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7e\u0013:$XM\u001d8bYR\u0019Q*!4\t\r\u0005='\u00041\u0001N\u0003!qWm^\"iS2$\u0017\u0001B2paf$R\u0001]Ak\u0003/Dq!Z\u000e\u0011\u0002\u0003\u0007Q\nC\u0004i7A\u0005\t\u0019\u00016\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u001c\u0016\u0004\u001b\u0006}7FAAq!\u0011\t\u0019/!<\u000e\u0005\u0005\u0015(\u0002BAt\u0003S\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-X+\u0001\u0006b]:|G/\u0019;j_:LA!a<\u0002f\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u001f\u0016\u0004U\u0006}\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002|B!\u0011Q B\u0002\u001b\t\tyP\u0003\u0003\u0003\u0002\u00055\u0014\u0001\u00027b]\u001eLAA!\u0002\u0002\u0000\n11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"Aa\u0003\u0011\u0007Q\u0013i!C\u0002\u0003\u0010U\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!-\u0003\u0016!I!q\u0003\u0011\u0002\u0002\u0003\u0007!1B\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\tu\u0001C\u0002B\u0010\u0005K\t\t,\u0004\u0002\u0003\")\u0019!1E+\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00020\n\u0005\u0012\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007]\u0014Y\u0003C\u0005\u0003\u0018\t\n\t\u00111\u0001\u00022\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\tYP!\r\t\u0013\t]1%!AA\u0002\t-\u0011AB3rk\u0006d7\u000fF\u0002x\u0005oA\u0011Ba\u0006%\u0003\u0003\u0005\r!!-)'\u0001\u0011YD!\u0011\u0003D\t\u001d#\u0011\nB'\u0005\u001f\u0012\u0019F!\u0016\u0011\u0007\u0011\u0013i$C\u0002\u0003@E\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0003F\u0005\tuLR+O\u0007~CS\r\u001f9sS\u0001j\u0003EU3ukJt7\u000f\t;iK\u0002\u001aX/\u001c\u0011dC2\u001cW\u000f\\1uK\u0012\u0004cM]8nAY\fG.^3tA=4\u0007%\u0019\u0011he>,\bOL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012!1J\u0001\u0002\u0000*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C3m\u001c7*A\u0019\u0013v*\u0014\u0011W\u00032+Vi\u0015\u0011)k%b\u0003\u0005K\u00191S1\u0002\u0003&M\u001b*A\u0005\u001b\u0006\u0005^1cQ\r|G.K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!gAR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fY8mS\u00012%kT'!-\u0006cU+R*!Q9+F\nT\u0015-A!\n\u0004'\u000b\u0017!QE*\u0014\u0006I!TAQ\f'\rK2pY&Z$\u0002\t\u0011!A\u0001\u0002\u0003EM\u001b\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\r|G.\u000b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005\u000b(V\u00192KC\u0006\t\u0015O+2c\u0015\u0006I!TAQ\f'\rK2pY&Z$\u0002\t\u0011!A\u0001\u0002\u0003ET+M\u0019*\u0001\u0003%A\u0003he>,\b/\t\u0002\u0003R\u0005I\u0011mZ4`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0005/\nQ!\r\u00181]A\n1aU;n!\t\u0001eeE\u0003'\u0005?\n)\u0007E\u0004\u0003b\t\u001dTJ\u001b9\u000e\u0005\t\r$b\u0001B3+\u00069!/\u001e8uS6,\u0017\u0002\u0002B5\u0005G\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\u0011Y&\u0001\u0005u_N#(/\u001b8h)\t\tY0A\u0003baBd\u0017\u0010F\u0003q\u0005k\u00129\bC\u0003fS\u0001\u0007Q\nC\u0004iSA\u0005\t\u0019\u00016\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uII\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\u0000\t\u001d\u0005#\u0002+\u0002>\n\u0005\u0005#\u0002+\u0003\u00046S\u0017b\u0001BC+\n1A+\u001e9mKJB\u0001B!#,\u0003\u0003\u0005\r\u0001]\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003\u0012B!\u0011Q BJ\u0013\u0011\u0011)*a@\u0003\r=\u0013'.Z2u\u0001")
public class Sum
extends DeclarativeAggregate
implements ImplicitCastInputTypes,
UnaryLike<Expression>,
SupportQueryContext {
    private AtomicType resultType;
    private AttributeReference sum;
    private AttributeReference isEmpty;
    private Literal zero;
    private Seq<AttributeReference> aggBufferAttributes;
    private Seq<Expression> initialValues;
    private Seq<Expression> updateExpressions;
    private Seq<Expression> mergeExpressions;
    private Expression evaluateExpression;
    private final Expression child;
    private final NumericEvalContext evalContext;
    private final Seq<Enumeration.Value> nodePatterns;
    private Option<QueryContext> queryContext;
    private transient Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;
    private volatile int bitmap$0;

    public static NumericEvalContext $lessinit$greater$default$2() {
        return Sum$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, NumericEvalContext>> unapply(Sum x$0) {
        return Sum$.MODULE$.unapply(x$0);
    }

    public static NumericEvalContext apply$default$2() {
        return Sum$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<Expression, NumericEvalContext>, Sum> tupled() {
        return Sum$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<NumericEvalContext, Sum>> curried() {
        return Sum$.MODULE$.curried();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$catalyst$expressions$SupportQueryContext$$super$copyTagsFrom(Expression other) {
        super.copyTagsFrom(other);
    }

    @Override
    public QueryContext getContextOrNull() {
        return SupportQueryContext.getContextOrNull$(this);
    }

    @Override
    public String getContextOrNullCode(CodegenContext ctx, boolean withErrorContext) {
        return SupportQueryContext.getContextOrNullCode$(this, ctx, withErrorContext);
    }

    @Override
    public boolean getContextOrNullCode$default$2() {
        return SupportQueryContext.getContextOrNullCode$default$2$(this);
    }

    @Override
    public void copyTagsFrom(Expression other) {
        SupportQueryContext.copyTagsFrom$(this, other);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public Option<QueryContext> queryContext() {
        return this.queryContext;
    }

    @Override
    public void queryContext_$eq(Option<QueryContext> x$1) {
        this.queryContext = x$1;
    }

    private Seq<Expression> children$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public NumericEvalContext evalContext() {
        return this.evalContext;
    }

    private boolean shouldTrackIsEmpty() {
        AtomicType atomicType = this.resultType();
        if (atomicType instanceof DecimalType) {
            return true;
        }
        if (atomicType instanceof IntegralType ? true : atomicType instanceof AnsiIntervalType) {
            Enumeration.Value value = this.evalContext().evalMode();
            Enumeration.Value value2 = EvalMode$.MODULE$.TRY();
            if (!(value != null ? !value.equals(value2) : value2 != null)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return this.resultType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, YearMonthIntervalType$.MODULE$, DayTimeIntervalType$.MODULE$})), (List)Nil$.MODULE$);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return TypeUtils$.MODULE$.checkForAnsiIntervalOrNumericType(this.child());
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private AtomicType resultType$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 1) == 0) {
                LongType$ longType$;
                DecimalType decimalType;
                Option option;
                DataType dataType = this.child().dataType();
                if (dataType instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
                    int precision = ((Tuple2)option.get())._1$mcI$sp();
                    int scale = ((Tuple2)option.get())._2$mcI$sp();
                    longType$ = DecimalType$.MODULE$.bounded(precision + 10, scale);
                } else if (dataType instanceof IntegralType) {
                    longType$ = LongType$.MODULE$;
                } else if (dataType instanceof YearMonthIntervalType) {
                    YearMonthIntervalType yearMonthIntervalType = (YearMonthIntervalType)dataType;
                    longType$ = yearMonthIntervalType;
                } else if (dataType instanceof DayTimeIntervalType) {
                    DayTimeIntervalType dayTimeIntervalType = (DayTimeIntervalType)dataType;
                    longType$ = dayTimeIntervalType;
                } else {
                    longType$ = DoubleType$.MODULE$;
                }
                this.resultType = longType$;
                this.bitmap$0 |= 1;
            }
        }
        return this.resultType;
    }

    private AtomicType resultType() {
        if ((this.bitmap$0 & 1) == 0) {
            return this.resultType$lzycompute();
        }
        return this.resultType;
    }

    private AttributeReference sum$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 2) == 0) {
                String x$1 = "sum";
                AtomicType x$2 = this.resultType();
                boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("sum", (DataType)x$2, x$3, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6("sum", (DataType)x$2, x$3, x$4);
                this.sum = new AttributeReference("sum", (DataType)x$2, x$3, x$4, x$5, x$6);
                this.bitmap$0 |= 2;
            }
        }
        return this.sum;
    }

    private AttributeReference sum() {
        if ((this.bitmap$0 & 2) == 0) {
            return this.sum$lzycompute();
        }
        return this.sum;
    }

    private AttributeReference isEmpty$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 4) == 0) {
                String x$1 = "isEmpty";
                BooleanType$ x$2 = BooleanType$.MODULE$;
                boolean x$3 = false;
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("isEmpty", (DataType)x$2, false, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6("isEmpty", (DataType)x$2, false, x$4);
                this.isEmpty = new AttributeReference("isEmpty", (DataType)x$2, false, x$4, x$5, x$6);
                this.bitmap$0 |= 4;
            }
        }
        return this.isEmpty;
    }

    private AttributeReference isEmpty() {
        if ((this.bitmap$0 & 4) == 0) {
            return this.isEmpty$lzycompute();
        }
        return this.isEmpty;
    }

    private Literal zero$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 8) == 0) {
                this.zero = Literal$.MODULE$.default((DataType)this.resultType());
                this.bitmap$0 |= 8;
            }
        }
        return this.zero;
    }

    private Literal zero() {
        if ((this.bitmap$0 & 8) == 0) {
            return this.zero$lzycompute();
        }
        return this.zero;
    }

    private Expression add(Expression left, Expression right) {
        DataType dataType = left.dataType();
        if (dataType instanceof DecimalType) {
            return new DecimalAddNoOverflowCheck(left, right, left.dataType());
        }
        return new Add(left, right, this.evalContext());
    }

    private Seq<AttributeReference> aggBufferAttributes$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x10) == 0) {
                List list;
                if (this.shouldTrackIsEmpty()) {
                    AttributeReference attributeReference = this.sum();
                    AttributeReference attributeReference2 = this.isEmpty();
                    list = Nil$.MODULE$.$colon$colon((Object)attributeReference2).$colon$colon((Object)attributeReference);
                } else {
                    AttributeReference attributeReference = this.sum();
                    list = Nil$.MODULE$.$colon$colon((Object)attributeReference);
                }
                this.aggBufferAttributes = list;
                this.bitmap$0 |= 0x10;
            }
        }
        return this.aggBufferAttributes;
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        if ((this.bitmap$0 & 0x10) == 0) {
            return this.aggBufferAttributes$lzycompute();
        }
        return this.aggBufferAttributes;
    }

    private Seq<Expression> initialValues$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.initialValues = this.shouldTrackIsEmpty() ? new .colon.colon((Object)this.zero(), (List)new .colon.colon((Object)new Literal(BoxesRunTime.boxToBoolean((boolean)true), (DataType)BooleanType$.MODULE$), (List)Nil$.MODULE$)) : new .colon.colon((Object)new Literal(null, (DataType)this.resultType()), (List)Nil$.MODULE$);
                this.bitmap$0 |= 0x20;
            }
        }
        return this.initialValues;
    }

    @Override
    public Seq<Expression> initialValues() {
        if ((this.bitmap$0 & 0x20) == 0) {
            return this.initialValues$lzycompute();
        }
        return this.initialValues;
    }

    private Seq<Expression> updateExpressions$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x40) == 0) {
                .colon.colon colon2;
                if (this.shouldTrackIsEmpty()) {
                    Expression sumExpr = this.child().nullable() ? new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.child()).isNull()), this.sum(), this.add(this.sum(), package$expressions$.MODULE$.DslExpression(new KnownNotNull(this.child())).cast((DataType)this.resultType()))) : this.add(this.sum(), package$expressions$.MODULE$.DslExpression(this.child()).cast((DataType)this.resultType()));
                    Literal isEmptyExpr = this.child().nullable() ? (Expression)((Object)package$expressions$.MODULE$.DslExpression(this.isEmpty()).$amp$amp((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.child()).isNull()))) : new Literal(BoxesRunTime.boxToBoolean((boolean)false), (DataType)BooleanType$.MODULE$);
                    colon2 = new .colon.colon((Object)sumExpr, (List)new .colon.colon((Object)isEmptyExpr, (List)Nil$.MODULE$));
                } else {
                    colon2 = this.child().nullable() ? new .colon.colon((Object)package$expressions$.MODULE$.coalesce((Seq<Expression>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.add(package$expressions$.MODULE$.coalesce((Seq<Expression>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.sum(), this.zero()})), package$expressions$.MODULE$.DslExpression(this.child()).cast((DataType)this.resultType())), this.sum()})), (List)Nil$.MODULE$) : new .colon.colon((Object)this.add(package$expressions$.MODULE$.coalesce((Seq<Expression>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.sum(), this.zero()})), package$expressions$.MODULE$.DslExpression(this.child()).cast((DataType)this.resultType())), (List)Nil$.MODULE$);
                }
                this.updateExpressions = colon2;
                this.bitmap$0 |= 0x40;
            }
        }
        return this.updateExpressions;
    }

    @Override
    public Seq<Expression> updateExpressions() {
        if ((this.bitmap$0 & 0x40) == 0) {
            return this.updateExpressions$lzycompute();
        }
        return this.updateExpressions;
    }

    private Seq<Expression> mergeExpressions$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x80) == 0) {
                .colon.colon colon2;
                if (this.shouldTrackIsEmpty()) {
                    Predicate bufferOverflow = package$expressions$.MODULE$.DslExpression((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.isEmpty()).left()).unary_$bang())).$amp$amp((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.sum()).left()).isNull()));
                    Predicate inputOverflow = package$expressions$.MODULE$.DslExpression((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.isEmpty()).right()).unary_$bang())).$amp$amp((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.sum()).right()).isNull()));
                    colon2 = new .colon.colon((Object)new If((Expression)((Object)package$expressions$.MODULE$.DslExpression((Expression)((Object)bufferOverflow)).$bar$bar((Expression)((Object)inputOverflow))), Literal$.MODULE$.create(null, (DataType)this.resultType()), this.add(new KnownNotNull(this.RichAttribute(this.sum()).left()), new KnownNotNull(this.RichAttribute(this.sum()).right()))), (List)new .colon.colon((Object)((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.isEmpty()).left()).$amp$amp(this.RichAttribute(this.isEmpty()).right()))), (List)Nil$.MODULE$));
                } else {
                    colon2 = new .colon.colon((Object)package$expressions$.MODULE$.coalesce((Seq<Expression>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.add(package$expressions$.MODULE$.coalesce((Seq<Expression>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.RichAttribute(this.sum()).left(), this.zero()})), this.RichAttribute(this.sum()).right()), this.RichAttribute(this.sum()).left()})), (List)Nil$.MODULE$);
                }
                this.mergeExpressions = colon2;
                this.bitmap$0 |= 0x80;
            }
        }
        return this.mergeExpressions;
    }

    @Override
    public Seq<Expression> mergeExpressions() {
        if ((this.bitmap$0 & 0x80) == 0) {
            return this.mergeExpressions$lzycompute();
        }
        return this.mergeExpressions;
    }

    private Expression evaluateExpression$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x100) == 0) {
                Expression expression;
                AtomicType atomicType = this.resultType();
                if (atomicType instanceof DecimalType) {
                    DecimalType decimalType = (DecimalType)atomicType;
                    Enumeration.Value value = this.evalContext().evalMode();
                    Enumeration.Value value2 = EvalMode$.MODULE$.ANSI();
                    CheckOverflowInSum checkOverflowInSum = new CheckOverflowInSum(this.sum(), decimalType, value == null ? value2 != null : !value.equals(value2), this.getContextOrNull());
                    expression = new If(this.isEmpty(), Literal$.MODULE$.create(null, (DataType)this.resultType()), checkOverflowInSum);
                } else {
                    expression = this.shouldTrackIsEmpty() ? new If(this.isEmpty(), Literal$.MODULE$.create(null, (DataType)this.resultType()), this.sum()) : this.sum();
                }
                this.evaluateExpression = expression;
                this.bitmap$0 |= 0x100;
            }
        }
        return this.evaluateExpression;
    }

    @Override
    public Expression evaluateExpression() {
        if ((this.bitmap$0 & 0x100) == 0) {
            return this.evaluateExpression$lzycompute();
        }
        return this.evaluateExpression;
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child()}));
    }

    @Override
    public Option<QueryContext> initQueryContext() {
        Enumeration.Value value = this.evalContext().evalMode();
        Enumeration.Value value2 = EvalMode$.MODULE$.ANSI();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            return new Some((Object)this.origin().context());
        }
        return None$.MODULE$;
    }

    @Override
    public Expression withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    public Sum copy(Expression child, NumericEvalContext evalContext) {
        return new Sum(child, evalContext);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public NumericEvalContext copy$default$2() {
        return this.evalContext();
    }

    @Override
    public String productPrefix() {
        return "Sum";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return this.evalContext();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Sum;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "evalContext";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Sum)) return false;
        boolean bl = true;
        if (!bl) return false;
        Sum sum = (Sum)x$1;
        Expression expression = this.child();
        Expression expression2 = sum.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        NumericEvalContext numericEvalContext = this.evalContext();
        NumericEvalContext numericEvalContext2 = sum.evalContext();
        if (numericEvalContext == null) {
            if (numericEvalContext2 != null) {
                return false;
            }
        } else if (!((Object)numericEvalContext).equals(numericEvalContext2)) return false;
        if (!sum.canEqual(this)) return false;
        return true;
    }

    public Sum(Expression child, NumericEvalContext evalContext) {
        this.child = child;
        this.evalContext = evalContext;
        ExpectsInputTypes.$init$(this);
        UnaryLike.$init$(this);
        SupportQueryContext.$init$(this);
        this.nodePatterns = new .colon.colon((Object)TreePattern$.MODULE$.SUM(), (List)Nil$.MODULE$);
    }

    public Sum(Expression child) {
        this(child, NumericEvalContext$.MODULE$.fromSQLConf(SQLConf$.MODULE$.get()));
    }
}

