/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.xml;

import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import javax.xml.namespace.QName;
import javax.xml.stream.EventFilter;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.spark.sql.catalyst.xml.StaxXMLRecordReader;
import org.apache.spark.sql.catalyst.xml.XmlOptions;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class StaxXmlParserUtils$ {
    public static final StaxXmlParserUtils$ MODULE$;
    private static final XMLInputFactory factory;
    private static final Function1<Object, Object> eventTypeFilter;

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        MODULE$ = new StaxXmlParserUtils$();
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isNamespaceAware", BoxesRunTime.boxToBoolean((boolean)false));
        factory.setProperty("javax.xml.stream.isCoalescing", BoxesRunTime.boxToBoolean((boolean)true));
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", BoxesRunTime.boxToBoolean((boolean)false));
        factory.setProperty("javax.xml.stream.supportDTD", BoxesRunTime.boxToBoolean((boolean)false));
        StaxXmlParserUtils$.factory = var0;
        eventTypeFilter = (JFunction1.mcZI.sp & Serializable)x0$1 -> {
            int n = x0$1;
            switch (n) {
                case 3: 
                case 5: {
                    return false;
                }
                case 9: 
                case 11: 
                case 14: 
                case 15: {
                    return false;
                }
            }
            return true;
        };
    }

    public XMLInputFactory factory() {
        return factory;
    }

    public Function1<Object, Object> eventTypeFilter() {
        return eventTypeFilter;
    }

    public XMLEventReader filteredReader(String xml) {
        EventFilter filter = new EventFilter(){

            public boolean accept(XMLEvent event) {
                return StaxXmlParserUtils$.MODULE$.eventTypeFilter().apply$mcZI$sp(event.getEventType());
            }
        };
        XMLEventReader eventReader = this.factory().createXMLEventReader(new StringReader(xml));
        return this.factory().createFilteredReader(eventReader, filter);
    }

    public XMLEventReader filteredReader(InputStream inputStream, XmlOptions options) {
        EventFilter filter = new EventFilter(){

            public boolean accept(XMLEvent event) {
                return StaxXmlParserUtils$.MODULE$.eventTypeFilter().apply$mcZI$sp(event.getEventType());
            }
        };
        BOMInputStream.Builder bomInputStreamBuilder = new BOMInputStream.Builder();
        bomInputStreamBuilder.setInputStream(inputStream);
        bomInputStreamBuilder.setCharset(options.charset());
        XMLEventReader eventReader = this.factory().createXMLEventReader((InputStream)bomInputStreamBuilder.get());
        return this.factory().createFilteredReader(eventReader, filter);
    }

    public StaxXMLRecordReader filteredReader(Function0<InputStream> inputStream, XmlOptions options) {
        return new StaxXMLRecordReader(inputStream, options);
    }

    public XMLStreamReader filteredStreamReader(InputStream inputStream, XmlOptions options) {
        StreamFilter filter = new StreamFilter(){

            public boolean accept(XMLStreamReader event) {
                return StaxXmlParserUtils$.MODULE$.eventTypeFilter().apply$mcZI$sp(event.getEventType());
            }
        };
        BOMInputStream.Builder bomInputStreamBuilder = new BOMInputStream.Builder();
        bomInputStreamBuilder.setInputStream(inputStream);
        XMLStreamReader streamReader = this.factory().createXMLStreamReader((InputStream)bomInputStreamBuilder.get(), options.charset());
        return this.factory().createFilteredReader(streamReader, filter);
    }

    public Attribute[] gatherRootAttributes(XMLEventReader parser) {
        XMLEvent rootEvent = this.skipUntil(parser, 1);
        return (Attribute[])CollectionConverters$.MODULE$.IteratorHasAsScala(rootEvent.asStartElement().getAttributes()).asScala().toArray(ClassTag$.MODULE$.apply(Attribute.class));
    }

    public XMLEvent skipUntil(XMLEventReader parser, int eventType) {
        XMLEvent event = parser.peek();
        while (parser.hasNext() && event.getEventType() != eventType) {
            event = parser.nextEvent();
        }
        return event;
    }

    public boolean checkEndElement(XMLEventReader parser) {
        XMLEvent xMLEvent;
        while (!((xMLEvent = parser.peek()) instanceof EndElement ? true : xMLEvent instanceof EndDocument)) {
            if (xMLEvent instanceof StartElement) {
                return false;
            }
            parser.nextEvent();
        }
        return true;
    }

    public Map<String, String> convertAttributesToValuesMap(Attribute[] attributes, XmlOptions options) {
        if (options.excludeAttributeFlag()) {
            return Predef$.MODULE$.Map().empty();
        }
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])attributes), (Function1 & Serializable)attr -> {
            String data;
            String key = options.attributePrefix() + MODULE$.getName(attr.getName(), options);
            String string = data = options.ignoreSurroundingSpaces() ? attr.getValue().trim() : attr.getValue();
            switch (string == null ? 0 : string.hashCode()) {
                default: 
            }
            String string2 = string;
            String string3 = options.nullValue();
            String value = !(string2 != null ? !string2.equals(string3) : string3 != null) ? null : string;
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
        }, ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public String getName(QName name, XmlOptions options) {
        String localPart = name.getLocalPart();
        if (options.ignoreNamespace()) {
            return (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])localPart.split(":")));
        }
        return localPart;
    }

    public String currentStructureAsString(XMLEventReader parser, String startElementName, XmlOptions options) {
        boolean bl;
        StringBuilder xmlString = new StringBuilder();
        int indent = 0;
        do {
            int ind;
            Tuple2<String, Object> tuple2;
            if ((tuple2 = this.nextEventToString(parser, indent)) == null) {
                throw new MatchError(tuple2);
            }
            String str = (String)tuple2._1();
            int ind2 = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)str, (Object)BoxesRunTime.boxToInteger((int)ind2));
            String str2 = (String)tuple22._1();
            indent = ind = tuple22._2$mcI$sp();
            xmlString.append(str2);
            XMLEvent xMLEvent = parser.peek();
            if (xMLEvent instanceof EndElement) {
                if (indent > 0) {
                    bl = true;
                    continue;
                }
                bl = false;
                continue;
            }
            bl = true;
        } while (bl);
        this.skipNextEndElement(parser, startElementName, options);
        return xmlString.toString();
    }

    public String currentElementAsString(XMLEventReader parser, String startElementName, XmlOptions options) {
        String string = this.getName(parser.peek().asStartElement().getName(), options);
        String string2 = startElementName;
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable)() -> "Expected StartElement <" + startElementName + ">, but found " + parser.peek());
        StringBuilder xmlString = new StringBuilder();
        int indent = 0;
        do {
            int ind;
            Tuple2<String, Object> tuple2;
            if ((tuple2 = this.nextEventToString(parser, indent)) == null) {
                throw new MatchError(tuple2);
            }
            String str = (String)tuple2._1();
            int ind2 = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)str, (Object)BoxesRunTime.boxToInteger((int)ind2));
            String str2 = (String)tuple22._1();
            indent = ind = tuple22._2$mcI$sp();
            xmlString.append(str2);
        } while (indent > 0);
        return xmlString.toString();
    }

    private Tuple2<String, Object> nextEventToString(XMLEventReader parser, int currentIdent) {
        XMLEvent xMLEvent = parser.nextEvent();
        if (xMLEvent instanceof StartElement) {
            StartElement startElement = (StartElement)xMLEvent;
            StringBuilder sb = new StringBuilder();
            sb.append('<').append((Object)startElement.getName());
            CollectionConverters$.MODULE$.IteratorHasAsScala(startElement.getAttributes()).asScala().foreach((Function1 & Serializable)att -> sb.append(' ').append((Object)att.getName()).append("=\"").append(att.getValue()).append('\"'));
            sb.append('>');
            return new Tuple2((Object)sb.toString(), (Object)BoxesRunTime.boxToInteger((int)(currentIdent + 1)));
        }
        if (xMLEvent instanceof EndElement) {
            EndElement endElement = (EndElement)xMLEvent;
            return new Tuple2((Object)("</" + endElement.getName() + ">"), (Object)BoxesRunTime.boxToInteger((int)(currentIdent - 1)));
        }
        if (xMLEvent instanceof Characters) {
            Characters characters = (Characters)xMLEvent;
            return new Tuple2((Object)characters.getData(), (Object)BoxesRunTime.boxToInteger((int)currentIdent));
        }
        if (xMLEvent != null) {
            return new Tuple2((Object)"", (Object)BoxesRunTime.boxToInteger((int)currentIdent));
        }
        throw new MatchError((Object)xMLEvent);
    }

    public void skipChildren(XMLEventReader parser, String expectedNextEndElementName, XmlOptions options) {
        boolean shouldStop = false;
        while (!shouldStop) {
            XMLEvent xMLEvent = parser.nextEvent();
            if (xMLEvent instanceof StartElement) {
                StartElement startElement = (StartElement)xMLEvent;
                String childField = this.getName(startElement.asStartElement().getName(), options);
                this.skipChildren(parser, childField, options);
                continue;
            }
            if (xMLEvent instanceof EndElement) {
                String endElementName;
                EndElement endElement = (EndElement)xMLEvent;
                String string = endElementName = this.getName(endElement.getName(), options);
                String string2 = expectedNextEndElementName;
                Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable)() -> "Expected EndElement </" + expectedNextEndElementName + ">, but found </" + endElementName + ">");
                shouldStop = true;
                continue;
            }
            if (xMLEvent != null) {
                continue;
            }
            throw new MatchError((Object)xMLEvent);
        }
    }

    public void skipNextEndElement(XMLEventReader parser, String expectedNextEndElementName, XmlOptions options) {
        String endElementName;
        Characters characters;
        XMLEvent xMLEvent;
        while ((xMLEvent = parser.nextEvent()) instanceof Characters && (characters = (Characters)xMLEvent).isWhiteSpace()) {
        }
        if (!(xMLEvent instanceof EndElement)) {
            throw new IllegalStateException("Expected EndElement </" + expectedNextEndElementName + ">");
        }
        EndElement endElement = (EndElement)xMLEvent;
        String string = endElementName = this.getName(endElement.getName(), options);
        String string2 = expectedNextEndElementName;
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable)() -> "Expected EndElement </" + expectedNextEndElementName + ">, but found </" + endElementName + ">");
    }

    private StaxXmlParserUtils$() {
    }
}

