/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.apache.spark.SparkException$;
import org.apache.spark.TaskContext$;
import org.apache.spark.errors.SparkCoreErrors$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockInfo;
import org.apache.spark.storage.BlockInfo$;
import org.apache.spark.storage.BlockInfoManager$;
import org.apache.spark.storage.BlockInfoWrapper;
import org.apache.spark.storage.BroadcastBlockId;
import org.apache.spark.storage.CacheId;
import org.apache.spark.storage.RDDBlockId;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import org.sparkproject.guava.collect.ConcurrentHashMultiset;
import org.sparkproject.guava.collect.ImmutableMultiset;
import org.sparkproject.guava.collect.Multiset;
import org.sparkproject.guava.util.concurrent.Striped;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashSet;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\tuf!B\u00181\u0001AB\u0004\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011B$\t\u000b)\u0003A\u0011A&\u0006\t=\u0003A\u0001\u0015\u0005\u0007'\u0002\u0001\u000b\u0011\u0002+\t\r\u0011\u0004\u0001\u0015!\u0003f\u0011\u0019)\b\u0001)A\u0005m\"1q\u000f\u0001Q\u0001\naD\u0001\"!\u0003\u0001A\u0003%\u00111\u0002\u0005\t\u0003C\u0001\u0001\u0015!\u0003\u0002$!A\u0011Q\t\u0001!\u0002\u0013\t9\u0005\u0003\u0005\u0002V\u0001\u0001\u000b\u0011BA,\u0011!\t)\u0007\u0001C\u0001a\u0005\u001d\u0004\u0002CA7\u0001\u0011\u0005!'a\u001c\t\u0011\u0005M\u0004\u0001\"\u00013\u0003kBq!a \u0001\t\u0003\t\t\tC\u0004\u0002\b\u0002!I!!#\t\u000f\u0005-\u0005\u0001\"\u0003\u0002\u000e\"9\u0011Q\u0016\u0001\u0005\n\u0005=\u0006bBAn\u0001\u0011\u0005\u0011Q\u001c\u0005\n\u0003G\u0004\u0011\u0013!C\u0001\u0003KDq!a?\u0001\t\u0003\ti\u0010C\u0005\u0003\u0004\u0001\t\n\u0011\"\u0001\u0002f\"9!Q\u0001\u0001\u0005\u0002\t\u001d\u0001\u0002\u0003B\u0006\u0001\u0011\u0005\u0001G!\u0004\t\u000f\tE\u0001\u0001\"\u0001\u0003\u0014!9!q\u0003\u0001\u0005\u0002\te\u0001\"\u0003B\u0012\u0001E\u0005I\u0011\u0001B\u0013\u0011\u001d\u0011I\u0003\u0001C\u0001\u0005WA\u0011Ba\u000e\u0001#\u0003%\t!!:\t\u000f\te\u0002\u0001\"\u0001\u0003<!A!\u0011\u000b\u0001\u0005\u0002A\u0012\u0019\u0006C\u0004\u0003X\u0001!\tA!\u0017\t\u0011\tm\u0003\u0001\"\u00011\u0005;BqAa\u0018\u0001\t\u0003\u0011\t\u0007C\u0004\u0003p\u0001!\tA!\u001d\t\u000f\t]\u0004\u0001\"\u0001\u0003z!9!q\u0010\u0001\u0005\u0002\t\u0005\u0005b\u0002BD\u0001\u0011\u0005!\u0011\u0012\u0005\b\u0005\u001b\u0003A\u0011\u0001BH\u0011\u001d\u0011\t\n\u0001C\u0005\u0005'CqAa*\u0001\t\u0013\u0011I\u000bC\u0004\u0003.\u0002!IAa,\b\u0015\tM\u0006'!A\t\u0002A\u0012)LB\u00050a\u0005\u0005\t\u0012\u0001\u0019\u00038\"1!\n\fC\u0001\u0005sC\u0011Ba/-#\u0003%\t!!:\u0003!\tcwnY6J]\u001a|W*\u00198bO\u0016\u0014(BA\u00193\u0003\u001d\u0019Ho\u001c:bO\u0016T!a\r\u001b\u0002\u000bM\u0004\u0018M]6\u000b\u0005U2\u0014AB1qC\u000eDWMC\u00018\u0003\ry'oZ\n\u0004\u0001ez\u0004C\u0001\u001e>\u001b\u0005Y$\"\u0001\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yZ$AB!osJ+g\r\u0005\u0002A\u00076\t\u0011I\u0003\u0002Ce\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002E\u0003\n9Aj\\4hS:<\u0017a\u0006;sC\u000e\\\u0017N\\4DC\u000eDWMV5tS\nLG.\u001b;z\u0007\u0001\u0001\"A\u000f%\n\u0005%[$a\u0002\"p_2,\u0017M\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00051s\u0005CA'\u0001\u001b\u0005\u0001\u0004bB#\u0003!\u0003\u0005\ra\u0012\u0002\u000e)\u0006\u001c8.\u0011;uK6\u0004H/\u00133\u0011\u0005i\n\u0016B\u0001*<\u0005\u0011auN\\4\u0002#\tdwnY6J]\u001a|wK]1qa\u0016\u00148\u000f\u0005\u0003V9z\u000bW\"\u0001,\u000b\u0005]C\u0016AC2p]\u000e,(O]3oi*\u0011\u0011LW\u0001\u0005kRLGNC\u0001\\\u0003\u0011Q\u0017M^1\n\u0005u3&!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB\u0011QjX\u0005\u0003AB\u0012qA\u00117pG.LE\r\u0005\u0002NE&\u00111\r\r\u0002\u0011\u00052|7m[%oM><&/\u00199qKJ\fQB\u001d3e)>\u0014En\\2l\u0013\u0012\u001c\b\u0003B+]M&\u0004\"AO4\n\u0005!\\$aA%oiB!!.\u001c0q\u001d\t)6.\u0003\u0002m-\u0006\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\n\u00059|'AC&fsN+GOV5fo*\u0011AN\u0016\t\u0003cRl\u0011A\u001d\u0006\u0003gj\u000bA\u0001\\1oO&\u0011\u0011J]\u0001\u0014EJ|\u0017\rZ2bgR$vN\u00117pG.LEm\u001d\t\u0005+r\u0003\u0016.A\ttKN\u001c\u0018n\u001c8U_\ncwnY6JIN\u0004B!\u0016/zSB\u0019!0a\u0001\u000f\u0005m|\bC\u0001?<\u001b\u0005i(B\u0001@G\u0003\u0019a$o\\8u}%\u0019\u0011\u0011A\u001e\u0002\rA\u0013X\rZ3g\u0013\u0011\t)!a\u0002\u0003\rM#(/\u001b8h\u0015\r\t\taO\u0001\u0013S:4\u0018n]5cY\u0016\u0014F\t\u0012\"m_\u000e\\7\u000f\u0005\u0004\u0002\u000e\u0005]\u00111D\u0007\u0003\u0003\u001fQA!!\u0005\u0002\u0014\u00059Q.\u001e;bE2,'bAA\u000bw\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005e\u0011q\u0002\u0002\b\u0011\u0006\u001c\bnU3u!\ri\u0015QD\u0005\u0004\u0003?\u0001$A\u0003*E\t\ncwnY6JI\u0006)An\\2lgB1\u0011QEA\u001c\u0003wi!!a\n\u000b\u0007]\u000bICC\u0002Z\u0003WQA!!\f\u00020\u000511m\\7n_:TA!!\r\u00024\u00051qm\\8hY\u0016T!!!\u000e\u0002\u0007\r|W.\u0003\u0003\u0002:\u0005\u001d\"aB*ue&\u0004X\r\u001a\t\u0005\u0003{\t\t%\u0004\u0002\u0002@)\u0019\u0011\u0011\u0005,\n\t\u0005\r\u0013q\b\u0002\u0005\u0019>\u001c7.\u0001\txe&$X\rT8dWN\u0014\u0015\u0010V1tWB1Q\u000bXA%\u0003\u001b\u00022!a\u0013\u0004\u001b\u0005\u0001\u0001#BA(\u0003#rV\"\u0001-\n\u0007\u0005M\u0003LA\u0002TKR\fqB]3bI2{7m[:CsR\u000b7o\u001b\t\u0007+r\u000bI%!\u0017\u0011\u000b\u0005m\u0013\u0011\r0\u000e\u0005\u0005u#\u0002BA0\u0003W\tqaY8mY\u0016\u001cG/\u0003\u0003\u0002d\u0005u#AF\"p]\u000e,(O]3oi\"\u000b7\u000f['vYRL7/\u001a;\u00023\r|g\u000e^1j]NLeN^5tS\ndWM\u0015#E\u00052|7m\u001b\u000b\u0004\u000f\u0006%\u0004bBA6\u0019\u0001\u0007\u00111D\u0001\bE2|7m[%e\u0003EI7O\u0015#E\u00052|7m\u001b,jg&\u0014G.\u001a\u000b\u0004\u000f\u0006E\u0004bBA6\u001b\u0001\u0007\u00111D\u0001\u0016iJLX*\u0019:l\u00052|7m[!t-&\u001c\u0018N\u00197f)\u0011\t9(! \u0011\u0007i\nI(C\u0002\u0002|m\u0012A!\u00168ji\"9\u00111\u000e\bA\u0002\u0005m\u0011\u0001\u0004:fO&\u001cH/\u001a:UCN\\G\u0003BA<\u0003\u0007Cq!!\"\u0010\u0001\u0004\tI%A\u0007uCN\\\u0017\t\u001e;f[B$\u0018\nZ\u0001\u0015GV\u0014(/\u001a8u)\u0006\u001c8.\u0011;uK6\u0004H/\u00133\u0016\u0005\u0005%\u0013aC1dcVL'/\u001a'pG.$b!a$\u0002(\u0006%F\u0003BAI\u0003;\u0003RAOAJ\u0003/K1!!&<\u0005\u0019y\u0005\u000f^5p]B\u0019Q*!'\n\u0007\u0005m\u0005GA\u0005CY>\u001c7.\u00138g_\"9\u0011qT\tA\u0002\u0005\u0005\u0016!\u00014\u0011\ri\n\u0019+a&H\u0013\r\t)k\u000f\u0002\n\rVt7\r^5p]FBa!a\u001b\u0012\u0001\u0004q\u0006BBAV#\u0001\u0007q)\u0001\u0005cY>\u001c7.\u001b8h\u0003%\u0011Gn\\2l\u0013:4w.\u0006\u0003\u00022\u0006eF\u0003BAZ\u00033$B!!.\u0002LB!\u0011qWA]\u0019\u0001!q!a/\u0013\u0005\u0004\tiLA\u0001U#\u0011\ty,!2\u0011\u0007i\n\t-C\u0002\u0002Dn\u0012qAT8uQ&tw\rE\u0002;\u0003\u000fL1!!3<\u0005\r\te.\u001f\u0005\b\u0003?\u0013\u0002\u0019AAg!%Q\u0014qZAL\u0003'\f),C\u0002\u0002Rn\u0012\u0011BR;oGRLwN\u001c\u001a\u0011\t\u0005u\u0012Q[\u0005\u0005\u0003/\fyDA\u0005D_:$\u0017\u000e^5p]\"1\u00111\u000e\nA\u0002y\u000ba\u0002\\8dW\u001a{'OU3bI&tw\r\u0006\u0004\u0002\u0012\u0006}\u0017\u0011\u001d\u0005\u0007\u0003W\u001a\u0002\u0019\u00010\t\u0011\u0005-6\u0003%AA\u0002\u001d\u000b\u0001\u0004\\8dW\u001a{'OU3bI&tw\r\n3fM\u0006,H\u000e\u001e\u00133+\t\t9OK\u0002H\u0003S\\#!a;\u0011\t\u00055\u0018q_\u0007\u0003\u0003_TA!!=\u0002t\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003k\\\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011`Ax\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fY>\u001c7NR8s/JLG/\u001b8h)\u0019\t\t*a@\u0003\u0002!1\u00111N\u000bA\u0002yC\u0001\"a+\u0016!\u0003\u0005\raR\u0001\u0019Y>\u001c7NR8s/JLG/\u001b8hI\u0011,g-Y;mi\u0012\u0012\u0014!H1tg\u0016\u0014HO\u00117pG.L5\u000fT8dW\u0016$gi\u001c:Xe&$\u0018N\\4\u0015\t\u0005]%\u0011\u0002\u0005\u0007\u0003W:\u0002\u0019\u00010\u0002\u0007\u001d,G\u000f\u0006\u0003\u0002\u0012\n=\u0001BBA61\u0001\u0007a,A\u0007e_^twM]1eK2{7m\u001b\u000b\u0005\u0003o\u0012)\u0002\u0003\u0004\u0002le\u0001\rAX\u0001\u0007k:dwnY6\u0015\r\u0005]$1\u0004B\u000f\u0011\u0019\tYG\u0007a\u0001=\"I!q\u0004\u000e\u0011\u0002\u0003\u0007!\u0011E\u0001\u0014i\u0006\u001c8.\u0011;uK6\u0004H/\u00133PaRLwN\u001c\t\u0006u\u0005M\u0015\u0011J\u0001\u0011k:dwnY6%I\u00164\u0017-\u001e7uII*\"Aa\n+\t\t\u0005\u0012\u0011^\u0001\u0017Y>\u001c7NT3x\u00052|7m\u001b$pe^\u0013\u0018\u000e^5oOR9qI!\f\u00030\tM\u0002BBA69\u0001\u0007a\fC\u0004\u00032q\u0001\r!a&\u0002\u00199,wO\u00117pG.LeNZ8\t\u0011\tUB\u0004%AA\u0002\u001d\u000bAb[3faJ+\u0017\r\u001a'pG.\f\u0001\u0005\\8dW:+wO\u00117pG.4uN],sSRLgn\u001a\u0013eK\u001a\fW\u000f\u001c;%g\u00051\"/\u001a7fCN,\u0017\t\u001c7M_\u000e\\7OR8s)\u0006\u001c8\u000e\u0006\u0003\u0003>\t=\u0003#\u0002B \u0005\u0013rf\u0002\u0002B!\u0005\u000br1\u0001 B\"\u0013\u0005a\u0014b\u0001B$w\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B&\u0005\u001b\u00121aU3r\u0015\r\u00119e\u000f\u0005\b\u0003\u000bs\u0002\u0019AA%\u0003A9W\r\u001e+bg.dunY6D_VtG\u000fF\u0002g\u0005+Bq!!\" \u0001\u0004\tI%\u0001\u0003tSj,W#\u00014\u0002+\u001d,GOT;nE\u0016\u0014xJZ'ba\u0016sGO]5fgV\t\u0001+A\u0004f]R\u0014\u0018.Z:\u0016\u0005\t\r\u0004C\u0002B \u0005K\u0012I'\u0003\u0003\u0003h\t5#\u0001C%uKJ\fGo\u001c:\u0011\ri\u0012YGXAL\u0013\r\u0011ig\u000f\u0002\u0007)V\u0004H.\u001a\u001a\u0002\u0017I$GM\u00117pG.LEm\u001d\u000b\u0005\u0005{\u0011\u0019\b\u0003\u0004\u0003v\r\u0002\rAZ\u0001\u0006e\u0012$\u0017\nZ\u0001\u0012EJ|\u0017\rZ2bgR\u0014En\\2l\u0013\u0012\u001cH\u0003\u0002B\u001f\u0005wBaA! %\u0001\u0004\u0001\u0016a\u00032s_\u0006$7-Y:u\u0013\u0012\fqb]3tg&|gN\u00117pG.LEm\u001d\u000b\u0005\u0005{\u0011\u0019\t\u0003\u0004\u0003\u0006\u0016\u0002\r!_\u0001\fg\u0016\u001c8/[8o+VKE)A\u0006sK6|g/\u001a\"m_\u000e\\G\u0003BA<\u0005\u0017Ca!a\u001b'\u0001\u0004q\u0016!B2mK\u0006\u0014HCAA<\u0003Y9W\r\u001e\"m_\u000e\\\u0017\nZ:Ge>lW*\u00199qS:<W\u0003\u0002BK\u0005?#bA!\u0010\u0003\u0018\n\r\u0006b\u0002BMQ\u0001\u0007!1T\u0001\u0004[\u0006\u0004\b#B+]\u0005;K\u0007\u0003BA\\\u0005?#qA!))\u0005\u0004\tiLA\u0001L\u0011\u001d\u0011)\u000b\u000ba\u0001\u0005;\u000b1a[3z\u00031\tG\r\u001a+p\u001b\u0006\u0004\b/\u001b8h)\u0011\t9Ha+\t\r\u0005-\u0014\u00061\u0001_\u0003E\u0011X-\\8wK\u001a\u0013x.\\'baBLgn\u001a\u000b\u0005\u0003o\u0012\t\f\u0003\u0004\u0002l)\u0002\rAX\u0001\u0011\u00052|7m[%oM>l\u0015M\\1hKJ\u0004\"!\u0014\u0017\u0014\u00051JDC\u0001B[\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c\u0001")
public class BlockInfoManager
implements Logging {
    private final boolean trackingCacheVisibility;
    private final ConcurrentHashMap<BlockId, BlockInfoWrapper> blockInfoWrappers;
    private final ConcurrentHashMap<Object, ConcurrentHashMap.KeySetView<BlockId, Boolean>> rddToBlockIds;
    private final ConcurrentHashMap<Object, ConcurrentHashMap.KeySetView<BlockId, Boolean>> broadcastToBlockIds;
    private final ConcurrentHashMap<String, ConcurrentHashMap.KeySetView<BlockId, Boolean>> sessionToBlockIds;
    private final HashSet<RDDBlockId> invisibleRDDBlocks;
    private final Striped<Lock> locks;
    private final ConcurrentHashMap<Object, Set<BlockId>> writeLocksByTask;
    private final ConcurrentHashMap<Object, ConcurrentHashMultiset<BlockId>> readLocksByTask;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static boolean $lessinit$greater$default$1() {
        return BlockInfoManager$.MODULE$.$lessinit$greater$default$1();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean containsInvisibleRDDBlock(RDDBlockId blockId) {
        boolean bl;
        HashSet<RDDBlockId> hashSet = this.invisibleRDDBlocks;
        synchronized (hashSet) {
            bl = this.invisibleRDDBlocks.contains((Object)blockId);
        }
        return bl;
    }

    public boolean isRDDBlockVisible(RDDBlockId blockId) {
        if (this.trackingCacheVisibility) {
            boolean bl;
            HashSet<RDDBlockId> hashSet = this.invisibleRDDBlocks;
            synchronized (hashSet) {
                bl = this.blockInfoWrappers.containsKey(blockId) && !this.invisibleRDDBlocks.contains((Object)blockId);
            }
            return bl;
        }
        return true;
    }

    public void tryMarkBlockAsVisible(RDDBlockId blockId) {
        if (this.trackingCacheVisibility) {
            HashSet<RDDBlockId> hashSet = this.invisibleRDDBlocks;
            synchronized (hashSet) {
                this.invisibleRDDBlocks.remove((Object)blockId);
            }
            return;
        }
    }

    public void registerTask(long taskAttemptId) {
        this.writeLocksByTask.putIfAbsent(BoxesRunTime.boxToLong((long)taskAttemptId), Collections.synchronizedSet(new java.util.HashSet()));
        this.readLocksByTask.putIfAbsent(BoxesRunTime.boxToLong((long)taskAttemptId), (ConcurrentHashMultiset<BlockId>)ConcurrentHashMultiset.create());
    }

    private long currentTaskAttemptId() {
        return BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.taskAttemptId())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> BlockInfo$.MODULE$.NON_TASK_WRITER()));
    }

    private Option<BlockInfo> acquireLock(BlockId blockId, boolean blocking, Function1<BlockInfo, Object> f) {
        BooleanRef done = BooleanRef.create((boolean)false);
        ObjectRef result = ObjectRef.create((Object)None$.MODULE$);
        while (!done.elem) {
            Object object;
            BlockInfoWrapper wrapper = this.blockInfoWrappers.get(blockId);
            if (wrapper == null) {
                done.elem = true;
                object = BoxedUnit.UNIT;
                continue;
            }
            object = wrapper.withLock((Function2 & Serializable)(info, condition) -> {
                BlockInfoManager.$anonfun$acquireLock$1(f, result, done, blocking, info, condition);
                return BoxedUnit.UNIT;
            });
        }
        return (Option)result.elem;
    }

    private <T> T blockInfo(BlockId blockId, Function2<BlockInfo, Condition, T> f) {
        BlockInfoWrapper wrapper = this.blockInfoWrappers.get(blockId);
        if (wrapper == null) {
            throw SparkCoreErrors$.MODULE$.blockDoesNotExistError(blockId);
        }
        return wrapper.withLock(f);
    }

    public Option<BlockInfo> lockForReading(BlockId blockId, boolean blocking) {
        long taskAttemptId = this.currentTaskAttemptId();
        this.logTrace((Function0<String>)(Function0 & Serializable)() -> "Task " + taskAttemptId + " trying to acquire read lock for " + blockId);
        return this.acquireLock(blockId, blocking, (Function1<BlockInfo, Object>)(Function1 & Serializable)info -> BoxesRunTime.boxToBoolean((boolean)BlockInfoManager.$anonfun$lockForReading$2(this, taskAttemptId, blockId, info)));
    }

    public boolean lockForReading$default$2() {
        return true;
    }

    public Option<BlockInfo> lockForWriting(BlockId blockId, boolean blocking) {
        long taskAttemptId = this.currentTaskAttemptId();
        this.logTrace((Function0<String>)(Function0 & Serializable)() -> "Task " + taskAttemptId + " trying to acquire write lock for " + blockId);
        return this.acquireLock(blockId, blocking, (Function1<BlockInfo, Object>)(Function1 & Serializable)info -> BoxesRunTime.boxToBoolean((boolean)BlockInfoManager.$anonfun$lockForWriting$2(this, taskAttemptId, blockId, info)));
    }

    public boolean lockForWriting$default$2() {
        return true;
    }

    public BlockInfo assertBlockIsLockedForWriting(BlockId blockId) {
        long taskAttemptId = this.currentTaskAttemptId();
        return (BlockInfo)this.blockInfo(blockId, (Function2 & Serializable)(info, x$2) -> {
            if (info.writerTask() != taskAttemptId) {
                throw SparkCoreErrors$.MODULE$.taskHasNotLockedBlockError(this.currentTaskAttemptId(), blockId);
            }
            return info;
        });
    }

    public Option<BlockInfo> get(BlockId blockId) {
        BlockInfoWrapper wrapper = this.blockInfoWrappers.get(blockId);
        if (wrapper != null) {
            return new Some((Object)wrapper.info());
        }
        return None$.MODULE$;
    }

    public void downgradeLock(BlockId blockId) {
        long taskAttemptId = this.currentTaskAttemptId();
        this.logTrace((Function0<String>)(Function0 & Serializable)() -> "Task " + taskAttemptId + " downgrading write lock for " + blockId);
        this.blockInfo(blockId, (Function2 & Serializable)(info, x$3) -> {
            BlockInfoManager.$anonfun$downgradeLock$2(this, taskAttemptId, blockId, info, x$3);
            return BoxedUnit.UNIT;
        });
    }

    public void unlock(BlockId blockId, Option<Object> taskAttemptIdOption) {
        long taskAttemptId = BoxesRunTime.unboxToLong((Object)taskAttemptIdOption.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> this.currentTaskAttemptId()));
        this.logTrace((Function0<String>)(Function0 & Serializable)() -> "Task " + taskAttemptId + " releasing lock for " + blockId);
        this.blockInfo(blockId, (Function2 & Serializable)(info, condition) -> {
            BlockInfoManager.$anonfun$unlock$3(this, taskAttemptId, blockId, info, condition);
            return BoxedUnit.UNIT;
        });
    }

    public Option<Object> unlock$default$2() {
        return None$.MODULE$;
    }

    public boolean lockNewBlockForWriting(BlockId blockId, BlockInfo newBlockInfo, boolean keepReadLock) {
        boolean bl;
        block12: {
            this.logTrace((Function0<String>)(Function0 & Serializable)() -> "Task " + this.currentTaskAttemptId() + " trying to put " + blockId);
            Lock lock = (Lock)this.locks.get((Object)blockId);
            lock.lock();
            try {
                BlockInfoWrapper wrapper = new BlockInfoWrapper(newBlockInfo, lock);
                do {
                    BlockInfoWrapper previous;
                    BlockInfoWrapper blockInfoWrapper;
                    if (this.trackingCacheVisibility) {
                        HashSet<RDDBlockId> hashSet = this.invisibleRDDBlocks;
                        synchronized (hashSet) {
                            BlockInfoWrapper res = this.blockInfoWrappers.putIfAbsent(blockId, wrapper);
                            if (res == null) {
                                blockId.asRDDId().foreach((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)this.invisibleRDDBlocks.add((Object)elem)));
                            }
                            BlockInfoWrapper blockInfoWrapper2 = res;
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 6, 11] lbl15 : MonitorExitStatement: MONITOREXIT : var7_7
                            blockInfoWrapper = blockInfoWrapper2;
                        }
                    } else {
                        blockInfoWrapper = this.blockInfoWrappers.putIfAbsent(blockId, wrapper);
                    }
                    if ((previous = blockInfoWrapper) == null) {
                        this.addToMapping(blockId);
                        Option<BlockInfo> result = this.lockForWriting(blockId, false);
                        Predef$.MODULE$.assert(result.isDefined());
                        bl = true;
                    } else {
                        if (keepReadLock) continue;
                        bl = false;
                    }
                    break block12;
                } while (!this.lockForReading(blockId, this.lockForReading$default$2()).isDefined());
                bl = false;
            }
            finally {
                lock.unlock();
            }
        }
        return bl;
    }

    public boolean lockNewBlockForWriting$default$3() {
        return true;
    }

    public Seq<BlockId> releaseAllLocksForTask(long taskAttemptId) {
        ArrayBuffer blocksWithReleasedLocks = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Set writeLocks = (Set)Option$.MODULE$.apply(this.writeLocksByTask.remove(BoxesRunTime.boxToLong((long)taskAttemptId))).getOrElse((Function0 & Serializable)() -> Set.of());
        writeLocks.forEach(blockId -> this.blockInfo((BlockId)blockId, (Function2 & Serializable)(info, condition) -> {
            BlockInfoManager.$anonfun$releaseAllLocksForTask$3(writeLocks, blockId, blocksWithReleasedLocks, taskAttemptId, info, condition);
            return BoxedUnit.UNIT;
        }));
        AbstractCollection readLocks = (AbstractCollection)Option$.MODULE$.apply(this.readLocksByTask.remove(BoxesRunTime.boxToLong((long)taskAttemptId))).getOrElse((Function0 & Serializable)() -> ImmutableMultiset.of());
        ((Multiset)readLocks).entrySet().forEach(entry -> {
            BlockId blockId = (BlockId)entry.getElement();
            this.blockInfo(blockId, (Function2 & Serializable)(info, condition) -> {
                BlockInfoManager.$anonfun$releaseAllLocksForTask$6(readLocks, blockId, blocksWithReleasedLocks, info, condition);
                return BoxedUnit.UNIT;
            });
        });
        return blocksWithReleasedLocks.toSeq();
    }

    public int getTaskLockCount(long taskAttemptId) {
        return BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply(this.readLocksByTask.get(BoxesRunTime.boxToLong((long)taskAttemptId))).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.size())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)) + BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply(this.writeLocksByTask.get(BoxesRunTime.boxToLong((long)taskAttemptId))).map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.size())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
    }

    public int size() {
        return this.blockInfoWrappers.size();
    }

    public long getNumberOfMapEntries() {
        return this.size() + this.readLocksByTask.size() + BoxesRunTime.unboxToInt((Object)((IterableOnceOps)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.readLocksByTask).asScala().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)BlockInfoManager.$anonfun$getNumberOfMapEntries$1(x$6)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + this.writeLocksByTask.size() + BoxesRunTime.unboxToInt((Object)((IterableOnceOps)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.writeLocksByTask).asScala().map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)BlockInfoManager.$anonfun$getNumberOfMapEntries$2(x$7)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public Iterator<Tuple2<BlockId, BlockInfo>> entries() {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(this.blockInfoWrappers.entrySet().iterator()).asScala().map((Function1 & Serializable)kv -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(kv.getKey()), (Object)((BlockInfoWrapper)kv.getValue()).info()));
    }

    public Seq<BlockId> rddBlockIds(int rddId) {
        return this.getBlockIdsFromMapping(this.rddToBlockIds, BoxesRunTime.boxToInteger((int)rddId));
    }

    public Seq<BlockId> broadcastBlockIds(long broadcastId) {
        return this.getBlockIdsFromMapping(this.broadcastToBlockIds, BoxesRunTime.boxToLong((long)broadcastId));
    }

    public Seq<BlockId> sessionBlockIds(String sessionUUID) {
        return this.getBlockIdsFromMapping(this.sessionToBlockIds, sessionUUID);
    }

    public void removeBlock(BlockId blockId) {
        long taskAttemptId = this.currentTaskAttemptId();
        this.logTrace((Function0<String>)(Function0 & Serializable)() -> "Task " + taskAttemptId + " trying to remove block " + blockId);
        this.blockInfo(blockId, (Function2 & Serializable)(info, condition) -> {
            BlockInfoManager.$anonfun$removeBlock$2(this, taskAttemptId, blockId, info, condition);
            return BoxedUnit.UNIT;
        });
    }

    public void clear() {
        this.blockInfoWrappers.values().forEach(wrapper -> wrapper.tryLock((Function2<BlockInfo, Condition, BoxedUnit>)(Function2 & Serializable)(info, condition) -> {
            BlockInfoManager.$anonfun$clear$2(info, condition);
            return BoxedUnit.UNIT;
        }));
        this.blockInfoWrappers.clear();
        this.rddToBlockIds.clear();
        this.broadcastToBlockIds.clear();
        this.sessionToBlockIds.clear();
        this.readLocksByTask.clear();
        this.writeLocksByTask.clear();
        HashSet<RDDBlockId> hashSet = this.invisibleRDDBlocks;
        synchronized (hashSet) {
            this.invisibleRDDBlocks.clear();
        }
    }

    private <K> Seq<BlockId> getBlockIdsFromMapping(ConcurrentHashMap<K, ConcurrentHashMap.KeySetView<BlockId, Boolean>> map, K key) {
        return (Seq)Option$.MODULE$.apply(map.get(key)).map((Function1 & Serializable)x$8 -> CollectionConverters$.MODULE$.SetHasAsScala((Set)x$8).asScala().toSeq()).getOrElse((Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty());
    }

    private void addToMapping(BlockId blockId) {
        BlockId blockId2 = blockId;
        if (blockId2 instanceof RDDBlockId) {
            RDDBlockId rDDBlockId = (RDDBlockId)blockId2;
            this.rddToBlockIds.computeIfAbsent(BoxesRunTime.boxToInteger((int)rDDBlockId.rddId()), x$9 -> BlockInfoManager.$anonfun$addToMapping$1(BoxesRunTime.unboxToInt((Object)x$9))).add(blockId);
            return;
        }
        if (blockId2 instanceof BroadcastBlockId) {
            BroadcastBlockId broadcastBlockId = (BroadcastBlockId)blockId2;
            this.broadcastToBlockIds.computeIfAbsent(BoxesRunTime.boxToLong((long)broadcastBlockId.broadcastId()), x$10 -> BlockInfoManager.$anonfun$addToMapping$2(BoxesRunTime.unboxToLong((Object)x$10))).add(blockId);
            return;
        }
        if (blockId2 instanceof CacheId) {
            CacheId cacheId = (CacheId)blockId2;
            this.sessionToBlockIds.computeIfAbsent(cacheId.sessionUUID(), x$11 -> ConcurrentHashMap.newKeySet()).add(blockId);
            return;
        }
    }

    private void removeFromMapping(BlockId blockId) {
        BlockId blockId2 = blockId;
        if (blockId2 instanceof RDDBlockId) {
            RDDBlockId rDDBlockId = (RDDBlockId)blockId2;
            BlockInfoManager.doRemove$1(this.rddToBlockIds, BoxesRunTime.boxToInteger((int)rDDBlockId.rddId()), rDDBlockId);
            return;
        }
        if (blockId2 instanceof BroadcastBlockId) {
            BroadcastBlockId broadcastBlockId = (BroadcastBlockId)blockId2;
            BlockInfoManager.doRemove$1(this.broadcastToBlockIds, BoxesRunTime.boxToLong((long)broadcastBlockId.broadcastId()), broadcastBlockId);
            return;
        }
        if (blockId2 instanceof CacheId) {
            CacheId cacheId = (CacheId)blockId2;
            BlockInfoManager.doRemove$1(this.sessionToBlockIds, cacheId.sessionUUID(), cacheId);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$acquireLock$1(Function1 f$1, ObjectRef result$1, BooleanRef done$1, boolean blocking$1, BlockInfo info, Condition condition) {
        if (BoxesRunTime.unboxToBoolean((Object)f$1.apply((Object)info))) {
            result$1.elem = new Some((Object)info);
            done$1.elem = true;
            return;
        }
        if (!blocking$1) {
            done$1.elem = true;
            return;
        }
        condition.await();
    }

    public static final /* synthetic */ boolean $anonfun$lockForReading$2(BlockInfoManager $this, long taskAttemptId$1, BlockId blockId$1, BlockInfo info) {
        boolean acquire;
        block0: {
            boolean bl = acquire = info.writerTask() == BlockInfo$.MODULE$.NO_WRITER();
            if (!acquire) break block0;
            info.readerCount_$eq(info.readerCount() + 1);
            $this.readLocksByTask.get(BoxesRunTime.boxToLong((long)taskAttemptId$1)).add((Object)blockId$1);
            $this.logTrace((Function0<String>)(Function0 & Serializable)() -> "Task " + taskAttemptId$1 + " acquired read lock for " + blockId$1);
        }
        return acquire;
    }

    public static final /* synthetic */ boolean $anonfun$lockForWriting$2(BlockInfoManager $this, long taskAttemptId$2, BlockId blockId$2, BlockInfo info) {
        boolean acquire;
        block0: {
            boolean bl = acquire = info.writerTask() == BlockInfo$.MODULE$.NO_WRITER() && info.readerCount() == 0;
            if (!acquire) break block0;
            info.writerTask_$eq(taskAttemptId$2);
            $this.writeLocksByTask.get(BoxesRunTime.boxToLong((long)taskAttemptId$2)).add(blockId$2);
            $this.logTrace((Function0<String>)(Function0 & Serializable)() -> "Task " + taskAttemptId$2 + " acquired write lock for " + blockId$2);
        }
        return acquire;
    }

    public static final /* synthetic */ void $anonfun$downgradeLock$2(BlockInfoManager $this, long taskAttemptId$4, BlockId blockId$4, BlockInfo info, Condition x$3) {
        Predef$.MODULE$.require(info.writerTask() == taskAttemptId$4, (Function0 & Serializable)() -> "Task " + taskAttemptId$4 + " tried to downgrade a write lock that it does not hold on block " + blockId$4);
        $this.unlock(blockId$4, $this.unlock$default$2());
        Option<BlockInfo> lockOutcome = $this.lockForReading(blockId$4, false);
        Predef$.MODULE$.assert(lockOutcome.isDefined());
    }

    public static final /* synthetic */ void $anonfun$unlock$3(BlockInfoManager $this, long taskAttemptId$5, BlockId blockId$5, BlockInfo info, Condition condition) {
        if (info.writerTask() != BlockInfo$.MODULE$.NO_WRITER()) {
            info.writerTask_$eq(BlockInfo$.MODULE$.NO_WRITER());
            Set<BlockId> blockIds = $this.writeLocksByTask.get(BoxesRunTime.boxToLong((long)taskAttemptId$5));
            v0 = blockIds != null ? BoxesRunTime.boxToBoolean((boolean)blockIds.remove(blockId$5)) : BoxedUnit.UNIT;
        } else {
            ConcurrentHashMultiset<BlockId> countsForTask = $this.readLocksByTask.get(BoxesRunTime.boxToLong((long)taskAttemptId$5));
            if (countsForTask != null) {
                Predef$.MODULE$.assert(info.readerCount() > 0, (Function0 & Serializable)() -> "Block " + blockId$5 + " is not locked for reading");
                info.readerCount_$eq(info.readerCount() - 1);
                int newPinCountForTask = countsForTask.remove((Object)blockId$5, 1) - 1;
                Predef$.MODULE$.assert(newPinCountForTask >= 0, (Function0 & Serializable)() -> "Task " + taskAttemptId$5 + " release lock on block " + blockId$5 + " more times than it acquired it");
            }
            v0 = BoxedUnit.UNIT;
        }
        condition.signalAll();
    }

    public static final /* synthetic */ void $anonfun$releaseAllLocksForTask$3(Set writeLocks$1, BlockId blockId$7, ArrayBuffer blocksWithReleasedLocks$1, long taskAttemptId$6, BlockInfo info, Condition condition) {
        if (writeLocks$1.contains(blockId$7)) {
            blocksWithReleasedLocks$1.$plus$eq((Object)blockId$7);
            Predef$.MODULE$.assert(info.writerTask() == taskAttemptId$6);
            info.writerTask_$eq(BlockInfo$.MODULE$.NO_WRITER());
            condition.signalAll();
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$releaseAllLocksForTask$6(AbstractCollection readLocks$1, BlockId blockId$8, ArrayBuffer blocksWithReleasedLocks$1, BlockInfo info, Condition condition) {
        int lockCount = ((Multiset)readLocks$1).count((Object)blockId$8);
        if (lockCount > 0) {
            blocksWithReleasedLocks$1.$plus$eq((Object)blockId$8);
            info.readerCount_$eq(info.readerCount() - lockCount);
            Predef$.MODULE$.assert(info.readerCount() >= 0);
            condition.signalAll();
            return;
        }
    }

    public static final /* synthetic */ int $anonfun$getNumberOfMapEntries$1(Tuple2 x$6) {
        return ((ConcurrentHashMultiset)x$6._2()).size();
    }

    public static final /* synthetic */ int $anonfun$getNumberOfMapEntries$2(Tuple2 x$7) {
        return ((Set)x$7._2()).size();
    }

    public static final /* synthetic */ void $anonfun$removeBlock$2(BlockInfoManager $this, long taskAttemptId$7, BlockId blockId$9, BlockInfo info, Condition condition) {
        if (info.writerTask() != taskAttemptId$7) {
            throw SparkException$.MODULE$.internalError("Task " + taskAttemptId$7 + " called remove() on block " + blockId$9 + " without a write lock", "STORAGE");
        }
        HashSet<RDDBlockId> hashSet = $this.invisibleRDDBlocks;
        synchronized (hashSet) {
            $this.blockInfoWrappers.remove(blockId$9);
            $this.removeFromMapping(blockId$9);
            blockId$9.asRDDId().foreach((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)$this.invisibleRDDBlocks.remove((Object)elem)));
        }
        info.readerCount_$eq(0);
        info.writerTask_$eq(BlockInfo$.MODULE$.NO_WRITER());
        $this.writeLocksByTask.get(BoxesRunTime.boxToLong((long)taskAttemptId$7)).remove(blockId$9);
        condition.signalAll();
    }

    public static final /* synthetic */ void $anonfun$clear$2(BlockInfo info, Condition condition) {
        info.readerCount_$eq(0);
        info.writerTask_$eq(BlockInfo$.MODULE$.NO_WRITER());
        condition.signalAll();
    }

    public static final /* synthetic */ ConcurrentHashMap.KeySetView $anonfun$addToMapping$1(int x$9) {
        return ConcurrentHashMap.newKeySet();
    }

    public static final /* synthetic */ ConcurrentHashMap.KeySetView $anonfun$addToMapping$2(long x$10) {
        return ConcurrentHashMap.newKeySet();
    }

    private static final void doRemove$1(ConcurrentHashMap map, Object key, BlockId block) {
        map.compute(key, (x$12, set) -> {
            if (set != null) {
                set.remove(block);
                if (set.isEmpty()) {
                    return null;
                }
                return set;
            }
            return null;
        });
    }

    public BlockInfoManager(boolean trackingCacheVisibility) {
        this.trackingCacheVisibility = trackingCacheVisibility;
        Logging.$init$((Logging)this);
        this.blockInfoWrappers = new ConcurrentHashMap();
        this.rddToBlockIds = new ConcurrentHashMap();
        this.broadcastToBlockIds = new ConcurrentHashMap();
        this.sessionToBlockIds = new ConcurrentHashMap();
        this.invisibleRDDBlocks = new HashSet();
        this.locks = Striped.lock((int)1024);
        this.writeLocksByTask = new ConcurrentHashMap();
        this.readLocksByTask = new ConcurrentHashMap();
        this.registerTask(BlockInfo$.MODULE$.NON_TASK_WRITER());
    }
}

