/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.checkpointing;

import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.checkpointing.CommitLog;
import org.apache.spark.sql.execution.streaming.checkpointing.CommitMetadata;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005a4Aa\u0003\u0007\u00017!A\u0001\u0005\u0001B\u0001B\u0003%\u0011\u0005\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003'\u0011!\u0019\u0004A!A!\u0002\u0013!\u0004\"\u0002 \u0001\t\u0003y\u0004b\u0002#\u0001\u0005\u0004%\t!\u0012\u0005\u0007\u001b\u0002\u0001\u000b\u0011\u0002$\t\u000b9\u0003A\u0011A(\t\u000bi\u0003A\u0011A.\t\u000b\u0005\u0004A\u0011\t2\t\u000b!\u0004A\u0011B5\u0003\u001d\u0005\u001b\u0018P\\2D_6l\u0017\u000e\u001e'pO*\u0011QBD\u0001\u000eG\",7m\u001b9pS:$\u0018N\\4\u000b\u0005=\u0001\u0012!C:ue\u0016\fW.\u001b8h\u0015\t\t\"#A\u0005fq\u0016\u001cW\u000f^5p]*\u00111\u0003F\u0001\u0004gFd'BA\u000b\u0017\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0002$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00023\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\b\t\u0003;yi\u0011\u0001D\u0005\u0003?1\u0011\u0011bQ8n[&$Hj\\4\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005\t\u001aS\"\u0001\n\n\u0005\u0011\u0012\"\u0001D*qCJ\\7+Z:tS>t\u0017\u0001\u00029bi\"\u0004\"a\n\u0019\u000f\u0005!r\u0003CA\u0015-\u001b\u0005Q#BA\u0016\u001b\u0003\u0019a$o\\8u})\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\u00051\u0001K]3eK\u001aL!!\r\u001a\u0003\rM#(/\u001b8h\u0015\tyC&A\bfq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f!\t)D(D\u00017\u0015\t9\u0004(\u0001\u0006d_:\u001cWO\u001d:f]RT!!\u000f\u001e\u0002\tU$\u0018\u000e\u001c\u0006\u0002w\u0005!!.\u0019<b\u0013\tidG\u0001\nUQJ,\u0017\r\u001a)p_2,\u00050Z2vi>\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0003A\u0003\n\u001b\u0005CA\u000f\u0001\u0011\u0015\u0001C\u00011\u0001\"\u0011\u0015)C\u00011\u0001'\u0011\u0015\u0019D\u00011\u00015\u0003]9(/\u001b;uK:$v\u000eR;sC\ndWm\u0015;pe\u0006<W-F\u0001G!\r)t)S\u0005\u0003\u0011Z\u0012QcQ8oGV\u0014(/\u001a8u\u0019&t7.\u001a3EKF,X\r\u0005\u0002K\u00176\tA&\u0003\u0002MY\t!Aj\u001c8h\u0003a9(/\u001b;uK:$v\u000eR;sC\ndWm\u0015;pe\u0006<W\rI\u0001\tC\u0012$\u0017i]=oGR\u0019\u0001kU+\u0011\u0007U\n\u0016*\u0003\u0002Sm\t\t2i\\7qY\u0016$\u0018M\u00197f\rV$XO]3\t\u000bQ;\u0001\u0019A%\u0002\u000f\t\fGo\u00195JI\")ak\u0002a\u0001/\u0006AQ.\u001a;bI\u0006$\u0018\r\u0005\u0002\u001e1&\u0011\u0011\f\u0004\u0002\u000f\u0007>lW.\u001b;NKR\fG-\u0019;b\u0003-\tG\rZ%o\u001b\u0016lwN]=\u0015\u0007q{\u0006\r\u0005\u0002K;&\u0011a\f\f\u0002\b\u0005>|G.Z1o\u0011\u0015!\u0006\u00021\u0001J\u0011\u00151\u0006\u00021\u0001X\u0003\u0015\u0001XO]4f)\t\u0019g\r\u0005\u0002KI&\u0011Q\r\f\u0002\u0005+:LG\u000fC\u0003h\u0013\u0001\u0007\u0011*\u0001\tuQJ,7\u000f[8mI\n\u000bGo\u00195JI\u0006A\u0012\r\u001a3OK^\u0014\u0015\r^2i\u0005f\u001cFO]3b[\u0006\u001b\u0018P\\2\u0015\u0005)<HCA6m!\r)\u0014\u000b\u0018\u0005\u0006[*\u0001\rA\\\u0001\u0003M:\u0004BAS8rG&\u0011\u0001\u000f\f\u0002\n\rVt7\r^5p]F\u0002\"A];\u000e\u0003MT!\u0001\u001e\u001e\u0002\u0005%|\u0017B\u0001<t\u00051yU\u000f\u001e9viN#(/Z1n\u0011\u0015!&\u00021\u0001J\u0001")
public class AsyncCommitLog
extends CommitLog {
    private final ThreadPoolExecutor executorService;
    private final ConcurrentLinkedDeque<Object> writtenToDurableStorage;

    public ConcurrentLinkedDeque<Object> writtenToDurableStorage() {
        return this.writtenToDurableStorage;
    }

    public CompletableFuture<Object> addAsync(long batchId, CommitMetadata metadata) {
        Predef$.MODULE$.require(metadata != null, (Function0 & Serializable)() -> "'null' metadata cannot be written to a metadata log");
        CompletionStage future = this.addNewBatchByStreamAsync(batchId, (Function1<OutputStream, BoxedUnit>)(Function1 & Serializable)output -> {
            this.serialize(metadata, output);
            return BoxedUnit.UNIT;
        }).thenApply(ret -> BoxesRunTime.boxToLong((long)AsyncCommitLog.$anonfun$addAsync$3(batchId, BoxesRunTime.unboxToBoolean((Object)ret))));
        this.batchCache().put(BoxesRunTime.boxToLong((long)batchId), metadata);
        return future;
    }

    public boolean addInMemory(long batchId, CommitMetadata metadata) {
        if (this.batchCache().containsKey(BoxesRunTime.boxToLong((long)batchId))) {
            return false;
        }
        this.batchCache().put(BoxesRunTime.boxToLong((long)batchId), metadata);
        return true;
    }

    @Override
    public void purge(long thresholdBatchId) {
        super.purge(thresholdBatchId);
    }

    private CompletableFuture<Object> addNewBatchByStreamAsync(long batchId, Function1<OutputStream, BoxedUnit> fn) {
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        Path batchMetadataFile = this.batchIdToPath(batchId);
        if (this.batchCache().containsKey(BoxesRunTime.boxToLong((long)batchId))) {
            future.complete(BoxesRunTime.boxToBoolean((boolean)false));
            return future;
        }
        this.executorService.submit(new Runnable(this, batchMetadataFile, future, fn, batchId){
            private final /* synthetic */ AsyncCommitLog $outer;
            private final Path batchMetadataFile$1;
            private final CompletableFuture future$1;
            private final Function1 fn$1;
            private final long batchId$2;

            public void run() {
                block3: {
                    try {
                        if (this.$outer.fileManager().exists(this.batchMetadataFile$1)) {
                            this.future$1.complete(BoxesRunTime.boxToBoolean((boolean)false));
                            break block3;
                        }
                        long start = System.currentTimeMillis();
                        this.$outer.write(this.batchMetadataFile$1, (Function1<OutputStream, BoxedUnit>)this.fn$1);
                        this.$outer.logDebug((Function0<String>)(Function0 & Serializable)() -> "Completion commit for batch " + $this.batchId$2 + " took " + (System.currentTimeMillis() - start) + " ms to be persisted to durable storage");
                        this.$outer.writtenToDurableStorage().add(BoxesRunTime.boxToLong((long)this.batchId$2));
                        this.future$1.complete(BoxesRunTime.boxToBoolean((boolean)true));
                    }
                    catch (Throwable e) {
                        this.$outer.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Encountered error while writing batch "}))).log((Seq)Nil$.MODULE$).$plus($this.$outer.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " to commit log"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{$this.$outer.MDC((LogKey)LogKeys.BATCH_ID, BoxesRunTime.boxToLong((long)$this.batchId$2))})))), e);
                        this.future$1.completeExceptionally(e);
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.batchMetadataFile$1 = batchMetadataFile$1;
                this.future$1 = future$1;
                this.fn$1 = fn$1;
                this.batchId$2 = batchId$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.spark.sql.execution.streaming.checkpointing.AsyncCommitLog$$anon$1 long ), $anonfun$run$2(org.apache.spark.sql.execution.streaming.checkpointing.AsyncCommitLog$$anon$1 )}, serializedLambda);
            }
        });
        return future;
    }

    public static final /* synthetic */ long $anonfun$addAsync$3(long batchId$1, boolean ret) {
        if (ret) {
            return batchId$1;
        }
        throw QueryExecutionErrors$.MODULE$.concurrentStreamLogUpdate(batchId$1);
    }

    public AsyncCommitLog(SparkSession sparkSession, String path, ThreadPoolExecutor executorService) {
        this.executorService = executorService;
        super(sparkSession, path);
        Predef$.MODULE$.assert(this.metadataCacheEnabled());
        this.writtenToDurableStorage = new ConcurrentLinkedDeque(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)Predef$.MODULE$.wrapLongArray(this.listBatchesOnDisk()).toList()).asJavaCollection());
    }
}

