/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.read.streaming.Offset;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.checkpointing.CommitMetadata;
import org.apache.spark.sql.execution.streaming.checkpointing.CommitMetadata$;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetMap;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeq;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeqBase;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeqControlBatchInfo;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeqMetadata;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeqMetadataBase;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeqMetadataV2;
import org.apache.spark.sql.execution.streaming.checkpointing.SourceMetadataInfo;
import org.apache.spark.sql.execution.streaming.runtime.StreamingQueryCheckpointMetadata;
import org.apache.spark.sql.execution.streaming.state.OfflineStateRepartitionErrors$;
import org.apache.spark.sql.execution.streaming.state.OfflineStateRepartitionRunner$;
import org.apache.spark.sql.execution.streaming.state.OfflineStateRepartitionUtils$;
import org.apache.spark.sql.execution.streaming.utils.StreamingUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005Mb\u0001B\f\u0019\u0001\u001dB\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\ts\u0001\u0011\t\u0011)A\u0005u!AQ\t\u0001B\u0001B\u0003%a\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003K\u0011\u0015i\u0005\u0001\"\u0001O\u0011\u001d)\u0006A1A\u0005\nYCaa\u0018\u0001!\u0002\u00139\u0006b\u00021\u0001\u0005\u0004%I!\u0019\u0005\u0007E\u0002\u0001\u000b\u0011\u0002\u001e\t\u000f\r\u0004!\u0019!C\u0005I\"11\u000e\u0001Q\u0001\n\u0015DQ\u0001\u001c\u0001\u0005\u00025DQ!\u001d\u0001\u0005\n5DQA\u001d\u0001\u0005\n5DQa\u001d\u0001\u0005\nQDQ!\u001f\u0001\u0005\niDq!!\u0001\u0001\t\u0013\t\u0019\u0001C\u0004\u0002\n\u0001!I!a\u0003\b\u0013\u0005M\u0001$!A\t\u0002\u0005Ua\u0001C\f\u0019\u0003\u0003E\t!a\u0006\t\r5#B\u0011AA\r\u0011%\tY\u0002FI\u0001\n\u0003\tiBA\u000fPM\u001ad\u0017N\\3Ti\u0006$XMU3qCJ$\u0018\u000e^5p]J+hN\\3s\u0015\tI\"$A\u0003ti\u0006$XM\u0003\u0002\u001c9\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003;y\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005}\u0001\u0013aA:rY*\u0011\u0011EI\u0001\u0006gB\f'o\u001b\u0006\u0003G\u0011\na!\u00199bG\",'\"A\u0013\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Ac\u0006\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0004B]f\u0014VM\u001a\t\u0003_Ij\u0011\u0001\r\u0006\u0003c\u0001\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003gA\u0012q\u0001T8hO&tw-\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u00027o5\ta$\u0003\u00029=\ta1\u000b]1sWN+7o]5p]\u0006\u00112\r[3dWB|\u0017N\u001c;M_\u000e\fG/[8o!\tY$I\u0004\u0002=\u0001B\u0011QHK\u0007\u0002})\u0011qHJ\u0001\u0007yI|w\u000e\u001e \n\u0005\u0005S\u0013A\u0002)sK\u0012,g-\u0003\u0002D\t\n11\u000b\u001e:j]\u001eT!!\u0011\u0016\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t!\tIs)\u0003\u0002IU\t\u0019\u0011J\u001c;\u0002-\u0015tgm\u001c:dK\u0016C\u0018m\u0019;ms>s7-Z*j].\u0004\"!K&\n\u00051S#a\u0002\"p_2,\u0017M\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b=\u000b&k\u0015+\u0011\u0005A\u0003Q\"\u0001\r\t\u000bQ*\u0001\u0019A\u001b\t\u000be*\u0001\u0019\u0001\u001e\t\u000b\u0015+\u0001\u0019\u0001$\t\u000f%+\u0001\u0013!a\u0001\u0015\u0006Q\u0001.\u00193p_B\u001cuN\u001c4\u0016\u0003]\u0003\"\u0001W/\u000e\u0003eS!AW.\u0002\t\r|gN\u001a\u0006\u00039\n\na\u0001[1e_>\u0004\u0018B\u00010Z\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u0006Y\u0001.\u00193p_B\u001cuN\u001c4!\u0003I\u0011Xm]8mm\u0016$7\t\u001d'pG\u0006$\u0018n\u001c8\u0016\u0003i\n1C]3t_24X\rZ\"q\u0019>\u001c\u0017\r^5p]\u0002\n!c\u00195fG.\u0004x.\u001b8u\u001b\u0016$\u0018\rZ1uCV\tQ\r\u0005\u0002gS6\tqM\u0003\u0002i5\u00059!/\u001e8uS6,\u0017B\u00016h\u0005\u0001\u001aFO]3b[&tw-U;fef\u001c\u0005.Z2la>Lg\u000e^'fi\u0006$\u0017\r^1\u0002'\rDWmY6q_&tG/T3uC\u0012\fG/\u0019\u0011\u0002\u0007I,h\u000eF\u0001o!\tIs.\u0003\u0002qU\t!Aj\u001c8h\u0003]9W\r\u001e'bgR\u001cu.\\7jiR,GMQ1uG\"LE-\u0001\bhKRd\u0015m\u001d;CCR\u001c\u0007.\u00133\u0002-\r\u0014X-\u0019;f\u001d\u0016<()\u0019;dQ&3g*Z3eK\u0012$2A\\;x\u0011\u00151x\u00021\u0001o\u0003-a\u0017m\u001d;CCR\u001c\u0007.\u00133\t\u000ba|\u0001\u0019\u00018\u0002)1\f7\u000f^\"p[6LG\u000f^3e\u0005\u0006$8\r[%e\u0003Y\u00198.\u001b9V]\u000e|W.\\5ui\u0016$')\u0019;dQ\u0016\u001cHcA>\u007f\u007fB\u0011\u0011\u0006`\u0005\u0003{*\u0012A!\u00168ji\")a\u000f\u0005a\u0001]\")\u0001\u0010\u0005a\u0001]\u0006y2M]3bi\u0016tUm\u001e\"bi\u000eDgI]8n\u0019\u0006\u001cHoQ8n[&$H/\u001a3\u0015\u000b9\f)!a\u0002\t\u000bY\f\u0002\u0019\u00018\t\u000ba\f\u0002\u0019\u00018\u0002\u0017\r|W.\\5u\u0005\u0006$8\r\u001b\u000b\u0006w\u00065\u0011\u0011\u0003\u0005\u0007\u0003\u001f\u0011\u0002\u0019\u00018\u0002\u00159,wOQ1uG\"LE\rC\u0003y%\u0001\u0007a.A\u000fPM\u001ad\u0017N\\3Ti\u0006$XMU3qCJ$\u0018\u000e^5p]J+hN\\3s!\t\u0001Fc\u0005\u0002\u0015QQ\u0011\u0011QC\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005}!f\u0001&\u0002\"-\u0012\u00111\u0005\t\u0005\u0003K\ty#\u0004\u0002\u0002()!\u0011\u0011FA\u0016\u0003%)hn\u00195fG.,GMC\u0002\u0002.)\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\t$a\n\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class OfflineStateRepartitionRunner
implements Logging {
    private final String checkpointLocation;
    private final int numPartitions;
    private final boolean enforceExactlyOnceSink;
    private final Configuration hadoopConf;
    private final String resolvedCpLocation;
    private final StreamingQueryCheckpointMetadata checkpointMetadata;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static boolean $lessinit$greater$default$4() {
        return OfflineStateRepartitionRunner$.MODULE$.$lessinit$greater$default$4();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Configuration hadoopConf() {
        return this.hadoopConf;
    }

    private String resolvedCpLocation() {
        return this.resolvedCpLocation;
    }

    private StreamingQueryCheckpointMetadata checkpointMetadata() {
        return this.checkpointMetadata;
    }

    public long run() {
        long l;
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Starting offline state repartitioning for "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"checkpointLocation=", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.CHECKPOINT_LOCATION, $this.checkpointLocation)}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"numPartitions=", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.NUM_PARTITIONS, BoxesRunTime.boxToInteger((int)$this.numPartitions))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"enforceExactlyOnceSink=", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.ENFORCE_EXACTLY_ONCE, BoxesRunTime.boxToBoolean((boolean)$this.enforceExactlyOnceSink))})))));
        try {
            Tuple2 tuple2 = Utils$.MODULE$.timeTakenMs((Function0)(JFunction0.mcJ.sp & Serializable)() -> {
                long lastCommittedBatchId = this.getLastCommittedBatchId();
                long lastBatchId = this.getLastBatchId();
                long newBatchId = this.createNewBatchIfNeeded(lastBatchId, lastCommittedBatchId);
                this.commitBatch(newBatchId, lastCommittedBatchId);
                return newBatchId;
            });
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long repartitionBatchId = tuple2._1$mcJ$sp();
            long durationMs = tuple2._2$mcJ$sp();
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(repartitionBatchId, durationMs);
            long repartitionBatchId2 = sp2._1$mcJ$sp();
            long durationMs2 = sp2._2$mcJ$sp();
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Completed state repartitioning for "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"checkpointLocation=", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.CHECKPOINT_LOCATION, $this.checkpointLocation)}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"numPartitions=", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.NUM_PARTITIONS, BoxesRunTime.boxToInteger((int)$this.numPartitions))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"enforceExactlyOnceSink=", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.ENFORCE_EXACTLY_ONCE, BoxesRunTime.boxToBoolean((boolean)$this.enforceExactlyOnceSink))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"repartitionBatchId=", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.BATCH_ID, BoxesRunTime.boxToLong((long)repartitionBatchId2))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"durationMs=", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.DURATION, BoxesRunTime.boxToLong((long)durationMs2))})))));
            l = repartitionBatchId2;
        }
        catch (Throwable e) {
            this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"State repartitioning failed for "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"checkpointLocation=", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.CHECKPOINT_LOCATION, $this.checkpointLocation)}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"numPartitions=", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.NUM_PARTITIONS, BoxesRunTime.boxToInteger((int)$this.numPartitions))})))), e);
            throw e;
        }
        return l;
    }

    private long getLastCommittedBatchId() {
        Option<Object> option = this.checkpointMetadata().commitLog().getLatestBatchId();
        if (option instanceof Some) {
            Some some = (Some)option;
            long id = BoxesRunTime.unboxToLong((Object)some.value());
            return id;
        }
        if (None$.MODULE$.equals(option)) {
            throw OfflineStateRepartitionErrors$.MODULE$.noCommittedBatchError(this.checkpointLocation);
        }
        throw new MatchError(option);
    }

    private long getLastBatchId() {
        Option<Object> option = this.checkpointMetadata().offsetLog().getLatestBatchId();
        if (option instanceof Some) {
            Some some = (Some)option;
            long id = BoxesRunTime.unboxToLong((Object)some.value());
            return id;
        }
        if (None$.MODULE$.equals(option)) {
            throw OfflineStateRepartitionErrors$.MODULE$.noBatchFoundError(this.checkpointLocation);
        }
        throw new MatchError(option);
    }

    private long createNewBatchIfNeeded(long lastBatchId, long lastCommittedBatchId) {
        if (lastBatchId == lastCommittedBatchId) {
            return this.createNewBatchFromLastCommitted(lastBatchId, lastCommittedBatchId);
        }
        if (OfflineStateRepartitionUtils$.MODULE$.isRepartitionBatch(lastBatchId, this.checkpointMetadata().offsetLog(), this.checkpointLocation)) {
            OffsetSeqBase lastBatch = (OffsetSeqBase)this.checkpointMetadata().offsetLog().get(lastBatchId).get();
            int lastBatchShufflePartitions = BoxesRunTime.unboxToInt((Object)OfflineStateRepartitionUtils$.MODULE$.getShufflePartitions((OffsetSeqMetadataBase)lastBatch.metadataOpt().get()).get());
            if (lastBatchShufflePartitions == this.numPartitions) {
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"The last batch is a failed repartition batch "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(batchId=", "). "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.BATCH_ID, BoxesRunTime.boxToLong((long)lastBatchId))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Retrying it since it used the same number of shuffle partitions "}))).log((Seq)Nil$.MODULE$)).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"as the requested ", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.NUM_PARTITIONS, BoxesRunTime.boxToInteger((int)$this.numPartitions))})))));
                return lastBatchId;
            }
            throw OfflineStateRepartitionErrors$.MODULE$.lastBatchAbandonedRepartitionError(this.checkpointLocation, lastBatchId, lastBatchShufflePartitions, this.numPartitions);
        }
        if (this.enforceExactlyOnceSink) {
            throw OfflineStateRepartitionErrors$.MODULE$.lastBatchFailedError(this.checkpointLocation, lastBatchId);
        }
        this.skipUncommittedBatches(lastBatchId, lastCommittedBatchId);
        return this.createNewBatchFromLastCommitted(lastBatchId, lastCommittedBatchId);
    }

    private void skipUncommittedBatches(long lastBatchId, long lastCommittedBatchId) {
        Predef$.MODULE$.assert(lastBatchId > lastCommittedBatchId, (Function0 & Serializable)() -> "Last batch ID must be greater than last committed batch ID");
        long fromBatchId = lastCommittedBatchId + 1L;
        new RichLong(Predef$.MODULE$.longWrapper(fromBatchId)).to((Object)BoxesRunTime.boxToLong((long)lastBatchId)).foreach$mVc$sp((Function1)(JFunction1.mcVJ.sp & Serializable)batchId -> {
            if (!this.checkpointMetadata().commitLog().add(batchId, new CommitMetadata(CommitMetadata$.MODULE$.apply$default$1(), CommitMetadata$.MODULE$.apply$default$2()))) {
                throw QueryExecutionErrors$.MODULE$.concurrentStreamLogUpdate(batchId);
            }
        });
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Skipped uncommitted batches from batchId "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " to ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.BATCH_ID, BoxesRunTime.boxToLong((long)fromBatchId)), this.MDC((LogKey)LogKeys.BATCH_ID, BoxesRunTime.boxToLong((long)lastBatchId))})))));
    }

    private long createNewBatchFromLastCommitted(long lastBatchId, long lastCommittedBatchId) {
        OffsetSeqBase offsetSeqBase;
        long newBatchId = lastBatchId + 1L;
        OffsetSeqBase lastCommittedOffsetSeq = (OffsetSeqBase)this.checkpointMetadata().offsetLog().get(lastCommittedBatchId).getOrElse((Function0 & Serializable)() -> {
            throw OfflineStateRepartitionErrors$.MODULE$.offsetSeqNotFoundError($this.checkpointLocation, lastCommittedBatchId);
        });
        OffsetSeqMetadataBase lastCommittedMetadata = (OffsetSeqMetadataBase)lastCommittedOffsetSeq.metadataOpt().getOrElse((Function0 & Serializable)() -> {
            throw OfflineStateRepartitionErrors$.MODULE$.missingOffsetSeqMetadataError($this.checkpointLocation, 1, lastCommittedBatchId);
        });
        if (BoxesRunTime.unboxToInt((Object)OfflineStateRepartitionUtils$.MODULE$.getShufflePartitions(lastCommittedMetadata).get()) == this.numPartitions) {
            throw OfflineStateRepartitionErrors$.MODULE$.shufflePartitionsAlreadyMatchError(this.checkpointLocation, lastCommittedBatchId, this.numPartitions);
        }
        OffsetSeqBase offsetSeqBase2 = lastCommittedOffsetSeq;
        if (offsetSeqBase2 instanceof OffsetSeq) {
            OffsetSeq offsetSeq = (OffsetSeq)offsetSeqBase2;
            OffsetSeqMetadata metadata = (OffsetSeqMetadata)offsetSeq.metadataOpt().get();
            scala.collection.immutable.Map x$1 = (scala.collection.immutable.Map)metadata.conf().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.SHUFFLE_PARTITIONS().key()), (Object)Integer.toString(this.numPartitions)));
            long x$2 = metadata.copy$default$1();
            long x$3 = metadata.copy$default$2();
            Some x$4 = new Some((Object)metadata.copy(x$2, x$3, (scala.collection.immutable.Map<String, String>)x$1));
            Seq<Option<Offset>> x$5 = offsetSeq.copy$default$1();
            offsetSeqBase = offsetSeq.copy(x$5, (Option<OffsetSeqMetadata>)x$4);
        } else if (offsetSeqBase2 instanceof OffsetMap) {
            OffsetMap offsetMap = (OffsetMap)offsetSeqBase2;
            scala.collection.immutable.Map x$6 = (scala.collection.immutable.Map)offsetMap.metadata().conf().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.SHUFFLE_PARTITIONS().key()), (Object)Integer.toString(this.numPartitions)));
            long x$7 = offsetMap.metadata().copy$default$1();
            long x$8 = offsetMap.metadata().copy$default$2();
            scala.collection.immutable.Map<String, SourceMetadataInfo> x$9 = offsetMap.metadata().copy$default$4();
            Option<OffsetSeqControlBatchInfo> x$10 = offsetMap.metadata().copy$default$5();
            OffsetSeqMetadataV2 x$11 = offsetMap.metadata().copy(x$7, x$8, (scala.collection.immutable.Map<String, String>)x$6, x$9, x$10);
            scala.collection.immutable.Map<String, Option<Offset>> x$12 = offsetMap.copy$default$1();
            offsetSeqBase = offsetMap.copy(x$12, x$11);
        } else {
            throw OfflineStateRepartitionErrors$.MODULE$.unsupportedOffsetSeqVersionError(this.checkpointLocation, -1);
        }
        OffsetSeq newOffsetSeq = offsetSeqBase;
        if (!this.checkpointMetadata().offsetLog().add(newBatchId, newOffsetSeq)) {
            throw QueryExecutionErrors$.MODULE$.concurrentStreamLogUpdate(newBatchId);
        }
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Created new offset log entry for repartition batch. "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"batchId=", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.BATCH_ID, BoxesRunTime.boxToLong((long)newBatchId))})))));
        return newBatchId;
    }

    private void commitBatch(long newBatchId, long lastCommittedBatchId) {
        CommitMetadata latestCommit = (CommitMetadata)this.checkpointMetadata().commitLog().get(lastCommittedBatchId).get();
        if (!this.checkpointMetadata().commitLog().add(newBatchId, latestCommit)) {
            throw QueryExecutionErrors$.MODULE$.concurrentStreamLogUpdate(newBatchId);
        }
    }

    public OfflineStateRepartitionRunner(SparkSession sparkSession, String checkpointLocation, int numPartitions, boolean enforceExactlyOnceSink) {
        this.checkpointLocation = checkpointLocation;
        this.numPartitions = numPartitions;
        this.enforceExactlyOnceSink = enforceExactlyOnceSink;
        Logging.$init$((Logging)this);
        this.hadoopConf = sparkSession.sessionState().newHadoopConf();
        this.resolvedCpLocation = StreamingUtils$.MODULE$.resolvedCheckpointLocation(this.hadoopConf(), checkpointLocation);
        this.checkpointMetadata = new StreamingQueryCheckpointMetadata(sparkSession, this.resolvedCpLocation());
    }
}

