/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetMap;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeq;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeqBase;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeqLog;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeqMetadataBase;
import org.apache.spark.sql.execution.streaming.state.OfflineStateRepartitionErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;

public final class OfflineStateRepartitionUtils$ {
    public static final OfflineStateRepartitionUtils$ MODULE$ = new OfflineStateRepartitionUtils$();

    public boolean isRepartitionBatch(long batchId, OffsetSeqLog offsetLog, String checkpointLocation) {
        Predef$.MODULE$.assert(batchId >= 0L, (Function0 & Serializable)() -> "Batch ID must be non-negative");
        long l = batchId;
        if (0L == l) {
            return false;
        }
        OffsetSeqBase batch = (OffsetSeqBase)offsetLog.get(batchId).getOrElse((Function0 & Serializable)() -> {
            throw OfflineStateRepartitionErrors$.MODULE$.offsetSeqNotFoundError(checkpointLocation, batchId);
        });
        long prevBatchId = batchId - 1L;
        OffsetSeqBase previousBatch = (OffsetSeqBase)offsetLog.get(prevBatchId).getOrElse((Function0 & Serializable)() -> {
            throw OfflineStateRepartitionErrors$.MODULE$.offsetSeqNotFoundError(checkpointLocation, prevBatchId);
        });
        OffsetSeqBase offsetSeqBase = batch;
        int batchVersion = offsetSeqBase instanceof OffsetSeq ? 1 : (offsetSeqBase instanceof OffsetMap ? 2 : -1);
        OffsetSeqMetadataBase batchMetadata = (OffsetSeqMetadataBase)batch.metadataOpt().getOrElse((Function0 & Serializable)() -> {
            throw OfflineStateRepartitionErrors$.MODULE$.missingOffsetSeqMetadataError(checkpointLocation, batchVersion, batchId);
        });
        int shufflePartitions = BoxesRunTime.unboxToInt((Object)this.getShufflePartitions(batchMetadata).get());
        OffsetSeqBase offsetSeqBase2 = previousBatch;
        int prevBatchVersion = offsetSeqBase2 instanceof OffsetSeq ? 1 : (offsetSeqBase2 instanceof OffsetMap ? 2 : -1);
        OffsetSeqMetadataBase previousBatchMetadata = (OffsetSeqMetadataBase)previousBatch.metadataOpt().getOrElse((Function0 & Serializable)() -> {
            throw OfflineStateRepartitionErrors$.MODULE$.missingOffsetSeqMetadataError(checkpointLocation, prevBatchVersion, prevBatchId);
        });
        int previousShufflePartitions = BoxesRunTime.unboxToInt((Object)this.getShufflePartitions(previousBatchMetadata).get());
        return previousShufflePartitions != shufflePartitions;
    }

    public Option<Object> getShufflePartitions(OffsetSeqMetadataBase metadata) {
        return metadata.conf().get((Object)SQLConf$.MODULE$.SHUFFLE_PARTITIONS().key()).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$2))));
    }

    private OfflineStateRepartitionUtils$() {
    }
}

